/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.authentication;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.HashUtils;
import com.ibm.ws.security.common.random.RandomUtils;
import com.ibm.ws.security.common.web.WebUtils;
import io.openliberty.security.oidcclientcore.utils.Utils;
import jakarta.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthorizationRequestUtils {
    public static final TraceComponent tc = Tr.register(AuthorizationRequestUtils.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    public static final int STATE_LENGTH = 9;
    public static final int NONCE_LENGTH = 30;
    static final long serialVersionUID = 2077747502570064957L;

    public String generateStateValue(HttpServletRequest request) {
        String strRandom = RandomUtils.getRandomAlphaNumeric((int)9);
        String timestamp = Utils.getTimeStamp();
        String state = timestamp + strRandom;
        if (request != null && !request.getMethod().equalsIgnoreCase("GET") && request.getParameter("oidc_client") != null) {
            state = state + request.getParameter("oidc_client");
        }
        return state;
    }

    @Sensitive
    @Trivial
    public static String createStateValueForStorage(String clientSecret, String state) {
        String timestamp = state.substring(0, 15);
        String newValue = state + clientSecret;
        String value = HashUtils.digest((String)newValue);
        return timestamp + value;
    }

    public String generateNonceValue() {
        return RandomUtils.getRandomAlphaNumeric((int)30);
    }

    public String getRequestUrl(HttpServletRequest request) {
        Integer realPort = this.getRealPort(request);
        int serverPort = request.getServerPort();
        StringBuffer requestURL = request.getRequestURL();
        if (this.shouldRewritePort(realPort, serverPort)) {
            requestURL = this.rewritePortInRequestOrigin(request, realPort);
        }
        requestURL = this.appendQueryString(request, requestURL);
        return requestURL.toString();
    }

    public String getBaseURL(HttpServletRequest request) {
        int serverPort;
        Integer realPort = this.getRealPort(request);
        StringBuffer baseURL = this.rewritePortInBaseURL(request, this.shouldRewritePort(realPort, serverPort = request.getServerPort()) ? realPort : serverPort);
        return baseURL.toString();
    }

    Integer getRealPort(HttpServletRequest request) {
        Integer realPort = null;
        if (request.getScheme().toLowerCase().contains("https")) {
            realPort = this.getWebUtils().getRedirectPortFromRequest(request);
        }
        return realPort;
    }

    WebUtils getWebUtils() {
        return new WebUtils();
    }

    boolean shouldRewritePort(Integer realPort, int serverPort) {
        if (realPort != null && realPort != serverPort) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("serverport = " + serverPort + "real port is " + realPort.toString() + ", url will be rewritten to use real port"), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    StringBuffer rewritePortInRequestURL(HttpServletRequest request, int realPort) {
        StringBuffer requestURL = this.rewritePortInRequestOrigin(request, realPort);
        requestURL.append(request.getRequestURI());
        return requestURL;
    }

    StringBuffer rewritePortInBaseURL(HttpServletRequest request, int realPort) {
        StringBuffer baseURL = this.rewritePortInRequestOrigin(request, realPort);
        baseURL.append(request.getContextPath());
        return baseURL;
    }

    StringBuffer rewritePortInRequestOrigin(HttpServletRequest request, int realPort) {
        StringBuffer requestOrigin = new StringBuffer();
        requestOrigin.append(request.getScheme());
        requestOrigin.append("://");
        requestOrigin.append(request.getServerName());
        requestOrigin.append(":");
        requestOrigin.append(realPort);
        return requestOrigin;
    }

    StringBuffer appendQueryString(HttpServletRequest request, StringBuffer requestURL) {
        String queryString = request.getQueryString();
        if (queryString != null) {
            requestURL.append("?");
            requestURL.append(queryString);
        }
        return requestURL;
    }
}

