/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.giop;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.giop.ReplyStatus;
import org.apache.yoko.giop.ServiceContextTag;
import org.apache.yoko.io.AlignmentBoundary;
import org.apache.yoko.io.Buffer;
import org.apache.yoko.io.ReadBuffer;
import org.apache.yoko.io.WriteBuffer;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.omg.CORBA.MARSHAL;

public enum MessageType {
    REQUEST(0){

        @Override
        void describeHeader(StringBuilder sb, InputStream in, GiopVersion version) {
            switch (version) {
                case GIOP1_0: 
                case GIOP1_1: {
                    MessageType.describeServiceContextList(sb, in);
                    MessageType.describeReqId(sb, in);
                    this.describeResponseExpected(sb, in);
                    MessageType.describeObjectKey(sb, in);
                    StringField.OPERATION.describeString(sb, "\t", in);
                    this.describePrincipal(sb, in);
                    return;
                }
            }
            MessageType.describeReqId(sb, in);
            this.describeResponseFlags(sb, in);
            in._OB_skip(3);
            MessageType.describeTargetAddress(sb, in);
            StringField.OPERATION.describeString(sb, "\t", in);
            MessageType.describeServiceContextList(sb, in);
            if (0 != in.available()) {
                in.skipAlign(AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
            }
        }

        void describeResponseExpected(StringBuilder sb, InputStream in) {
            sb.append(String.format("%n\tRESPONSE EXPECTED = %b", in.read_boolean()));
        }

        void describeResponseFlags(StringBuilder sb, InputStream in) {
            sb.append(String.format("%n\tRESPONSE FLAGS = 0x%02x", in.read_octet()));
        }

        void describePrincipal(StringBuilder sb, InputStream in) {
            sb.append(String.format("%n\tREQUESTING PRINCIPAL:", new Object[0]));
            MessageType.describeOctetSeq(sb, "\t\t", in);
        }
    }
    ,
    REPLY(1){

        @Override
        void describeHeader(StringBuilder sb, InputStream in, GiopVersion version) {
            switch (version) {
                case GIOP1_0: 
                case GIOP1_1: {
                    MessageType.describeServiceContextList(sb, in);
                    MessageType.describeReqId(sb, in);
                    this.describeReplyStatus(sb, in);
                    return;
                }
            }
            MessageType.describeReqId(sb, in);
            this.describeReplyStatus(sb, in);
            MessageType.describeServiceContextList(sb, in);
            if (0 != in.available()) {
                in.skipAlign(AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
            }
        }

        void describeReplyStatus(StringBuilder sb, InputStream in) {
            ReplyStatus status = ReplyStatus.valueOf(in.read_long());
            sb.append(String.format("%n\tREPLY STATUS = %s", new Object[]{status}));
        }
    }
    ,
    CANCEL_REQUEST(2){

        @Override
        void describeHeader(StringBuilder sb, InputStream in, GiopVersion version) {
            MessageType.describeReqId(sb, in);
        }
    }
    ,
    LOCATE_REQUEST(3){

        @Override
        void describeHeader(StringBuilder sb, InputStream in, GiopVersion version) {
            switch (version) {
                case GIOP1_0: 
                case GIOP1_1: {
                    MessageType.describeReqId(sb, in);
                    MessageType.describeObjectKey(sb, in);
                    return;
                }
            }
            MessageType.describeReqId(sb, in);
            MessageType.describeTargetAddress(sb, in);
        }
    }
    ,
    LOCATE_REPLY(4){

        @Override
        void describeHeader(StringBuilder sb, InputStream in, GiopVersion version) {
            MessageType.describeReqId(sb, in);
            sb.append(String.format("%n\t%s", this.getLocateStatus(in)));
        }

        String getLocateStatus(InputStream in) {
            int locStat = in.read_long();
            switch (locStat) {
                case 0: {
                    return "LOCATE STATUS = UNKNOWN_OBJECT";
                }
                case 2: {
                    return "LOCATE STATUS = OBJECT_FORWARD";
                }
                case 1: {
                    return "LOCATE STATUS = OBJECT_HERE";
                }
                case 3: {
                    return "LOCATE STATUS = OBJECT_FORWARD_PERM";
                }
                case 4: {
                    return "LOCATE STATUS = LOC_SYSTEM_EXCEPTION";
                }
                case 5: {
                    return "LOCATE STATUS = LOC_NEEDS_ADDRESSING_MODE";
                }
            }
            return String.format("error parsing locate status flag: 0x%08x", locStat);
        }
    }
    ,
    CLOSE_CONNECTION(5),
    MESSAGE_ERROR(6),
    FRAGMENT(7){

        @Override
        void describeHeader(StringBuilder sb, InputStream in, GiopVersion version) {
            if (version == GiopVersion.GIOP1_2) {
                MessageType.describeReqId(sb, in);
            }
        }
    }
    ,
    UNKNOWN;

    private static final int LITTLE_ENDIAN_FLAG = 1;
    private static final int FRAG_FLAG = 2;
    private static final String EOL;
    public final int id;
    public final boolean fragmentable;

    private MessageType(int id) {
        this.id = id;
        this.fragmentable = id == 0 || id == 1;
    }

    private MessageType() {
        this(-1);
    }

    public static void logIncomingGiopMessage(WriteBuffer buffer) {
        MessageType.logGiopMessage(buffer, VerboseLogging.DATA_IN_LOG, "\nIN COMING ");
    }

    public static void logOutgoingGiopMessage(ReadBuffer buffer) {
        MessageType.logGiopMessage(buffer, VerboseLogging.DATA_OUT_LOG, "\nOUT GOING ");
    }

    private static void logGiopMessage(Buffer<?> buffer, Logger logger, String direction) {
        Level level;
        boolean includeMessageOctets;
        boolean includeMessageHeader;
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            includeMessageHeader = true;
            includeMessageOctets = true;
            level = Level.FINEST;
        } else if (logger.isLoggable(Level.FINER)) {
            includeMessageHeader = false;
            includeMessageOctets = true;
            level = Level.FINER;
        } else {
            includeMessageHeader = false;
            includeMessageOctets = false;
            level = Level.FINE;
        }
        logger.log(level, MessageType.describeGiopMessage(buffer, includeMessageHeader, includeMessageOctets));
    }

    private static String describeGiopMessage(Buffer<?> buffer, boolean includeMessageHeader, boolean includeMessageOctets) {
        StringBuilder sb = new StringBuilder();
        try {
            InputStream in = new InputStream(buffer.newReadBuffer());
            in._OB_skip(4);
            byte major = in.read_octet();
            byte minor = in.read_octet();
            GiopVersion version = GiopVersion.get(major, minor);
            byte flags = in.read_octet();
            in._OB_swap((flags & 1) == 1);
            MessageType type = MessageType.valueOf(in.read_octet());
            int size = in.read_long();
            type.describeGiopHeader(sb, major, minor, version, flags, size);
            if (includeMessageHeader) {
                type.describeHeader(sb, in, version);
            } else {
                in._OB_skip(in.available());
            }
            if (includeMessageOctets) {
                MessageType.dumpHex(sb, in);
            }
        }
        catch (Throwable t) {
            sb.append(EOL).append("describeMessage() failed with ").append(t);
            Arrays.stream(t.getStackTrace()).map(e -> EOL + "\t" + e).forEach(sb::append);
        }
        return sb.toString();
    }

    private void describeGiopHeader(StringBuilder sb, byte major, byte minor, GiopVersion version, byte flags, int size) {
        sb.append(String.format("GIOP %d.%d %s MESSAGE%n\tSIZE = %d", new Object[]{major, minor, this, size}));
        if (this.fragmentable && version != GiopVersion.GIOP1_0) {
            sb.append(String.format("%n\tFRAGMENT_TO_FOLLOW = %s", (flags & 2) == 2));
        }
    }

    void describeHeader(StringBuilder sb, InputStream in, GiopVersion version) {
    }

    private static void dumpHex(StringBuilder sb, InputStream in) {
        sb.append(EOL);
        if (in.available() == 0) {
            in.dumpAllData(sb);
        } else {
            in.dumpAllDataWithPosition(sb, "body");
        }
    }

    private static void describeObjectKey(StringBuilder sb, InputStream in) {
        sb.append(String.format("%n\tOBJECT KEY:", new Object[0]));
        MessageType.describeOctetSeq(sb, "\t\t", in);
    }

    private static void describeTargetAddress(StringBuilder sb, InputStream in) {
        short disposition = in.read_short();
        switch (disposition) {
            case 0: {
                sb.append(String.format("%n\tKEY ADDRESS:", new Object[0]));
                MessageType.describeOctetSeq(sb, "\t\t", in);
                return;
            }
            case 1: {
                sb.append(String.format("%n\tPROFILE ADDRESS:", new Object[0]));
                MessageType.describeTaggedProfile(sb, "\t\t", in);
                return;
            }
            case 2: {
                sb.append(String.format("%n\tREFERENCE ADDRESS: INDEX = %d", in.read_long()));
                MessageType.describeIor(sb, "\t\t", in);
                return;
            }
        }
        sb.append(String.format("%n\tERROR: TargetAddress has unknown disposition 0x%04x", disposition));
    }

    private static void describeServiceContextList(StringBuilder sb, InputStream in) {
        int len = in.read_long();
        for (int i = 1; i <= len; ++i) {
            sb.append(EOL).append("\t").append("SERVICE CONTEXT ").append(i).append(" OF ").append(len);
            MessageType.describeServiceContext(sb, in);
        }
    }

    private static void describeServiceContext(StringBuilder sb, InputStream in) {
        sb.append(" TAG = ");
        MessageType.describeServiceContextId(sb, in.read_long());
        MessageType.describeOctetSeq(sb, "\t\t", in);
    }

    private static void describeServiceContextId(StringBuilder sb, int tag) {
        sb.append(String.format("0x%08x (%s)", new Object[]{tag, ServiceContextTag.valueOf(tag)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void describeOctetSeq(StringBuilder sb, String indent, InputStream in) {
        int len = in.read_long();
        sb.append(String.format(" [0x%08x octets]", len));
        if (len == 0) {
            return;
        }
        sb.append(EOL);
        if (len > in.available()) {
            sb.append(indent).append("ERROR reading octet sequence of length ").append(len);
            sb.append(" when only ").append(in.available()).append(" bytes are available in the buffer");
            return;
        }
        try {
            in.getBuffer().dumpSomeData(sb, indent, len);
        }
        finally {
            in._OB_skip(len);
        }
    }

    private static void describeTaggedProfile(StringBuilder sb, String indent, InputStream in) {
        sb.append(String.format("%n%sID = 0x%08x", indent, in.read_long()));
        MessageType.describeOctetSeq(sb, indent, in);
    }

    private static void describeTaggedProfileSeq(StringBuilder sb, String indent, InputStream in) {
        int len = in.read_long();
        for (int i = 1; i <= len; ++i) {
            sb.append(indent);
            sb.append("TAGGED PROFILE ");
            sb.append(i);
            sb.append(" OF ");
            sb.append(len);
            sb.append(EOL);
            MessageType.describeTaggedProfile(sb, indent + "\t", in);
        }
    }

    private static void describeIor(StringBuilder sb, String indent, InputStream in) {
        sb.append(String.format("%n%sTYPE ID:", indent));
        MessageType.describeOctetSeq(sb, indent + "\t", in);
        MessageType.describeTaggedProfileSeq(sb, indent, in);
    }

    private static void describeReqId(StringBuilder sb, InputStream in) {
        sb.append(String.format("%n\tREQUEST ID = %d", in.read_long()));
    }

    public static MessageType valueOf(int i) {
        switch (i) {
            case 0: {
                return REQUEST;
            }
            case 1: {
                return REPLY;
            }
            case 2: {
                return CANCEL_REQUEST;
            }
            case 3: {
                return LOCATE_REQUEST;
            }
            case 4: {
                return LOCATE_REPLY;
            }
            case 5: {
                return CLOSE_CONNECTION;
            }
            case 6: {
                return MESSAGE_ERROR;
            }
            case 7: {
                return FRAGMENT;
            }
        }
        return UNKNOWN;
    }

    static {
        EOL = String.format("%n", new Object[0]);
    }

    static enum StringField {
        OPERATION;


        private void describeString(StringBuilder sb, String indent, InputStream in) {
            int start = in.getBuffer().getPosition();
            try {
                String value = in.read_string();
                sb.append(String.format("%n%s%s = %s", new Object[]{indent, this, value}));
            }
            catch (MARSHAL m) {
                int pos = in.getBuffer().getPosition();
                sb.append(String.format("%n%s%s: error reading string at 0x%h, failed at 0x%h%n", new Object[]{indent, this, start, pos}));
            }
        }
    }
}

