/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.Paths;

public class PathsValidator
extends TypeValidator<Paths> {
    private static final TraceComponent tc = Tr.register(PathsValidator.class);
    private static final PathsValidator INSTANCE = new PathsValidator();

    public static PathsValidator getInstance() {
        return INSTANCE;
    }

    private PathsValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Paths t) {
        if (t != null) {
            boolean mapContainsInvalidKey = false;
            for (String path : t.keySet()) {
                if (path != null && !path.isEmpty()) {
                    String message;
                    if (!path.startsWith("/")) {
                        message = Tr.formatMessage((TraceComponent)tc, (String)"pathsRequiresSlash", (Object[])new Object[]{path});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(path), message));
                    }
                    if (t.get((Object)path) != null) continue;
                    message = Tr.formatMessage((TraceComponent)tc, (String)"nullValueInMap", (Object[])new Object[]{path});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(path), message));
                    continue;
                }
                mapContainsInvalidKey = true;
            }
            if (mapContainsInvalidKey) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"nullOrEmptyKeyInMap", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }
}

