/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import java.util.ArrayList;
import java.util.Iterator;

public class UtilsChainListener {
    private static final TraceComponent tc = Tr.register(UtilsChainListener.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private final ArrayList<String> waitingChainNames = new ArrayList();

    public void watchChain(ChainData chain) {
        this.waitingChainNames.add(chain.getName());
    }

    public void waitOnChains(long quiesceTimeout) {
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        int elapsedTime = 0;
        if (this.waitingChainNames.size() > 0 && (long)elapsedTime < quiesceTimeout) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Waiting on " + this.waitingChainNames.size() + " chain(s) to stop"), (Object[])new Object[0]);
            }
            Iterator<String> iter = this.waitingChainNames.iterator();
            while (iter.hasNext()) {
                if (cf.isChainRunning(iter.next())) continue;
                iter.remove();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            elapsedTime += 1000;
        }
    }
}

