/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.serialization.DeserializationObjectInputStream;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.ObjectFailedToSerializeException;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.mfp.schema.JmsObjectBodyAccess;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class JsJmsObjectMessageImpl
extends JsJmsMessageImpl
implements JsJmsObjectMessage {
    private static final long serialVersionUID = 1L;
    private static final byte[] flattenedClassName;
    private static final int DESERIALIZATION_MULTIPLIER = 4;
    private static TraceComponent tc;
    private transient Serializable realObject;
    private transient boolean hasRealObject;
    private transient boolean hasSerializedRealObject;
    private transient SoftReference<Serializable> softRefToRealObject = null;

    JsJmsObjectMessageImpl() {
    }

    JsJmsObjectMessageImpl(int flag) throws MessageDecodeFailedException {
        super(flag);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.setFormat("JMS:object");
        this.setBodyType(JmsBodyType.OBJECT);
        if (flag != 2) {
            this.jmo.getPayloadPart().setPart(1, JmsObjectBodyAccess.schema);
            this.clearBody();
        }
    }

    JsJmsObjectMessageImpl(JsMsgObject inJmo) {
        super(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>, inbound jmo ");
        }
    }

    @Override
    public byte[] getSerializedObject() throws ObjectFailedToSerializeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSerializedObject");
        }
        if (this.hasRealObject && !this.hasSerializedRealObject) {
            this.serializeRealObject();
        }
        byte[] bytes = this.getDataFromPayload();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSerializedObject");
        }
        return bytes;
    }

    @Override
    public void setSerializedObject(byte[] payload) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSerializedObject", (Object)payload);
        }
        this.getPayload().setField(0, payload);
        this.realObject = null;
        this.hasRealObject = false;
        this.hasSerializedRealObject = false;
        this.softRefToRealObject = null;
        this.clearCachedLengths();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSerializedObject");
        }
    }

    @Override
    public Serializable getRealObject() throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRealObject");
        }
        Serializable obj = null;
        if (this.hasRealObject) {
            obj = this.realObject;
            if (obj == null && this.hasSerializedRealObject && this.softRefToRealObject != null && (obj = this.softRefToRealObject.get()) == null) {
                obj = this.deserializeToRealObject();
            }
        } else {
            obj = this.deserializeToRealObject();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRealObject", (Object)(obj == null ? "null" : obj.getClass()));
        }
        return obj;
    }

    @Override
    public void setRealObject(Serializable obj) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRealObject", (Object)(obj == null ? "null" : obj.getClass()));
        }
        this.realObject = obj;
        this.hasRealObject = true;
        this.hasSerializedRealObject = false;
        this.softRefToRealObject = null;
        this.getPayload().setChoiceField(1, 0);
        this.clearCachedLengths();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRealObject");
        }
    }

    @Override
    public void clearBody() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
        this.getPayload().setChoiceField(1, 0);
        this.realObject = null;
        this.hasRealObject = false;
        this.hasSerializedRealObject = false;
        this.softRefToRealObject = null;
        this.clearCachedLengths();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
    }

    @Override
    int guessPayloadLength() {
        int length = 0;
        byte[] payload = this.getDataFromPayload();
        if (payload != null) {
            length = payload.length + 24;
        }
        return length;
    }

    @Override
    int guessFluffedDataSize() {
        int payloadSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"guessFluffedDataSize");
        }
        int total = 0;
        JsMsgPart part = this.getPayloadIfFluffed();
        total = part != null ? (total += part.estimateFieldValueSize(0) * 4) : ((payloadSize = this.jmo.getPayloadPart().getAssembledLengthIfKnown()) != -1 ? (total += (payloadSize - 40) * 4) : (total += this.getPayload().estimateFieldValueSize(0) * 4));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"guessFluffedDataSize", (Object)total);
        }
        return total;
    }

    JsMsgPart getPayload() {
        return this.getPayload(JmsObjectBodyAccess.schema);
    }

    @Override
    final byte[] getFlattenedClassName() {
        return flattenedClassName;
    }

    private final byte[] getDataFromPayload() {
        return (byte[])this.getPayload().getField(0);
    }

    private void serializeRealObject() throws ObjectFailedToSerializeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"serializeRealObject");
        }
        if (this.hasRealObject) {
            if (this.realObject != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(this.realObject);
                    this.getPayload().setField(0, baos.toByteArray());
                    this.hasSerializedRealObject = true;
                    this.softRefToRealObject = new SoftReference<Serializable>(this.realObject);
                    this.realObject = null;
                }
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.sib.mfp.impl.JsJmsObjectMessageImpl.serializeRealObject", (String)"296");
                    String objectClassName = this.realObject.getClass().getName();
                    throw new ObjectFailedToSerializeException(ioe, objectClassName);
                }
            } else {
                this.getPayload().setField(0, null);
                this.hasSerializedRealObject = true;
            }
        }
        this.clearCachedLengths();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"serializeRealObject");
        }
    }

    private Serializable deserializeToRealObject() throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deserializeToRealObject");
        }
        Object obj = null;
        ObjectInputStream ois = null;
        byte[] bytes = this.getDataFromPayload();
        if (bytes != null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                ois = new DeserializationObjectInputStream((InputStream)bais, cl);
                obj = (Serializable)ois.readObject();
                this.hasRealObject = true;
                this.hasSerializedRealObject = true;
                this.softRefToRealObject = new SoftReference<Object>(obj);
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.sib.mfp.impl.JsJmsObjectMessageImpl.deserializeToRealObject", (String)"340");
                throw ioe;
            }
            catch (ClassNotFoundException cnfe) {
                FFDCFilter.processException((Throwable)cnfe, (String)"com.ibm.ws.sib.mfp.impl.JsJmsObjectMessageImpl.deserializeToRealObject", (String)"345");
                throw cnfe;
            }
            finally {
                block15: {
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception closing the ObjectInputStream", (Object)ex);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deserializeToRealObject", (Object)(obj == null ? "null" : obj.getClass()));
        }
        return obj;
    }

    @Override
    void updateDataFields(int why) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateDataFields", (Object)why);
        }
        super.updateDataFields(why);
        if (this.hasRealObject && !this.hasSerializedRealObject && (why == 2 || why == 1 || why == 3)) {
            try {
                this.serializeRealObject();
            }
            catch (ObjectFailedToSerializeException ofse) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Payload object serialization failed so payload will be empty.");
                }
                this.realObject = null;
                this.getPayload().setField(0, null);
                this.hasRealObject = false;
                this.setExceptionReason(ofse.getExceptionReason());
                this.setExceptionInserts(ofse.getExceptionInserts());
                this.setExceptionTimestamp(System.currentTimeMillis());
                this.setExceptionProblemDestination(null);
                this.setExceptionProblemSubscription(null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateDataFields");
        }
    }

    @Override
    void copyTransients(JsMessageImpl copy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"copyTransients");
        }
        super.copyTransients(copy);
        JsJmsObjectMessageImpl other = (JsJmsObjectMessageImpl)copy;
        other.realObject = this.realObject;
        other.hasRealObject = this.hasRealObject;
        other.hasSerializedRealObject = this.hasSerializedRealObject;
        other.softRefToRealObject = this.softRefToRealObject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"copyTransients");
        }
    }

    static {
        tc = SibTr.register(JsJmsObjectMessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
        flattenedClassName = JsJmsObjectMessageImpl.flattenClassName(JsJmsObjectMessageImpl.class.getName());
    }
}

