/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.http.proxyredirect"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={HttpProxyRedirect.class}, property={"service.vendor=IBM"})
public class HttpProxyRedirect {
    private static final TraceComponent tc = Tr.register(HttpProxyRedirect.class, (String)"HTTPTransport");
    static final String PROP_ENABLED = "enabled";
    static final String PROP_HOST = "host";
    static final String PROP_HTTP_PORT = "httpPort";
    static final String PROP_HTTPS_PORT = "httpsPort";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String STAR = "*";
    private static final Map<Integer, Map<String, HttpProxyRedirect>> map = new HashMap<Integer, Map<String, HttpProxyRedirect>>();
    private boolean enabled;
    private int httpPort;
    private int httpsPort;
    private String host;
    static final long serialVersionUID = -2297561299172819453L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getRedirectPort(String host, int httpPort) {
        Integer httpsPort = null;
        Map<Integer, Map<String, HttpProxyRedirect>> map = HttpProxyRedirect.map;
        synchronized (map) {
            if (httpPort == 80 && HttpProxyRedirect.map.get(httpPort) == null) {
                httpsPort = 443;
            } else {
                Map<String, HttpProxyRedirect> redirectsForThisPort = HttpProxyRedirect.map.get(httpPort);
                if (redirectsForThisPort != null) {
                    HttpProxyRedirect hdr = redirectsForThisPort.get(host);
                    if (hdr == null) {
                        hdr = redirectsForThisPort.get(STAR);
                    }
                    if (hdr != null && hdr.enabled) {
                        httpsPort = hdr.httpsPort;
                    }
                }
            }
        }
        return httpsPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putProxyRedirect(HttpProxyRedirect proxyRedirect) {
        Map<Integer, Map<String, HttpProxyRedirect>> map = HttpProxyRedirect.map;
        synchronized (map) {
            HttpProxyRedirect oldRedirect;
            Map<String, HttpProxyRedirect> redirectsForThisPort = HttpProxyRedirect.map.get(proxyRedirect.httpPort);
            if (redirectsForThisPort == null) {
                redirectsForThisPort = new HashMap<String, HttpProxyRedirect>();
                HttpProxyRedirect.map.put(proxyRedirect.httpPort, redirectsForThisPort);
            }
            if ((oldRedirect = redirectsForThisPort.put(proxyRedirect.host, proxyRedirect)) != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("activate - overwriting existing proxy redirect, " + oldRedirect + ", with " + proxyRedirect), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeProxyRedirect(HttpProxyRedirect proxyRedirect) {
        Map<Integer, Map<String, HttpProxyRedirect>> map = HttpProxyRedirect.map;
        synchronized (map) {
            Map<String, HttpProxyRedirect> redirectsForThisPort = HttpProxyRedirect.map.get(proxyRedirect.httpPort);
            if (redirectsForThisPort != null) {
                redirectsForThisPort.remove(proxyRedirect.host);
                if (redirectsForThisPort.isEmpty()) {
                    HttpProxyRedirect.map.remove(proxyRedirect.httpPort);
                }
            }
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        Dictionary config = ctx.getProperties();
        this.enabled = (Boolean)config.get(PROP_ENABLED);
        this.host = (String)config.get(PROP_HOST);
        this.httpPort = (Integer)config.get(PROP_HTTP_PORT);
        this.httpsPort = (Integer)config.get(PROP_HTTPS_PORT);
        HttpProxyRedirect.putProxyRedirect(this);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        HttpProxyRedirect.removeProxyRedirect(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    protected void modified(Map<String, Object> config) {
        Map<Integer, Map<String, HttpProxyRedirect>> map = HttpProxyRedirect.map;
        synchronized (map) {
            HttpProxyRedirect.removeProxyRedirect(this);
            this.enabled = (Boolean)config.get(PROP_ENABLED);
            this.host = (String)config.get(PROP_HOST);
            this.httpPort = (Integer)config.get(PROP_HTTP_PORT);
            this.httpsPort = (Integer)config.get(PROP_HTTPS_PORT);
            HttpProxyRedirect.putProxyRedirect(this);
        }
    }

    public String toString() {
        return "HttpProxyRedirect[enabled=" + this.enabled + ", host=" + this.host + ", httpPort=" + this.httpPort + ", httpsPort=" + this.httpsPort + "]";
    }
}

