/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.udpchannel.internal.CumulativeLogger;
import com.ibm.ws.udpchannel.internal.UDPConnLink;
import com.ibm.ws.udpchannel.internal.UDPRequestContextImpl;
import com.ibm.ws.udpchannel.internal.WorkQueueManager;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.udpchannel.UDPWriteCompletedCallback;
import com.ibm.wsspi.udpchannel.UDPWriteRequestContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class UDPWriteRequestContextImpl
extends UDPRequestContextImpl
implements UDPWriteRequestContext {
    private static final TraceComponent tc = Tr.register(UDPWriteRequestContextImpl.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private UDPWriteCompletedCallback writeCallback = null;
    private WsByteBuffer writeBuffer = null;
    private SocketAddress targetAddress = null;
    private boolean bIsForceQueue = false;

    public UDPWriteRequestContextImpl(UDPConnLink udpContext, WorkQueueManager wqm) {
        super(udpContext, wqm);
    }

    @Override
    public void setBuffer(WsByteBuffer buf) {
        this.writeBuffer = buf;
    }

    protected WsByteBuffer getBuffer() {
        return this.writeBuffer;
    }

    @Override
    public VirtualConnection write(SocketAddress address, UDPWriteCompletedCallback callback, boolean forceQueue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write()", (Object[])new Object[0]);
        }
        if (((InetSocketAddress)address).getAddress() == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adddress is unresolvable [" + address + "]"), (Object[])new Object[0]);
            }
            CumulativeLogger.logLookupFailure(((InetSocketAddress)address).getHostName());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write when address is unresolvable.");
            }
            return this.getConnLink().getVirtualConnection();
        }
        this.setWriteCallback(callback);
        this.targetAddress = address;
        this.bIsForceQueue = forceQueue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("write called for buffer " + this.getBuffer() + " to address " + address), (Object[])new Object[0]);
        }
        VirtualConnection conn = this.getWorkQueueManager().processWork(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("write: " + conn));
        }
        return conn;
    }

    protected SocketAddress getAddress() {
        return this.targetAddress;
    }

    protected void setWriteCallback(UDPWriteCompletedCallback writeCallback) {
        this.writeCallback = writeCallback;
    }

    protected UDPWriteCompletedCallback getWriteCallback() {
        return this.writeCallback;
    }

    public boolean isForceQueue() {
        return this.bIsForceQueue;
    }

    @Override
    public boolean isRead() {
        return false;
    }
}

