/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectMessages;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Collection;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ModuleInfo;
import org.jboss.jandex.Type;

public class AugmentedIndexView
implements IndexView {
    private final IndexView index;

    public static AugmentedIndexView augment(IndexView index) {
        if (index instanceof AugmentedIndexView) {
            return (AugmentedIndexView)index;
        }
        return new AugmentedIndexView(index);
    }

    private AugmentedIndexView(IndexView index) {
        this.validateInput(index);
        this.index = index;
    }

    public ClassInfo getClass(Type type) {
        this.validateInput(type);
        return this.index.getClassByName(TypeUtil.getName(type));
    }

    public boolean containsClass(Type type) {
        this.validateInput(type);
        return this.getClass(type) != null;
    }

    public ClassInfo getClass(Class<?> klazz) {
        this.validateInput(klazz);
        return this.index.getClassByName(DotName.createSimple((String)klazz.getName()));
    }

    public Collection<ClassInfo> getKnownClasses() {
        return this.index.getKnownClasses();
    }

    public ClassInfo getClassByName(DotName className) {
        this.validateInput(className);
        return this.index.getClassByName(className);
    }

    public Collection<ClassInfo> getKnownDirectSubclasses(DotName className) {
        this.validateInput(className);
        return this.index.getKnownDirectSubclasses(className);
    }

    public Collection<ClassInfo> getAllKnownSubclasses(DotName className) {
        this.validateInput(className);
        return this.index.getAllKnownSubclasses(className);
    }

    public Collection<ClassInfo> getKnownDirectSubinterfaces(DotName interfaceName) {
        this.validateInput(interfaceName);
        return this.index.getKnownDirectSubinterfaces(interfaceName);
    }

    public Collection<ClassInfo> getAllKnownSubinterfaces(DotName interfaceName) {
        this.validateInput(interfaceName);
        return this.index.getAllKnownSubinterfaces(interfaceName);
    }

    public Collection<ClassInfo> getKnownDirectImplementors(DotName className) {
        this.validateInput(className);
        return this.index.getKnownDirectImplementors(className);
    }

    public Collection<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
        this.validateInput(interfaceName);
        return this.index.getAllKnownImplementors(interfaceName);
    }

    public Collection<AnnotationInstance> getAnnotations(DotName annotationName) {
        this.validateInput(annotationName);
        return this.index.getAnnotations(annotationName);
    }

    public Collection<AnnotationInstance> getAnnotationsWithRepeatable(DotName annotationName, IndexView annotationIndex) {
        this.validateInput(annotationName, annotationIndex);
        return this.index.getAnnotationsWithRepeatable(annotationName, annotationIndex);
    }

    public Collection<ModuleInfo> getKnownModules() {
        return this.index.getKnownModules();
    }

    public ModuleInfo getModuleByName(DotName moduleName) {
        this.validateInput(moduleName);
        return this.index.getModuleByName(moduleName);
    }

    public Collection<ClassInfo> getKnownUsers(DotName className) {
        this.validateInput(className);
        return this.index.getKnownUsers(className);
    }

    public Collection<ClassInfo> getClassesInPackage(DotName packageName) {
        this.validateInput(packageName);
        return this.index.getClassesInPackage(packageName);
    }

    public Set<DotName> getSubpackages(DotName packageName) {
        this.validateInput(packageName);
        return this.index.getSubpackages(packageName);
    }

    private void validateInput(Object ... inputs) {
        for (Object input : inputs) {
            if (input != null) continue;
            throw DataObjectMessages.msg.notNull();
        }
    }
}

