/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.semconv.http;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpStatusCodeConverter;
import io.opentelemetry.instrumentation.api.semconv.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.internal.InternalServerAttributesExtractor;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.ToIntFunction;

public final class HttpClientAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpClientAttributesGetter<REQUEST, RESPONSE>>
implements SpanKeyProvider {
    private static final Set<String> PARAMS_TO_REDACT = new HashSet<String>(Arrays.asList("AWSAccessKeyId", "Signature", "sig", "X-Goog-Signature"));
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final InternalServerAttributesExtractor<REQUEST> internalServerExtractor;
    private final ToIntFunction<Context> resendCountIncrementer;
    private final boolean redactQueryParameters;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return HttpClientAttributesExtractor.builder(httpAttributesGetter).build();
    }

    public static <REQUEST, RESPONSE> HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return new HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter);
    }

    HttpClientAttributesExtractor(HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder) {
        super(builder.httpAttributesGetter, HttpStatusCodeConverter.CLIENT, builder.capturedRequestHeaders, builder.capturedResponseHeaders, builder.knownMethods);
        this.internalNetworkExtractor = builder.buildNetworkExtractor();
        this.internalServerExtractor = builder.buildServerExtractor();
        this.resendCountIncrementer = builder.resendCountIncrementer;
        this.redactQueryParameters = builder.redactQueryParameters;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        this.internalServerExtractor.onStart(attributes, request);
        String fullUrl = this.stripSensitiveData(((HttpClientAttributesGetter)this.getter).getUrlFull(request));
        AttributesExtractorUtil.internalSet(attributes, UrlAttributes.URL_FULL, fullUrl);
        int resendCount = this.resendCountIncrementer.applyAsInt(parentContext);
        if (resendCount > 0) {
            attributes.put(HttpAttributes.HTTP_REQUEST_RESEND_COUNT, resendCount);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        this.internalNetworkExtractor.onEnd(attributes, request, response);
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.HTTP_CLIENT;
    }

    @Nullable
    private String stripSensitiveData(@Nullable String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        url = HttpClientAttributesExtractor.redactUserInfo(url);
        if (this.redactQueryParameters) {
            url = HttpClientAttributesExtractor.redactQueryParameters(url);
        }
        return url;
    }

    private static String redactUserInfo(String url) {
        int schemeEndIndex = url.indexOf(58);
        if (schemeEndIndex == -1) {
            return url;
        }
        int len = url.length();
        if (len <= schemeEndIndex + 2 || url.charAt(schemeEndIndex + 1) != '/' || url.charAt(schemeEndIndex + 2) != '/') {
            return url;
        }
        int atIndex = -1;
        for (int index = schemeEndIndex + 3; index < len; ++index) {
            char c = url.charAt(index);
            if (c == '@') {
                atIndex = index;
            }
            if (c == '/' || c == '?' || c == '#') break;
        }
        if (atIndex == -1 || atIndex == len - 1) {
            return url;
        }
        return url.substring(0, schemeEndIndex + 3) + "REDACTED:REDACTED" + url.substring(atIndex);
    }

    private static String redactQueryParameters(String url) {
        int questionMarkIndex = url.indexOf(63);
        if (questionMarkIndex == -1 || !HttpClientAttributesExtractor.containsParamToRedact(url)) {
            return url;
        }
        StringBuilder urlAfterQuestionMark = new StringBuilder();
        StringBuilder currentParamName = new StringBuilder();
        for (int i = questionMarkIndex + 1; i < url.length(); ++i) {
            char currentChar = url.charAt(i);
            if (currentChar == '=') {
                char c;
                urlAfterQuestionMark.append('=');
                if (!PARAMS_TO_REDACT.contains(currentParamName.toString())) continue;
                urlAfterQuestionMark.append("REDACTED");
                while (i + 1 < url.length() && (c = url.charAt(i + 1)) != '&' && c != '#') {
                    ++i;
                }
                continue;
            }
            if (currentChar == '&') {
                urlAfterQuestionMark.append(currentChar);
                currentParamName.setLength(0);
                continue;
            }
            if (currentChar == '#') {
                urlAfterQuestionMark.append(url.substring(i));
                break;
            }
            currentParamName.append(currentChar);
            urlAfterQuestionMark.append(currentChar);
        }
        return url.substring(0, questionMarkIndex) + "?" + urlAfterQuestionMark;
    }

    private static boolean containsParamToRedact(String urlpart) {
        for (String param : PARAMS_TO_REDACT) {
            if (!urlpart.contains(param)) continue;
            return true;
        }
        return false;
    }
}

