/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.netty;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.framework.IOWriteCompletedCallback;
import com.ibm.ws.sib.jfapchannel.framework.IOWriteRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.impl.NettyConnectionWriteCompletedCallback;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOBaseContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnection;
import com.ibm.ws.sib.utils.ras.SibTr;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;

public class NettyIOWriteRequestContext
extends NettyIOBaseContext
implements IOWriteRequestContext {
    private static final TraceComponent tc = SibTr.register(NettyIOWriteRequestContext.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");

    public NettyIOWriteRequestContext(NettyNetworkConnection conn) {
        super(conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conn});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public NetworkConnection write(WsByteBuffer buffer, NettyConnectionWriteCompletedCallback completionCallback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"write", (Object)new Object[]{buffer, completionCallback});
        }
        NetworkConnection retConn = null;
        NettyIOWriteRequestContext me = this;
        Channel chan = this.conn.getVirtualConnection();
        if (chan.isActive()) {
            ChannelFuture future = chan.writeAndFlush((Object)buffer, chan.newPromise().addListener(f -> {
                if (f.isDone() && f.isSuccess()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Succesful write for " + chan));
                    }
                    completionCallback.complete(this.getNetworkConnectionInstance(chan), me);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.entry((Object)this, (TraceComponent)tc, (String)"Unsuccesful write", (Object)new Object[]{chan, f.cause()});
                    }
                    completionCallback.error(this.getNetworkConnectionInstance(chan), me, new IOException(f.cause()));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"Unsuccesful write");
                    }
                }
            }));
            if (future.isDone()) {
                retConn = this.getNetworkConnectionInstance(chan);
            }
        } else {
            completionCallback.error(this.getNetworkConnectionInstance(chan), me, new IOException("Write was attempted on a channel that is not active!! " + chan));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"write", (Object)retConn);
        }
        return retConn;
    }

    @Override
    public NetworkConnection write(int amountToWrite, IOWriteCompletedCallback completionCallback, boolean queueRequest, int timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"write", (Object)new Object[]{amountToWrite, completionCallback, queueRequest, timeout});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"write: Not supported for Netty");
        }
        throw new UnsupportedOperationException("Not currently supported for Netty. Please use other write method.");
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/netty/jfapchannel/NettyIOWriteRequestContext.java, SIB.comms, WASX.SIB, uu1215.01 1.5");
        }
    }
}

