/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionTarget;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.net.InetSocketAddress;

public class JFapAddress
implements NetworkConnectionTarget {
    private static final TraceComponent tc = SibTr.register(JFapAddress.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private final InetSocketAddress remoteAddress;
    private final Conversation.ConversationType attachType;

    public JFapAddress(InetSocketAddress remoteAddress, Conversation.ConversationType attachType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{remoteAddress, attachType});
        }
        this.remoteAddress = remoteAddress;
        this.attachType = attachType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLocalAddress");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLocalAddress", (Object)("rc=" + null));
        }
        return null;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemoteAddress");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRemoteAddress", (Object)("rc=" + this.remoteAddress));
        }
        return this.remoteAddress;
    }

    @Override
    public int getConnectTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnectTimeout");
        }
        int seconds = 60;
        try {
            seconds = Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)"sib.comms.connect.timeout.jfap", (String)Integer.toString(seconds)));
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapAddress.getConnectTimeout", (String)"00310001");
        }
        int timeout = seconds * 1000;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnectTimeout", (Object)("rc=" + timeout));
        }
        return timeout;
    }

    public Conversation.ConversationType getAttachType() {
        return this.attachType;
    }

    public String toString() {
        return super.toString() + " [remoteAddress: " + this.remoteAddress + " attachType:" + this.attachType + "]";
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/JFapAddress.java, SIB.comms, WASX.SIB, uu1215.01 1.21");
        }
    }
}

