/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.repository.internal;

import com.ibm.ws.install.repository.FeatureAsset;
import com.ibm.ws.install.repository.FeatureCollectionAsset;
import com.ibm.ws.install.repository.Repository;
import com.ibm.ws.install.repository.RepositoryException;
import com.ibm.ws.kernel.feature.Visibility;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseRepository
implements Repository {
    protected final Logger logger = Logger.getLogger("com.ibm.ws.install");
    protected String classname = "BaseRepository";

    @Override
    public Collection<FeatureAsset> getFeatures(String productId, String productVersion, String productInstallType, String productLicenseType, String productEdition) {
        return this.getEsaAsset(productId, productVersion, productInstallType, productLicenseType, productEdition, Visibility.PUBLIC);
    }

    protected Collection<?> getEsaAsset(String productId, String productVersion, String productInstallType, String productLicenseType, String productEdition, Visibility visibility) {
        return null;
    }

    @Override
    public Collection<FeatureCollectionAsset> getFeatureCollections(String productId, String productVersion, String productInstallType, String productLicenseType, String productEdition) {
        return this.getEsaAsset(productId, productVersion, productInstallType, productLicenseType, productEdition, Visibility.INSTALL);
    }

    protected void log(String method, String msg) {
        this.logger.log(Level.FINEST, this.classname + "." + method + ": " + msg);
    }

    protected void log(String method, String msg, Exception e) {
        if (e == null) {
            this.logger.log(Level.FINEST, this.classname + "." + method + ": " + msg);
        } else {
            this.logger.log(Level.FINEST, this.classname + "." + method + ": " + msg, e);
        }
    }

    protected RepositoryException createException(String msg) {
        this.logger.log(Level.SEVERE, msg);
        return new RepositoryException(msg);
    }
}

