/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.pool.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.apache.myfaces.view.facelets.pool.impl.MetadataViewKey;

public class MetadataViewKeyImpl
extends MetadataViewKey
implements Serializable {
    private final Locale locale;
    private final String viewId;
    private final String[] contracts;
    private final String renderKitId;

    public MetadataViewKeyImpl(String viewId, String renderKitId, Locale locale) {
        this.viewId = viewId;
        this.renderKitId = renderKitId;
        this.locale = locale;
        this.contracts = null;
    }

    public MetadataViewKeyImpl(String viewId, String renderKitId, Locale locale, String[] contracts) {
        this.viewId = viewId;
        this.renderKitId = renderKitId;
        this.locale = locale;
        this.contracts = contracts;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }

    @Override
    public String[] getContracts() {
        return Arrays.copyOf(this.contracts, this.contracts.length);
    }

    @Override
    public String getRenderKitId() {
        return this.renderKitId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.locale != null ? this.locale.hashCode() : 0);
        hash = 17 * hash + (this.viewId != null ? this.viewId.hashCode() : 0);
        hash = 17 * hash + Arrays.deepHashCode(this.contracts);
        hash = 17 * hash + (this.renderKitId != null ? this.renderKitId.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetadataViewKeyImpl other = (MetadataViewKeyImpl)obj;
        if (!(this.locale == other.locale || this.locale != null && this.locale.equals(other.locale))) {
            return false;
        }
        if (this.viewId == null ? other.viewId != null : !this.viewId.equals(other.viewId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.contracts, other.contracts)) {
            return false;
        }
        return !(this.renderKitId == null ? other.renderKitId != null : !this.renderKitId.equals(other.renderKitId));
    }
}

