/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.store.items.SIMPItem;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class AIProtocolItem
extends SIMPItem
implements Comparable {
    private long _tick;
    private byte _protocolState;
    private int _storagePolicy;
    private AnycastInputHandler _aihCallbackTarget;
    private boolean _unavailableAfterRecovery;
    private static final TraceComponent tc = SibTr.register(AIProtocolItem.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;

    public AIProtocolItem(long tick, byte protocolState, Reliability reliability, AnycastInputHandler aih) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIProtocolItem", (Object)new Object[]{new Long(tick), new Byte(protocolState), reliability, aih});
        }
        this._tick = tick;
        this._protocolState = protocolState;
        this._storagePolicy = this.computeStoragePolicy(reliability);
        this._aihCallbackTarget = aih;
        this._unavailableAfterRecovery = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIProtocolItem", (Object)this);
        }
    }

    public AIProtocolItem() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIProtocolItem");
        }
        this._storagePolicy = 3;
        this._aihCallbackTarget = null;
        this._unavailableAfterRecovery = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIProtocolItem", (Object)this);
        }
    }

    public int compareTo(Object o) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"compareTo", (Object)o);
        }
        if (o instanceof AIProtocolItem) {
            AIProtocolItem other = (AIProtocolItem)o;
            int result = other._tick < this._tick ? -1 : (other._tick > this._tick ? 1 : 0);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"compareTo");
            }
            return result;
        }
        ClassCastException e = new ClassCastException();
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem.compareTo", (String)"1:156:1.27", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)e);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"compareTo");
        }
        throw e;
    }

    public int getStorageStrategy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)new Integer(this._storagePolicy));
        }
        return this._storagePolicy;
    }

    public long getMaximumTimeInStore() {
        return -2L;
    }

    @Override
    public int getPersistentVersion() {
        return 1;
    }

    @Override
    public void getPersistentData(ObjectOutputStream oos) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)oos);
        }
        try {
            HashMap<String, Number> hm = new HashMap<String, Number>();
            hm.put("tick", new Long(this._tick));
            hm.put("protocolState", new Byte(this._protocolState));
            hm.put("storagePolicy", new Integer(this._storagePolicy));
            oos.writeObject(hm);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem.getPersistentData", (String)"1:216:1.27", (Object)this);
            SIErrorException e2 = new SIErrorException((Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)((Object)e2));
            }
            throw e2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    @Override
    public void restore(ObjectInputStream ois, int dataVersion) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{ois, new Integer(dataVersion)});
        }
        this.checkPersistentVersionId(dataVersion);
        try {
            HashMap hm = (HashMap)ois.readObject();
            this._tick = (Long)hm.get("tick");
            this._protocolState = (Byte)hm.get("protocolState");
            this._storagePolicy = (Integer)hm.get("storagePolicy");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem.restore", (String)"1:257:1.27", (Object)this);
            SIErrorException e2 = new SIErrorException((Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)((Object)e2));
            }
            throw e2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void eventPostCommitAdd(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)transaction);
        }
        if (this._aihCallbackTarget != null) {
            AIStreamKey key = new AIStreamKey(this._tick);
            key.setAcceptedItem(this);
            this._aihCallbackTarget.committed(key);
            this._aihCallbackTarget.clearOrderedTran();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    public void eventPostRollbackAdd(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)transaction);
        }
        if (this._aihCallbackTarget != null && this._unavailableAfterRecovery) {
            AIStreamKey key = new AIStreamKey(this._tick);
            key.setAcceptedItem(this);
            this._aihCallbackTarget.rolledback(key);
        }
        if (this._aihCallbackTarget != null) {
            this._aihCallbackTarget.clearOrderedTran();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    public long getTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTick");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTick", (Object)new Long(this._tick));
        }
        return this._tick;
    }

    public byte getProtocolState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProtocolState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getProtocolState", (Object)new Byte(this._protocolState));
        }
        return this._protocolState;
    }

    public final long getStoragePolicy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStoragePolicy");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStoragePolicy", (Object)new Integer(this._storagePolicy));
        }
        return this._storagePolicy;
    }

    public void setAIHCallbackTarget(AnycastInputHandler aih) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAIHCallbackTarget", (Object)aih);
        }
        this._aihCallbackTarget = aih;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAIHCallbackTarget");
        }
    }

    public boolean isUnavailableAfterRecovery() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isUnavailableAfterRecovery");
            SibTr.exit((TraceComponent)tc, (String)"isUnavailableAfterRecovery", (Object)new Boolean(this._unavailableAfterRecovery));
        }
        return this._unavailableAfterRecovery;
    }

    public void setUnavailableAfterRecovery(boolean value) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setUnavailableAfterRecovery", (Object)new Boolean(value));
        }
        this._unavailableAfterRecovery = value;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setUnavailableAfterRecovery");
        }
    }

    private int computeStoragePolicy(Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"computeStoragePolicy", (Object)reliability);
        }
        int result = 0;
        result = reliability.compareTo((Object)Reliability.ASSURED_PERSISTENT) == 0 ? 4 : (reliability.compareTo((Object)Reliability.RELIABLE_PERSISTENT) == 0 ? 3 : 1);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"computeStoragePolicy", (Object)new Integer(result));
        }
        return result;
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.taggedValue("tick", this._tick);
        writer.taggedValue("protocolState", (long)this._protocolState);
    }

    public String toString() {
        return super.toString() + "[" + this._tick + ", " + this._protocolState + "]";
    }
}

