/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util;

import java.io.InvalidClassException;
import java.security.AccessController;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.rmi.impl.InputStreamWithOffsets;
import org.apache.yoko.rmi.util.JavaIoFilterAdapter;
import org.apache.yoko.rmi.util.SunMiscFilterAdapter;
import org.omg.CORBA.portable.InputStream;

public final class SerialFilterHelper
extends Enum<SerialFilterHelper> {
    private static final Logger logger;
    private static final FilterAdapter HELPER;
    private static final /* synthetic */ SerialFilterHelper[] $VALUES;

    public static SerialFilterHelper[] values() {
        return (SerialFilterHelper[])$VALUES.clone();
    }

    public static SerialFilterHelper valueOf(String name) {
        return Enum.valueOf(SerialFilterHelper.class, name);
    }

    public static void checkInput(Class<?> serialClass, long arrayLength, long depth, long position) {
        try {
            HELPER.checkInput(serialClass, arrayLength, depth, position);
        }
        catch (InvalidClassException ice) {
            throw new RuntimeException(ice);
        }
    }

    private static long position(InputStream in) {
        return in instanceof InputStreamWithOffsets ? ((InputStreamWithOffsets)in).position() : 0L;
    }

    public static void checkArrayInput(Class<?> type, long arraylength, InputStream in) {
        SerialFilterHelper.checkInput(type, arraylength, 1L, SerialFilterHelper.position(in));
    }

    public static void checkInput(Class<?> type, long depth, InputStream in) {
        SerialFilterHelper.checkInput(type, -1L, depth, SerialFilterHelper.position(in));
    }

    static {
        FilterAdapter filterAdapter;
        $VALUES = new SerialFilterHelper[0];
        logger = Logger.getLogger(SerialFilterHelper.class.getName());
        try {
            filterAdapter = new JavaIoFilterAdapter();
        }
        catch (Throwable t1) {
            try {
                filterAdapter = AccessController.doPrivileged(SunMiscFilterAdapter::new);
            }
            catch (Throwable t2) {
                filterAdapter = new NullFilterAdapter();
            }
        }
        HELPER = filterAdapter;
    }

    static abstract class BaseInfo {
        private final Class<?> serialClass;
        private final long arrayLength;
        private final long depth;
        private final long references;
        private final long streamBytes;

        public BaseInfo(Class<?> serialClass, long arrayLength, long depth, long references, long streamBytes) {
            this.serialClass = serialClass;
            this.arrayLength = arrayLength;
            this.depth = depth;
            this.references = references;
            this.streamBytes = streamBytes;
        }

        public Class<?> serialClass() {
            return this.serialClass;
        }

        public long arrayLength() {
            return this.arrayLength;
        }

        public long depth() {
            return this.depth;
        }

        public long references() {
            return this.references;
        }

        public long streamBytes() {
            return this.streamBytes;
        }
    }

    static abstract class BaseFilterAdapter<FILTER, INFO extends BaseInfo, STATUS extends Enum<STATUS>>
    extends FilterAdapter {
        final FILTER filter;
        private final STATUS rejected;

        BaseFilterAdapter(FILTER filter, STATUS rejected) {
            Objects.requireNonNull(filter);
            Objects.requireNonNull(rejected);
            this.filter = filter;
            this.rejected = rejected;
        }

        @Override
        public final void checkInput(Class<?> serialClass, long arrayLength, long depth, long streamBytes) throws InvalidClassException {
            STATUS status;
            long references = 1L;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(String.format("Invoking SerialFilter for Class : %s=\"%s\", %s=%d, %s=%d, %s=%d, %s=%d", "serialClass", serialClass, "arrayLength", arrayLength, "depth", depth, "references", 1L, "streamBytes", streamBytes));
            }
            INFO info = this.makeInfo(serialClass, arrayLength, depth, 1L, streamBytes);
            try {
                status = this.checkInput(info);
            }
            catch (Exception e) {
                throw (InvalidClassException)new InvalidClassException("Rejected by serialFilter: " + serialClass.getName()).initCause(e);
            }
            if (status == null || status == this.rejected) {
                throw new InvalidClassException("Rejected by serialFilter: " + serialClass.getName());
            }
        }

        abstract STATUS checkInput(INFO var1);

        abstract INFO makeInfo(Class<?> var1, long var2, long var4, long var6, long var8);
    }

    private static final class NullFilterAdapter
    extends FilterAdapter {
        private NullFilterAdapter() {
        }

        @Override
        public void checkInput(Class<?> serialClass, long arrayLength, long depth, long streamBytes) {
        }
    }

    private static abstract class FilterAdapter {
        private FilterAdapter() {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.getClass().getName() + " created");
            }
        }

        abstract void checkInput(Class<?> var1, long var2, long var4, long var6) throws InvalidClassException;
    }
}

