/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.internal.globalhandler;

import com.ibm.websphere.ras.Traceable;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.webservices.handler.GlobalHandlerMessageContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Trivial
public class RESTfulGlobalHandlerMessageContext
implements GlobalHandlerMessageContext,
Traceable {
    private final boolean isServerSide;
    private final boolean isOutboundFlow;
    private final Supplier<Collection<String>> propertyNamesGetter;
    private final Function<String, Object> propertyGetter;
    private final BiConsumer<String, Object> propertySetter;
    private final Consumer<String> propertyRemover;
    private final HttpServletRequest servletRequest;
    private final HttpServletResponse servletResponse;

    RESTfulGlobalHandlerMessageContext(boolean isServerSide, boolean isOutboundFlow, Supplier<Collection<String>> propertyNamesGetter, Function<String, Object> propertyGetter, BiConsumer<String, Object> propertySetter, Consumer<String> propertyRemover, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.isServerSide = isServerSide;
        this.isOutboundFlow = isOutboundFlow;
        this.propertyNamesGetter = propertyNamesGetter;
        this.propertyGetter = propertyGetter;
        this.propertySetter = propertySetter;
        this.propertyRemover = propertyRemover;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
    }

    public boolean isServerSide() {
        return this.isServerSide;
    }

    public boolean isClientSide() {
        return !this.isServerSide;
    }

    public String getEngineType() {
        return "JAX_RS";
    }

    public String getFlowType() {
        return this.isOutboundFlow ? "OUT" : "IN";
    }

    @Sensitive
    public Object getProperty(String name) {
        return this.propertyGetter.apply(name);
    }

    public void setProperty(String name, Object value) {
        this.propertySetter.accept(name, value);
    }

    public Iterator<String> getPropertyNames() {
        return this.propertyNamesGetter.get().iterator();
    }

    public void removeProperty(String name) {
        this.propertyRemover.accept(name);
    }

    public boolean containsProperty(String name) {
        return this.propertyNamesGetter.get().contains(name);
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    public <T> T adapt(Class<T> clazz) {
        return null;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toTraceString() {
        return this.toString(true);
    }

    private String toString(boolean includeProperties) {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[");
        sb.append("isOutboundFlow:").append(this.isOutboundFlow).append(" ");
        sb.append("isServerSide:").append(this.isServerSide).append(" ");
        if (includeProperties) {
            String LS = System.lineSeparator();
            Iterator<String> iter = this.getPropertyNames();
            while (iter.hasNext()) {
                String name = iter.next();
                if (name.toLowerCase().contains("password")) {
                    sb.append(LS).append(name).append("=").append("*****");
                    continue;
                }
                sb.append(LS).append(name).append("=").append(this.getProperty(name));
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

