/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.copypolicy;

import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CopyPolicyMetadata;

public class CloneCopyPolicyMetadata
extends CopyPolicyMetadata {
    private String methodName;
    private String workingCopyMethodName;

    public CloneCopyPolicyMetadata() {
        super("<clone-copy-policy>");
    }

    public CloneCopyPolicyMetadata(MetadataAnnotation copyPolicy, MetadataAccessor accessor) {
        super(copyPolicy, accessor);
        this.methodName = copyPolicy.getAttributeString("method");
        this.workingCopyMethodName = copyPolicy.getAttributeString("workingCopyMethod");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof CloneCopyPolicyMetadata) {
            CloneCopyPolicyMetadata cloneCopyPolicy = (CloneCopyPolicyMetadata)objectToCompare;
            if (!this.valuesMatch(this.methodName, cloneCopyPolicy.getMethodName())) {
                return false;
            }
            return this.valuesMatch(this.workingCopyMethodName, cloneCopyPolicy.getWorkingCopyMethodName());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.workingCopyMethodName != null ? this.workingCopyMethodName.hashCode() : 0);
        return result;
    }

    @Override
    public CopyPolicy getCopyPolicy() {
        if (this.methodName == null && this.workingCopyMethodName == null) {
            throw ValidationException.copyPolicyMustSpecifyEitherMethodOrWorkingCopyMethod(this.getLocation());
        }
        CloneCopyPolicy copyPolicy = new CloneCopyPolicy();
        copyPolicy.setMethodName(this.methodName);
        copyPolicy.setWorkingCopyMethodName(this.workingCopyMethodName);
        return copyPolicy;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getWorkingCopyMethodName() {
        return this.workingCopyMethodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setWorkingCopyMethodName(String workingCopyMethodName) {
        this.workingCopyMethodName = workingCopyMethodName;
    }
}

