/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer40.srt.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet40.IRequest40;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.webcontainer40.srt.SRTServletRequest40;
import com.ibm.ws.webcontainer40.srt.http.HttpHeaderField;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.ee8.Http2PushBuilder;
import com.ibm.wsspi.http.ee8.Http2Request;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.PushBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HttpPushBuilder
implements PushBuilder,
Http2PushBuilder {
    private static final TraceComponent tc = Tr.register(HttpPushBuilder.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer40.resources.Messages");
    private String _method = "GET";
    private String _queryString = null;
    private String _sessionId = null;
    private String _path = null;
    private String _pathURI = null;
    private String _pathQueryString = null;
    private Enum _sessionIdFromCookieOrUrl;
    private static final String HDR_REFERER = HttpHeaderKeys.HDR_REFERER.getName();
    private static final String HDR_IF_MATCH = HttpHeaderKeys.HDR_IF_MATCH.getName();
    private static final String HDR_IF_MODIFIED_SINCE = HttpHeaderKeys.HDR_IF_MODIFIED_SINCE.getName();
    private static final String HDR_IF_NONE_MATCH = HttpHeaderKeys.HDR_IF_NONE_MATCH.getName();
    private static final String HDR_IF_RANGE = HttpHeaderKeys.HDR_IF_RANGE.getName();
    private static final String HDR_IF_UNMODIFIED_SINCE = HttpHeaderKeys.HDR_IF_UNMODIFIED_SINCE.getName();
    private static final String HDR_COOKIE = HttpHeaderKeys.HDR_COOKIE.getName();
    private static final String HDR_AUTHORIZATION = HttpHeaderKeys.HDR_AUTHORIZATION.getName();
    private final SRTServletRequest40 _inboundRequest;
    HashMap<String, HashSet<HttpHeaderField>> _headers = new HashMap();
    private static ArrayList<String> _invalidMethods = new ArrayList<String>(Arrays.asList("POST", "PUT", "DELETE", "CONNECT", "OPTIONS", "TRACE"));

    public HttpPushBuilder(SRTServletRequest40 request, String sessionId, Enumeration<String> headerNames, Cookie[] addedCookies) {
        this._inboundRequest = request;
        this._sessionId = sessionId;
        Set sessionTrackingMode = request.getServletContext().getEffectiveSessionTrackingModes();
        this._sessionIdFromCookieOrUrl = request.isRequestedSessionIdFromCookie() ? SessionTrackingMode.COOKIE : (request.isRequestedSessionIdFromURL() ? SessionTrackingMode.URL : (sessionTrackingMode.contains(SessionTrackingMode.COOKIE) ? SessionTrackingMode.COOKIE : SessionTrackingMode.URL));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"HttpPushBuilder", (Object[])new Object[]{"_sessionIdFromCookieOrUrl = " + this._sessionIdFromCookieOrUrl});
        }
        if (headerNames != null) {
            Cookie[] smc = this._inboundRequest.getWebAppDispatcherContext().getWebApp().getSessionContext().getWASSessionConfig();
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement();
                Enumeration headerValues = request.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    if (headerValue.contains(smc.getSessionCookieName())) continue;
                    this.addHeader(headerName, headerValue);
                }
            }
        }
        if (request.getUserPrincipal() != null) {
            this.setHeader(HDR_AUTHORIZATION, request.getHeader(HDR_AUTHORIZATION));
        }
        if (addedCookies != null) {
            for (Cookie cookie : addedCookies) {
                if (cookie.getMaxAge() <= 0) continue;
                this.addHeader(HDR_COOKIE, cookie.getName() + "=" + cookie.getValue());
            }
        }
        String referer = this._inboundRequest.getRequestURL().toString();
        String queryString = this._inboundRequest.getQueryString();
        if (queryString != null) {
            referer = referer + "?" + queryString;
        }
        this.setHeader(HDR_REFERER, referer);
    }

    public PushBuilder method(String method) throws IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"method()", (Object[])new Object[]{"method = " + method});
        }
        if (method == null) {
            throw new NullPointerException();
        }
        if (method.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (_invalidMethods.contains(method.toUpperCase())) {
            throw new IllegalArgumentException();
        }
        this._method = method;
        return this;
    }

    public PushBuilder queryString(String queryString) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"queryString()", (Object[])new Object[]{"queryString = " + queryString});
        }
        this._queryString = queryString;
        return this;
    }

    public PushBuilder sessionId(String sessionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sessionId()", (Object[])new Object[]{"sessionId = " + sessionId});
        }
        this._sessionId = sessionId;
        return this;
    }

    public PushBuilder setHeader(String name, String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setHeader()", (Object[])new Object[]{"name = " + name + ", value = " + value});
        }
        if (this.isValidHeader(name, value)) {
            this.removeHeader(name);
            this.addHeader(name, value);
        }
        return this;
    }

    public PushBuilder addHeader(String name, String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addHeader()", (Object[])new Object[]{"name = " + name + ", value = " + value});
        }
        if (this.isValidHeader(name, value)) {
            if (this._headers.containsKey(name)) {
                HashSet<HttpHeaderField> values = this._headers.get(name);
                values.add(new HttpHeaderField(name, value));
            } else {
                HashSet<HttpHeaderField> values = new HashSet<HttpHeaderField>();
                values.add(new HttpHeaderField(name, value));
                this._headers.put(name, values);
            }
        }
        return this;
    }

    public PushBuilder removeHeader(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"removeHeader()", (Object[])new Object[]{"name = " + name});
        }
        this._headers.remove(name);
        return this;
    }

    public PushBuilder path(String path) {
        String baseUri;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"path()", (Object[])new Object[]{"path = " + path});
        }
        if (path != null && !path.startsWith("/") && (baseUri = this._inboundRequest.getContextPath()) != null) {
            if (!baseUri.endsWith("/")) {
                baseUri = baseUri + "/";
            }
            path = baseUri + path;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"path()", (Object[])new Object[]{"new context-relative path = " + path});
            }
        }
        this._path = path;
        if (path != null && path.contains("?")) {
            String[] pathParts = path.split("\\?");
            this._pathURI = pathParts[0];
            this._pathQueryString = "?" + pathParts[1];
        } else {
            this._pathURI = path;
            this._pathQueryString = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"path()", (Object)("uri = " + this._pathURI + ", queryString = " + this._pathQueryString));
        }
        return this;
    }

    public void push() throws IllegalStateException {
        String urlRewritePrefix;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"push()", (Object[])new Object[]{"path = " + this._path});
        }
        if (this._path == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"push()", (Object)"Path not set. Throw IllegalStateException");
            }
            throw new IllegalStateException();
        }
        if (this._queryString != null) {
            this._pathQueryString = this._pathQueryString != null ? this._pathQueryString + "&" + this._queryString : "?" + this._queryString;
        }
        if (this._pathQueryString != null) {
            if (this._sessionIdFromCookieOrUrl == SessionTrackingMode.URL && this._sessionId != null) {
                urlRewritePrefix = this._inboundRequest.getWebAppDispatcherContext().getWebApp().getSessionContext().getWASSessionConfig().getSessUrlRewritePrefix();
                this._pathQueryString = this._pathQueryString + urlRewritePrefix + this._sessionId;
            }
        } else if (this._sessionIdFromCookieOrUrl == SessionTrackingMode.URL && this._sessionId != null) {
            urlRewritePrefix = this._inboundRequest.getWebAppDispatcherContext().getWebApp().getSessionContext().getWASSessionConfig().getSessUrlRewritePrefix();
            this._pathURI = this._pathURI + urlRewritePrefix + this._sessionId;
        }
        if (this._sessionIdFromCookieOrUrl == SessionTrackingMode.COOKIE && this._sessionId != null) {
            SessionManagerConfig smc = this._inboundRequest.getWebAppDispatcherContext().getWebApp().getSessionContext().getWASSessionConfig();
            this.addHeader(HDR_COOKIE, smc.getSessionCookieName() + "=" + this._sessionId);
        }
        IRequest40 request = (IRequest40)this._inboundRequest.getIRequest();
        ((Http2Request)request.getHttpRequest()).pushNewRequest((Http2PushBuilder)this);
        this.reset();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"push()");
        }
    }

    public String getMethod() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getMethod()", (Object[])new Object[]{"method = " + this._method});
        }
        return this._method;
    }

    public String getQueryString() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getQueryString()", (Object[])new Object[]{"queryString = " + this._queryString});
        }
        return this._queryString;
    }

    public String getSessionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getSessionId()", (Object[])new Object[]{"sessionId = " + this._sessionId});
        }
        return this._sessionId;
    }

    public Set<String> getHeaderNames() {
        return Collections.unmodifiableSet(this._headers.keySet());
    }

    public String getHeader(String name) {
        HashSet<HttpHeaderField> values = this._headers.get(name);
        if (values != null) {
            Iterator<HttpHeaderField> valuesIterator = values.iterator();
            HttpHeaderField field = valuesIterator.next();
            return field.asString();
        }
        return null;
    }

    public String getPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getPath()", (Object[])new Object[]{"path = " + this._path});
        }
        return this._path;
    }

    public Set<HeaderField> getHeaders() {
        HashSet<HeaderField> headerFields = new HashSet<HeaderField>();
        if (this._headers.size() > 0) {
            Iterator<String> headerNames = this._headers.keySet().iterator();
            while (headerNames.hasNext()) {
                for (HttpHeaderField field : this._headers.get(headerNames.next())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getHeaders()", (Object[])new Object[]{"add header name = " + field.getName() + ", value = " + field.asString()});
                    }
                    headerFields.add(field);
                }
            }
        }
        return headerFields;
    }

    public String getURI() {
        return this._pathURI;
    }

    public String getPathQueryString() {
        return this._pathQueryString;
    }

    private void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"reset()", (Object[])new Object[]{"Clearing the path and removing conditional headers"});
        }
        this._path = null;
        this._pathURI = null;
        this._queryString = null;
        this._pathQueryString = null;
        this.removeHeader(HDR_IF_MATCH);
        this.removeHeader(HDR_IF_MODIFIED_SINCE);
        this.removeHeader(HDR_IF_NONE_MATCH);
        this.removeHeader(HDR_IF_RANGE);
        this.removeHeader(HDR_IF_UNMODIFIED_SINCE);
    }

    private boolean isValidHeader(String name, String value) {
        boolean validity = true;
        if (name == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid null header name found.", (Object[])new Object[0]);
            }
            validity = false;
        } else if (value == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid null header value found.", (Object[])new Object[0]);
            }
            validity = false;
        }
        return validity;
    }
}

