/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class LoggerHandlerManager {
    private static final Logger rootLogger = Logger.getLogger("");
    private static Handler console;
    private static Handler singleton;

    public static synchronized void initialize() {
        if (console == null) {
            console = new ConsoleHandler();
            LoggerHandlerManager.updateSingleton(console);
        }
    }

    private static synchronized void updateSingleton(Handler newHandler) {
        Handler oldHandler = singleton;
        if (newHandler != oldHandler) {
            if (newHandler != null) {
                rootLogger.addHandler(newHandler);
            }
            singleton = newHandler;
            if (oldHandler != null) {
                rootLogger.removeHandler(oldHandler);
            }
        }
    }

    public static synchronized Handler getSingleton() {
        return singleton != console ? singleton : null;
    }

    public static synchronized void setSingleton(Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        LoggerHandlerManager.updateSingleton(handler);
    }

    public static synchronized void unsetSingleton() {
        LoggerHandlerManager.updateSingleton(console);
    }
}

