/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.Constants;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.config.ProtocolHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public class SSLPropertyUtils {
    private static final TraceComponent tc = Tr.register(SSLPropertyUtils.class, (String)"SSL", (String)"com.ibm.ws.ssl");

    private static Properties getProperties(final String sslAliasName, final Map<String, Object> currentConnectionInfo, final SSLConfigChangeListener listener) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getProperties sslAliasName=" + sslAliasName + "\ncurrentConnectionInfo=" + currentConnectionInfo + "\nlistener=" + listener));
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws Exception {
                    return JSSEHelper.getInstance().getProperties(sslAliasName, currentConnectionInfo, listener);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw (SSLException)cause;
        }
    }

    protected static Properties lookupProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupProperties");
        }
        return SSLPropertyUtils.lookupProperties(null);
    }

    protected static Properties lookupProperties(String alias) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("lookupProperties alias=" + alias));
        }
        Properties properties = null;
        if (alias != null) {
            try {
                HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
                connectionInfo.put("com.ibm.ssl.direction", "outbound");
                properties = SSLPropertyUtils.getProperties(alias, connectionInfo, null);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Failed getting SSL config from alias=" + alias), (Object)new Object[]{e});
                }
            }
        } else {
            properties = SSLPropertyUtils.getDefaultProperties();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("lookupProperties properties=" + properties));
        }
        return properties;
    }

    private static Properties getDefaultProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultProperties");
        }
        Properties properties = null;
        try {
            HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            properties = SSLConfigManager.getInstance().getDefaultSystemProperties(true);
            if (properties == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting default SSL properties from WebSphere configuration.");
                }
                properties = SSLPropertyUtils.getProperties(null, connectionInfo, null);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting javax.net.ssl.* SSL System properties.");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"LibertySSLSocketFactory exception getting default SSL properties.", (Object)new Object[]{e});
            }
            properties = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDefaultProperties properties=" + properties));
        }
        return properties;
    }

    protected static void setSSLPropertiesOnSocket(Properties properties, SSLSocket socket) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setSSLPropertiesOnSocket properties=" + properties));
        }
        SSLParameters sslParameters = socket.getSSLParameters();
        if (properties != null) {
            String[] ciphers = SSLConfigManager.getInstance().getCipherList(properties, socket);
            String endpointIdentificationAlgorithm = SSLPropertyUtils.getEndpointIdentificationAlgorithm(properties, socket, null);
            sslParameters = SSLPropertyUtils.createSSLParameters(properties, sslParameters, ciphers, endpointIdentificationAlgorithm);
            socket.setSSLParameters(sslParameters);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSSLPropertiesOnSocket");
        }
    }

    protected static void setSSLPropertiesOnServerSocket(Properties properties, SSLServerSocket socket) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setSSLPropertiesOnServerSocket properties=" + properties));
        }
        SSLParameters sslParameters = socket.getSSLParameters();
        if (properties != null) {
            String[] ciphers = SSLConfigManager.getInstance().getCipherList(properties, socket);
            String endpointIdentificationAlgorithm = SSLPropertyUtils.getEndpointIdentificationAlgorithm(properties, null, socket);
            sslParameters = SSLPropertyUtils.createSSLParameters(properties, sslParameters, ciphers, endpointIdentificationAlgorithm);
            socket.setSSLParameters(sslParameters);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSSLPropertiesOnServerSocket");
        }
    }

    private static SSLParameters createSSLParameters(Properties properties, SSLParameters sslParameters, String[] ciphers, String endpointIdentificationAlgorithm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createSSLParameters properties=" + properties + "\nsslParameters=" + sslParameters + "\nciphers=" + ciphers));
        }
        if (properties != null) {
            sslParameters.setCipherSuites(ciphers);
            String protocol = properties.getProperty("com.ibm.ssl.protocol");
            String[] protocols = new ProtocolHelper().getSSLProtocol(protocol);
            if (protocols != null) {
                sslParameters.setProtocols(protocols);
            }
            sslParameters.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createSSLParameters sslParameters=" + sslParameters));
        }
        return sslParameters;
    }

    private static String getEndpointIdentificationAlgorithm(Properties properties, SSLSocket sslSocket, SSLServerSocket serverSocket) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEndpointIdentificationAlgorithm");
        }
        String endpointId = "HTTPS";
        String verifyHostname = properties.getProperty("com.ibm.ws.ssl.verifyHostname", "true");
        if ("true".equalsIgnoreCase(verifyHostname)) {
            String allowHostList = properties.getProperty("com.ibm.ws.ssl.skipHostnameVerificationForHosts", "");
            InetAddress remoteInetAddr = null;
            if (sslSocket != null) {
                remoteInetAddr = sslSocket.getInetAddress();
            } else if (serverSocket != null) {
                remoteInetAddr = serverSocket.getInetAddress();
            }
            if (remoteInetAddr != null) {
                if (Constants.isSkipHostnameVerificationForHosts(remoteInetAddr.getHostName(), allowHostList) || Constants.isSkipHostnameVerificationForHosts(remoteInetAddr.getHostAddress(), allowHostList)) {
                    endpointId = null;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"remoteInetAddr is NULL, Socket is not connected at this moment. com.ibm.ws.ssl.skipHostnameVerificationForHosts property is not used.");
            }
        } else {
            endpointId = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEndpointIdentificationAlgorithm " + endpointId));
        }
        return endpointId;
    }
}

