/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.network.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPort;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.SemanticAttributes;

public final class InternalClientAttributesExtractor<REQUEST> {
    private final AddressAndPortExtractor<REQUEST> addressAndPortExtractor;
    private final boolean capturePort;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalClientAttributesExtractor(AddressAndPortExtractor<REQUEST> addressAndPortExtractor, boolean capturePort, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.addressAndPortExtractor = addressAndPortExtractor;
        this.capturePort = capturePort;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        AddressAndPort clientAddressAndPort = this.addressAndPortExtractor.extract(request);
        if (clientAddressAndPort.address != null) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.CLIENT_ADDRESS, clientAddressAndPort.address);
                if (this.capturePort && clientAddressAndPort.port != null && clientAddressAndPort.port > 0) {
                    AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.CLIENT_PORT, Long.valueOf(clientAddressAndPort.port.intValue()));
                }
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_CLIENT_IP, clientAddressAndPort.address);
            }
        }
    }
}

