/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.PersistentTimerHandle;
import com.ibm.ejs.container.PersistentTimerTaskHandler;
import com.ibm.ejs.container.passivator.PassivatorSerializable;
import com.ibm.ejs.container.passivator.PassivatorSerializableHandle;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.util.ParsedScheduleExpression;
import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public abstract class PersistentTimer
implements Timer,
PassivatorSerializable {
    private static final TraceComponent tc = Tr.register(PersistentTimer.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    protected Long taskId;
    protected J2EEName j2eeName;
    protected boolean isTimeoutCallback;
    protected int cachedTimerDataAllowed;
    protected PersistentTimerTaskHandler cachedTaskHandler;

    protected PersistentTimer(Long taskId, J2EEName j2eeName, int cachedTimerDataAllowed, PersistentTimerTaskHandler taskHandler) {
        this.taskId = taskId;
        this.j2eeName = j2eeName;
        this.cachedTimerDataAllowed = cachedTimerDataAllowed;
        this.cachedTaskHandler = taskHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init> : " + this), (Object[])new Object[0]);
        }
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        Date nextTime = this.getNextTimeout(8);
        long currentTime = System.currentTimeMillis();
        long remaining = nextTime.getTime() - currentTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTimeRemaining: " + remaining), (Object[])new Object[0]);
        }
        return remaining;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        Date nextTime = this.getNextTimeout(4);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getNextTimeout: " + nextTime), (Object[])new Object[0]);
        }
        return nextTime;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInfo: " + this), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        PersistentTimerTaskHandler taskHandler = this.getTimerTaskHandler(2);
        Serializable userInfo = taskHandler.getUserInfo();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInfo: " + Util.identity((Object)userInfo)));
        }
        return userInfo;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getHandle: " + this), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        this.checkTimerExists(1);
        PersistentTimerHandle timerHandle = new PersistentTimerHandle(this.taskId, false);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getHandle: " + timerHandle));
        }
        return timerHandle;
    }

    public ScheduleExpression getSchedule() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSchedule: " + this), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        PersistentTimerTaskHandler taskHandler = this.getTimerTaskHandler(16);
        ParsedScheduleExpression parsedSchedule = taskHandler.getParsedSchedule();
        if (parsedSchedule == null) {
            IllegalStateException ise = new IllegalStateException("Timer is not a calendar-based timer: " + this.toString());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getSchedule: " + ise));
            }
            throw ise;
        }
        ScheduleExpression schedule = EJSContainer.getDefaultContainer().ivObjectCopier.copy(parsedSchedule.getSchedule());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSchedule: " + schedule));
        }
        return schedule;
    }

    public boolean isPersistent() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isPersistent: " + this), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        this.checkTimerExists(32);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isPersistent: true");
        }
        return true;
    }

    public boolean isCalendarTimer() {
        boolean result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isCalendarTimer: " + this), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        PersistentTimerTaskHandler taskHandler = this.getTimerTaskHandler(64);
        boolean bl = result = taskHandler.getParsedSchedule() != null;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isCalendarTimer: " + result));
        }
        return result;
    }

    @Override
    public PassivatorSerializableHandle getSerializableObject() {
        return new PersistentTimerHandle(this.taskId, true);
    }

    protected abstract Date getNextTimeout(int var1) throws IllegalStateException, NoSuchObjectLocalException, EJBException;

    protected boolean isAnyCachingAllowed() {
        return this.isTimeoutCallback || this.cachedTimerDataAllowed != 0;
    }

    protected boolean isCachingAllowed(int operation) {
        return this.isTimeoutCallback || (this.cachedTimerDataAllowed & operation) != 0;
    }

    protected abstract PersistentTimerTaskHandler getTimerTaskHandler(int var1);

    protected void checkTimerAccess() {
        BeanO beanO = EJSContainer.getCallbackBeanO();
        if (beanO != null) {
            beanO.checkTimerServiceAccess();
        } else if (EJSContainer.getDefaultContainer().allowTimerAccessOutsideBean) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkTimerAccess: Timer access permitted outside of bean", (Object[])new Object[0]);
            }
        } else {
            IllegalStateException ise = new IllegalStateException("Timer methods not allowed - no active EJB");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkTimerAccess: " + ise), (Object[])new Object[0]);
            }
            throw ise;
        }
        if (this.taskId == null) {
            NoSuchObjectLocalException nsoe = new NoSuchObjectLocalException(this.toString());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkTimerAccess: " + (Object)((Object)nsoe)), (Object[])new Object[0]);
            }
            throw nsoe;
        }
    }

    protected abstract void checkTimerExists(int var1);

    public boolean equals(Object obj) {
        if (obj instanceof PersistentTimer) {
            if (this.taskId == null) {
                return this == obj;
            }
            PersistentTimer timer = (PersistentTimer)obj;
            return this.taskId.equals(timer.taskId);
        }
        return false;
    }

    public int hashCode() {
        return this.taskId == null ? 0 : (int)(this.taskId % Integer.MAX_VALUE);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.taskId + ", " + this.j2eeName + ")";
    }
}

