/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import jakarta.servlet.jsp.tagext.FunctionInfo;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagFileInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import jakarta.servlet.jsp.tagext.TagLibraryInfo;
import jakarta.servlet.jsp.tagext.TagLibraryValidator;
import jakarta.servlet.jsp.tagext.TagVariableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class TagLibraryInfoImpl
extends TagLibraryInfo {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TagLibraryInfoImpl";
    private static String TSX_URI = "http://websphere.ibm.com/tags/tsx";
    private static String JSX_URI = "http://websphere.ibm.com/tags/jsx";
    protected String tldOriginatorId;
    protected JspInputSource inputSource;
    protected Class tlvClass;
    protected Map tlvInitParams;
    protected HashMap<String, TagLibraryInfoImpl> tagLibMap;
    protected boolean container;
    static final long serialVersionUID = 7587798494651791206L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TagLibraryInfoImpl(String tldOriginatorId, JspInputSource inputSource) {
        super("", "");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{tldOriginatorId, inputSource});
        }
        this.tldOriginatorId = "";
        this.inputSource = null;
        this.tlvClass = null;
        this.tlvInitParams = null;
        this.tagLibMap = null;
        this.container = false;
        this.tldOriginatorId = tldOriginatorId;
        this.inputSource = inputSource;
        if (this.inputSource instanceof JspInputSourceContainerImpl) {
            this.container = true;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TagLibraryInfoImpl(String prefix, String uri, String tldOriginatorId, JspInputSource inputSource) {
        super(prefix, uri);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{prefix, uri, tldOriginatorId, inputSource});
        }
        this.tldOriginatorId = "";
        this.inputSource = null;
        this.tlvClass = null;
        this.tlvInitParams = null;
        this.tagLibMap = null;
        this.container = false;
        this.tldOriginatorId = tldOriginatorId;
        this.inputSource = inputSource;
        if (this.inputSource instanceof JspInputSourceContainerImpl) {
            this.container = true;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getTldFilePath() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getTldFilePath", new Object[0]);
        }
        String string = this.inputSource.getRelativeURL();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getTldFilePath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getLoadedTimestamp() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getLoadedTimestamp", new Object[0]);
        }
        long l = this.inputSource.getLastModified();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting(CLASS_NAME, "getLoadedTimestamp", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspInputSource getInputSource() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getInputSource", new Object[0]);
        }
        JspInputSource jspInputSource = this.inputSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspInputSource = jspInputSource;
            logger.exiting(CLASS_NAME, "getInputSource", jspInputSource);
        }
        return jspInputSource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setPrefixString(String prefix) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setPrefixString", new Object[]{prefix});
        }
        this.prefix = prefix;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setPrefixString");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setURI(String uri) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setURI", new Object[]{uri});
        }
        this.uri = uri;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setURI");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setInfoString(String info) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setInfoString", new Object[]{info});
        }
        this.info = info;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setInfoString");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setReliableURN(String urn) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setReliableURN", new Object[]{urn});
        }
        this.urn = urn;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setReliableURN");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setRequiredVersion(String version) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setRequiredVersion", new Object[]{version});
        }
        this.jspversion = version;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setRequiredVersion");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setShortName(String shortname) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setShortName", new Object[]{shortname});
        }
        this.shortname = shortname;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setShortName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setTlibversion(String tlibversion) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setTlibversion", new Object[]{tlibversion});
        }
        this.tlibversion = tlibversion;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setTlibversion");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setTags(List tagList) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setTags", new Object[]{tagList});
        }
        this.tags = new TagInfo[tagList.size()];
        if (tagList.size() > 0) {
            this.tags = tagList.toArray(this.tags);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setTags");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setTags(TagInfo[] tags) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setTags", new Object[]{tags});
        }
        this.tags = tags;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setTags");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setTagFiles(List tagFileList) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setTagFiles", new Object[]{tagFileList});
        }
        this.tagFiles = new TagFileInfo[tagFileList.size()];
        if (tagFileList.size() > 0) {
            this.tagFiles = tagFileList.toArray(this.tagFiles);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setTagFiles");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setTagFiles(TagFileInfo[] tagFiles) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setTagFiles", new Object[]{tagFiles});
        }
        this.tagFiles = tagFiles;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setTagFiles");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setFunctions(List functionList) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setFunctions", new Object[]{functionList});
        }
        this.functions = new FunctionInfo[functionList.size()];
        if (functionList.size() > 0) {
            this.functions = functionList.toArray(this.functions);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setFunctions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setFunctions(FunctionInfo[] functions) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setFunctions", new Object[]{functions});
        }
        this.functions = functions;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setFunctions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setTabLibraryValidator(Class tlvClass, Map tlvInitParams) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setTabLibraryValidator", new Object[]{tlvClass, tlvInitParams});
        }
        this.tlvClass = tlvClass;
        this.tlvInitParams = tlvInitParams;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setTabLibraryValidator");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TagLibraryValidator getTagLibraryValidator() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getTagLibraryValidator", new Object[0]);
        }
        TagLibraryValidator tlv = null;
        if (this.tlvClass != null) {
            try {
                tlv = (TagLibraryValidator)this.tlvClass.newInstance();
                if (this.tlvInitParams != null) {
                    tlv.setInitParameters(this.tlvInitParams);
                } else {
                    tlv.setInitParameters(new HashMap());
                }
            }
            catch (IllegalAccessException e) {
                logger.logp(Level.WARNING, CLASS_NAME, "getTagLibraryValidator", "Illegal access of tag library validator [" + this.tlvClass.getName() + "]", e);
            }
            catch (InstantiationException e) {
                logger.logp(Level.WARNING, CLASS_NAME, "getTagLibraryValidator", "Failed to instantiate tag library validator [" + this.tlvClass.getName() + "]", e);
            }
            catch (NoClassDefFoundError e) {
                logger.logp(Level.WARNING, CLASS_NAME, "getTagLibraryValidator", "Failed to instantiate tag library validator [" + this.tlvClass.getName() + "]", e);
            }
        }
        TagLibraryValidator tagLibraryValidator = tlv;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            tagLibraryValidator = tagLibraryValidator;
            logger.exiting(CLASS_NAME, "getTagLibraryValidator", tagLibraryValidator);
        }
        return tagLibraryValidator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getTlibversion() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getTlibversion", new Object[0]);
        }
        String string = this.tlibversion;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getTlibversion", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TagLibraryInfoImpl copy(String prefix) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "copy", new Object[]{prefix});
        }
        TagLibraryInfoImpl tli = new TagLibraryInfoImpl(prefix, this.uri, this.tldOriginatorId, this.inputSource);
        tli.setInfoString(this.info);
        tli.setReliableURN(this.urn);
        tli.setRequiredVersion(this.jspversion);
        tli.setShortName(this.shortname);
        tli.setTlibversion(this.tlibversion);
        tli.setTags(this.tags);
        tli.setTagFiles(this.tagFiles);
        tli.setFunctions(this.functions);
        tli.setTabLibraryValidator(this.tlvClass, this.tlvInitParams);
        tli.setTagLibMap(this.tagLibMap);
        TagLibraryInfoImpl tagLibraryInfoImpl = tli;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            tagLibraryInfoImpl = tagLibraryInfoImpl;
            logger.exiting(CLASS_NAME, "copy", (Object)tagLibraryInfoImpl);
        }
        return tagLibraryInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getOriginatorId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getOriginatorId", new Object[0]);
        }
        String string = this.tldOriginatorId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getOriginatorId", string);
        }
        return string;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("TagLibraryInfo name [");
        if (this.shortname != null) {
            sb.append(this.shortname);
        }
        sb.append("] info [");
        if (this.info != null) {
            sb.append(this.info);
        }
        sb.append("] urn [");
        if (this.urn != null) {
            sb.append(this.urn);
        }
        sb.append("] jspversion [");
        if (this.jspversion != null) {
            sb.append(this.jspversion);
        }
        sb.append("] tlibversion [");
        if (this.tlibversion != null) {
            sb.append(this.tlibversion);
        }
        sb.append("]\n");
        if (this.tags != null) {
            for (i = 0; i < this.tags.length; ++i) {
                this.tagToString(sb, this.tags[i]);
            }
        }
        if (this.tagFiles != null) {
            for (i = 0; i < this.tagFiles.length; ++i) {
                sb.append("tagFile name [");
                if (this.tagFiles[i].getName() != null) {
                    sb.append(this.tagFiles[i].getName());
                }
                sb.append("] path [");
                if (this.tagFiles[i].getPath() != null) {
                    sb.append(this.tagFiles[i].getPath());
                }
                sb.append("]\n");
                if (this.tagFiles[i].getTagInfo() == null) continue;
                this.tagToString(sb, this.tagFiles[i].getTagInfo());
            }
        }
        if (this.functions != null) {
            for (i = 0; i < this.functions.length; ++i) {
                sb.append("function name [");
                if (this.functions[i].getName() != null) {
                    sb.append(this.functions[i].getName());
                }
                sb.append("] class [");
                if (this.functions[i].getFunctionClass() != null) {
                    sb.append(this.functions[i].getFunctionClass());
                }
                sb.append("] signature [");
                if (this.functions[i].getFunctionSignature() != null) {
                    sb.append(this.functions[i].getFunctionSignature());
                }
                sb.append("]\n");
            }
        }
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void tagToString(StringBuffer sb, TagInfo tag) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "tagToString", new Object[]{sb, tag});
        }
        sb.append("tag tagName [");
        if (tag.getTagName() != null) {
            sb.append(tag.getTagName());
        }
        sb.append("] tagClassName [");
        if (tag.getTagClassName() != null) {
            sb.append(tag.getTagClassName());
        }
        sb.append("] bodycontent [");
        if (tag.getBodyContent() != null) {
            sb.append(tag.getBodyContent());
        }
        sb.append("] info [");
        if (tag.getInfoString() != null) {
            sb.append(tag.getInfoString());
        }
        sb.append("] displayName [");
        if (tag.getDisplayName() != null) {
            sb.append(tag.getDisplayName());
        }
        sb.append("] smallIcon [");
        if (tag.getSmallIcon() != null) {
            sb.append(tag.getSmallIcon());
        }
        sb.append("] largeIcon [");
        if (tag.getLargeIcon() != null) {
            sb.append(tag.getLargeIcon());
        }
        sb.append("] dynamicAttributes [");
        sb.append(tag.hasDynamicAttributes());
        sb.append("]\n");
        if (tag.getAttributes() != null) {
            TagAttributeInfo[] attributes = tag.getAttributes();
            TagLibraryInfoImpl.printTagAttributeInfo(sb, attributes);
        }
        if (tag.getTagVariableInfos() != null) {
            TagVariableInfo[] variables = tag.getTagVariableInfos();
            TagLibraryInfoImpl.printTagVariableInfo(sb, variables);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "tagToString");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void printTagVariableInfo(StringBuffer sb, TagVariableInfo[] variables) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "printTagVariableInfo", new Object[]{sb, variables});
        }
        if (variables != null) {
            for (int j = 0; j < variables.length; ++j) {
                sb.append("variable nameGiven [");
                if (variables[j].getNameGiven() != null) {
                    sb.append(variables[j].getNameGiven());
                }
                sb.append("] nameFromAttribute [");
                if (variables[j].getNameFromAttribute() != null) {
                    sb.append(variables[j].getNameFromAttribute());
                }
                sb.append("] className [");
                if (variables[j].getClassName() != null) {
                    sb.append(variables[j].getClassName());
                }
                sb.append("] declare [");
                sb.append(variables[j].getDeclare());
                sb.append("] scope [");
                sb.append(variables[j].getScope());
                sb.append("]\n");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "printTagVariableInfo");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void printTagAttributeInfo(StringBuffer sb, TagAttributeInfo[] attributes) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "printTagAttributeInfo", new Object[]{sb, attributes});
        }
        if (attributes != null) {
            for (int j = 0; j < attributes.length; ++j) {
                sb.append("attribute name [");
                if (attributes[j].getName() != null) {
                    sb.append(attributes[j].getName());
                }
                sb.append("] type [");
                if (attributes[j].getTypeName() != null) {
                    sb.append(attributes[j].getTypeName());
                }
                sb.append("] requestTime [");
                sb.append(attributes[j].canBeRequestTime());
                sb.append("] fragment [");
                sb.append(attributes[j].isFragment());
                sb.append("] required [");
                sb.append(attributes[j].isRequired());
                sb.append("] isDeferredMethod [");
                sb.append(attributes[j].isDeferredMethod());
                sb.append("] isDeferredValue [");
                sb.append(attributes[j].isDeferredValue());
                sb.append("] ExpectedTypeName [");
                sb.append(attributes[j].getExpectedTypeName());
                sb.append("] MethodSignature [");
                sb.append(attributes[j].getMethodSignature());
                sb.append("]\n");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "printTagAttributeInfo");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setTagLibMap(HashMap<String, TagLibraryInfoImpl> tlibMap) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setTagLibMap", new Object[]{tlibMap});
        }
        this.tagLibMap = tlibMap;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "setTagLibMap", "setTagLibMap:tlibMap =[" + tlibMap + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setTagLibMap");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TagLibraryInfo[] getTagLibraryInfos() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getTagLibraryInfos", new Object[0]);
        }
        if (this.tagLibMap != null) {
            ArrayList<TagLibraryInfoImpl> coll = new ArrayList<TagLibraryInfoImpl>();
            Set<String> keys = this.tagLibMap.keySet();
            Iterator<String> itr = keys.iterator();
            TagLibraryInfoImpl item = null;
            String uri = null;
            while (itr.hasNext()) {
                uri = itr.next();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getTagLibraryInfos", "getTagLibraryInfos tagLibMap uri=[" + uri + "]");
                }
                if (uri.equals(TSX_URI) || uri.equals(JSX_URI)) continue;
                item = this.tagLibMap.get(uri);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "getTagLibraryInfos", "getTagLibraryInfos tagLibMap item to add to list=[" + item.uri + "]");
                }
                coll.add(item);
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getTagLibraryInfos", "getTagLibraryInfos:tlibMap after removing jsx and tsx=[" + coll.toString() + "]");
            }
            TagLibraryInfo[] tagLibraryInfoArray = coll.toArray(new TagLibraryInfo[0]);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                tagLibraryInfoArray = tagLibraryInfoArray;
                logger.exiting(CLASS_NAME, "getTagLibraryInfos", tagLibraryInfoArray);
            }
            return tagLibraryInfoArray;
        }
        TagLibraryInfo[] tagLibraryInfoArray = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            tagLibraryInfoArray = tagLibraryInfoArray;
            logger.exiting(CLASS_NAME, "getTagLibraryInfos", tagLibraryInfoArray);
        }
        return tagLibraryInfoArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isContainer() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isContainer", new Object[0]);
        }
        boolean bl = this.container;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isContainer", bl);
        }
        return bl;
    }
}

