/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.ssl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.ssl.NoSSLSocketFactoryException;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={SecuritySSLUtils.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE)
public class SecuritySSLUtils {
    public static final TraceComponent tc = Tr.register(SecuritySSLUtils.class, null, null);
    private static final String KEY_SSL_SUPPORT = "sslSupport";
    protected static volatile SSLSupport sslSupport;
    static final long serialVersionUID = 484014071484296142L;

    @Reference(name="sslSupport", policy=ReferencePolicy.DYNAMIC)
    public void setSslSupport(SSLSupport sslSupportSvc) {
        sslSupport = sslSupportSvc;
    }

    public void unsetSslSupport(SSLSupport sslSupportSvc) {
        sslSupport = null;
    }

    public static SSLSocketFactory getSSLSocketFactory(SSLSupport sslSupport, String sslConfigurationName) throws SSLException, NoSSLSocketFactoryException {
        SSLSocketFactory sslSocketFactory = null;
        if (sslSupport != null) {
            sslSocketFactory = sslSupport.getSSLSocketFactory(sslConfigurationName);
        }
        if (sslSocketFactory == null) {
            throw new NoSSLSocketFactoryException();
        }
        return sslSocketFactory;
    }

    public static SSLSocketFactory getSSLSocketFactory(SSLSupport sslSupport) throws SSLException, NoSSLSocketFactoryException {
        SSLSocketFactory sslSocketFactory = null;
        if (sslSupport != null) {
            sslSocketFactory = sslSupport.getSSLSocketFactory();
        }
        if (sslSocketFactory == null) {
            throw new NoSSLSocketFactoryException();
        }
        return sslSocketFactory;
    }

    public String getKeyStoreRef(String sslRef) {
        return this.getSslConfigProperty(sslRef, "com.ibm.ssl.keyStoreName");
    }

    public String getTrustStoreRef(String sslRef) {
        return this.getSslConfigProperty(sslRef, "com.ibm.ssl.trustStoreName");
    }

    String getSslConfigProperty(String sslRef, String propertyName) {
        String propertyValue = null;
        if (sslRef == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sslRef not configured", (Object[])new Object[0]);
            }
            return null;
        }
        Properties sslConfigProps = this.getSslConfigProperties(sslRef);
        if (sslConfigProps != null) {
            propertyValue = sslConfigProps.getProperty(propertyName);
        }
        return propertyValue;
    }

    @FFDCIgnore(value={Exception.class})
    Properties getSslConfigProperties(final String sslRef) {
        Properties sslConfigProps;
        if (sslSupport == null) {
            return null;
        }
        try {
            final HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "inbound");
            sslConfigProps = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = 55761879636700780L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    return sslSupport.getJSSEHelper().getProperties(sslRef, connectionInfo, null, true);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.ssl.SecuritySSLUtils$1", 1.class, null, null);
                }
            });
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting SSL properties: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        return sslConfigProps;
    }
}

