/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.filetransfer.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.filetransfer.routing.archiveExpander.ArchiveExpander;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileServiceUtil {
    private static final TraceComponent tc = Tr.register(FileServiceUtil.class, null, null);
    private String _parentOfOriginalSourcePath = null;
    static final long serialVersionUID = -5119321548955925414L;

    /*
     * WARNING - void declaration
     */
    public boolean createArchive(String sourcePath, String targetPath) {
        try {
            File source = new File(sourcePath).getCanonicalFile();
            if (!FileUtils.fileExists((File)source)) {
                return false;
            }
            File target = new File(targetPath).getCanonicalFile();
            this._parentOfOriginalSourcePath = source.getParent();
            if (this._parentOfOriginalSourcePath.endsWith(File.separator)) {
                this._parentOfOriginalSourcePath = this._parentOfOriginalSourcePath.substring(0, this._parentOfOriginalSourcePath.length() - 1);
            }
            FileUtils.fileMkDirs((File)target.getParentFile());
            this.createNewFile(target);
            ZipOutputStream out = new ZipOutputStream(this.getOutputStream(target));
            if (FileUtils.fileIsFile((File)source)) {
                this.archiveFile(source, out);
            } else if (FileUtils.fileIsDirectory((File)source)) {
                this.archiveDirectory(source, out);
            }
            out.close();
        }
        catch (Exception source) {
            void e;
            FFDCFilter.processException((Throwable)source, (String)"com.ibm.ws.filetransfer.util.FileServiceUtil", (String)"100", (Object)this, (Object[])new Object[]{sourcePath, targetPath});
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createArchive");
            return false;
        }
        return true;
    }

    private void archiveFile(File src, ZipOutputStream out) throws Exception {
        int len;
        byte[] buf = new byte[1024];
        FileInputStream in = (FileInputStream)FileUtils.getInputStream((File)src);
        String relativePath = src.getPath().substring(this._parentOfOriginalSourcePath.length() + 1);
        out.putNextEntry(new ZipEntry(relativePath));
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.closeEntry();
        in.close();
    }

    private void archiveDirectory(File src, ZipOutputStream out) throws Exception {
        String[] entities = FileUtils.list((File)src);
        for (int i = 0; i < entities.length; ++i) {
            File entity = new File(src, entities[i]);
            if (FileUtils.fileIsFile((File)entity)) {
                this.archiveFile(entity, out);
                continue;
            }
            if (!FileUtils.fileIsDirectory((File)entity)) continue;
            this.archiveDirectory(entity, out);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean expandArchive(String sourcePath, String targetPath) {
        try {
            return ArchiveExpander.coreExpandArchive((String)sourcePath, (String)targetPath);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.filetransfer.util.FileServiceUtil", (String)"166", (Object)this, (Object[])new Object[]{sourcePath, targetPath});
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"expandArchive");
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private OutputStream getOutputStream(final File target) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){
                static final long serialVersionUID = 91874789155684355L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public OutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(target);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.filetransfer.util.FileServiceUtil$1", 1.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.filetransfer.util.FileServiceUtil", (String)"181", (Object)this, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof FileNotFoundException) {
                throw (FileNotFoundException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean createNewFile(final File target) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = -5402615677950717566L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() throws IOException {
                    return target.createNewFile();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.filetransfer.util.FileServiceUtil$2", 2.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.filetransfer.util.FileServiceUtil", (String)"200", (Object)this, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
    }

    private static boolean isWindowsRootDirectory(String path) {
        return path.length() == 3 && FileServiceUtil.isAlpha(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == '/';
    }

    @Trivial
    private static final boolean isAlpha(char c) {
        return FileServiceUtil.isLowerAlpha(c) || FileServiceUtil.isUpperAlpha(c);
    }

    @Trivial
    private static final boolean isLowerAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    @Trivial
    private static final boolean isUpperAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isPathContained(List<String> allowedPaths, String targetPath) {
        if (allowedPaths == null || allowedPaths.isEmpty() || targetPath == null) {
            return false;
        }
        if (!targetPath.isEmpty() && targetPath.charAt(targetPath.length() - 1) == '/' && targetPath.length() > 1 && !FileServiceUtil.isWindowsRootDirectory(targetPath)) {
            targetPath = targetPath.substring(0, targetPath.length() - 1);
        }
        while (targetPath != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Target path: " + targetPath), (Object[])new Object[0]);
            }
            for (int i = 0; i < allowedPaths.size(); ++i) {
                String allowedPath = allowedPaths.get(i);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Checking path: " + allowedPath), (Object[])new Object[0]);
                }
                if ("".equals(allowedPath)) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Skipping an empty path", (Object[])new Object[0]);
                    continue;
                }
                if (!allowedPath.equalsIgnoreCase(targetPath)) continue;
                return true;
            }
            targetPath = FileServiceUtil.getNormalizedParent(targetPath);
        }
        return false;
    }

    private static String getNormalizedParent(String filePath) {
        if (new File(filePath).getParent() == null) {
            return null;
        }
        String parentDir = filePath.substring(0, filePath.lastIndexOf("/"));
        if (!parentDir.contains("/")) {
            parentDir = parentDir + "/";
        }
        return parentDir;
    }
}

