/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class RestClientListeners {
    private static Map<ClassLoader, Collection<RestClientListener>> map;
    static final long serialVersionUID = -8579301149512703957L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private RestClientListeners() {
    }

    public static Collection<RestClientListener> get() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Collection<RestClientListener> c = map.get(loader);
                if (c == null) {
                    c = new ArrayList<RestClientListener>();
                    ServiceLoader.load(RestClientListener.class, loader).forEach(c::add);
                    map.put(loader, Collections.unmodifiableCollection(c));
                }
                return c;
            });
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Collection<RestClientListener> c = map.get(loader);
        if (c == null) {
            c = new ArrayList<RestClientListener>();
            ServiceLoader.load(RestClientListener.class, loader).forEach(c::add);
            map.put(loader, Collections.unmodifiableCollection(c));
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.microprofile.client.RestClientListeners", RestClientListeners.class, null, null);
        map = Collections.synchronizedMap(new WeakHashMap());
    }
}

