/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.memory;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.store.memory.TooManySessionsException;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.session.utils.SessionHashSet;
import com.ibm.wsspi.session.IStore;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class SessionSimpleHashMap
extends HashMap {
    private IStore _iStore;
    private int maxSize;
    private int currentSize = 0;
    private HashMap OverflowTabl;
    private Serializable OverflowTablLock = new SerializableObject();
    boolean overflowAllowed;
    private static final long serialVersionUID = 6091018332887652886L;
    private static final String methodClassName = "SessionSimpleHashMap";
    private String appNameForLogging = "";
    private static final int GET = 0;
    private static final int REMOVE = 1;
    private static final int KEYSET = 2;
    private static final int PUT = 3;
    private static final String[] methodNames = new String[]{"get", "remove", "keySet", "put"};

    public SessionSimpleHashMap(IStore iStore, int maxCapacity, boolean overflow) {
        super(maxCapacity + 20, 1.0f);
        this.maxSize = maxCapacity;
        this.overflowAllowed = overflow;
        this._iStore = iStore;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            this.appNameForLogging = " AppName=" + this._iStore.getId();
            String s = "capacity is: " + this.maxSize + " overflow is: " + this.overflowAllowed + this.appNameForLogging;
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodClassName, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object put(Object key, Object value) {
        Serializable serializable;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("{").append(key).append("} ").append(this.appNameForLogging);
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[3], sb.toString());
        }
        Object replacedEntry = null;
        Object currEntry = super.get(key);
        if (currEntry != null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], "replacing existing entry");
            }
            replacedEntry = super.put(key, value);
        } else if (this.overflowAllowed && this.OverflowTabl != null) {
            serializable = this.OverflowTablLock;
            synchronized (serializable) {
                currEntry = this.OverflowTabl.get(key);
                if (currEntry != null) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], "replacing existing entry in overflow Hashmap");
                    }
                    replacedEntry = this.OverflowTabl.put(key, value);
                }
            }
        }
        if (currEntry == null) {
            ++this.currentSize;
            if (this._iStore.getStoreCallback() != null) {
                this._iStore.getStoreCallback().sessionLiveCountInc(value);
            }
            if (this.currentSize <= this.maxSize) {
                replacedEntry = super.put(key, value);
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], "add new entry to Hashmap");
                }
            } else {
                --this.currentSize;
                if (this.overflowAllowed) {
                    serializable = this.OverflowTablLock;
                    synchronized (serializable) {
                        if (this.OverflowTabl == null) {
                            this.OverflowTabl = new HashMap(this.currentSize, 1.0f);
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], "Creating Overflow Table");
                            }
                        }
                        replacedEntry = this.OverflowTabl.put(key, value);
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], "add new entry to overflow Hashmap");
                        }
                    }
                } else {
                    throw new TooManySessionsException();
                }
            }
        }
        return replacedEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            String s = key + this.appNameForLogging;
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], s);
        }
        Object currEntry = super.get(key);
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && currEntry != null) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0], "key found in HashMap");
        }
        if (currEntry == null && this.overflowAllowed && this.OverflowTabl != null) {
            Serializable serializable = this.OverflowTablLock;
            synchronized (serializable) {
                currEntry = this.OverflowTabl.get(key);
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && currEntry != null) {
                    LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0], "key found in overflow HashMap");
                }
            }
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER) && currEntry == null) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0], "key not found");
        }
        return currEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object remove(Object key) {
        Object removedEntry;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            String s = key + this.appNameForLogging;
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[1], s);
        }
        if ((removedEntry = super.remove(key)) != null) {
            --this.currentSize;
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1], "key removed from HashMap");
            }
        } else {
            if (this.overflowAllowed && this.OverflowTabl != null) {
                Serializable serializable = this.OverflowTablLock;
                synchronized (serializable) {
                    removedEntry = this.OverflowTabl.remove(key);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                String message = removedEntry != null ? "key removed from overflow HashMap" : "key not found";
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1], message);
            }
        }
        return removedEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() {
        super.clear();
        this.currentSize = 0;
        if (this.OverflowTabl != null) {
            Serializable serializable = this.OverflowTablLock;
            synchronized (serializable) {
                this.OverflowTabl.clear();
            }
            this.OverflowTabl = null;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set keySet() {
        Object[] keys;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[2], this.appNameForLogging);
        }
        int keysLen = 0;
        Object[] allKeys = null;
        Object[] overflowKeys = null;
        int overflowKeysLen = 0;
        Set myKeySet = super.keySet();
        SessionSimpleHashMap sessionSimpleHashMap = this;
        synchronized (sessionSimpleHashMap) {
            keys = myKeySet.toArray();
            keysLen = keys.length;
            if (this.OverflowTabl != null) {
                Set overflowKeySet = this.OverflowTabl.keySet();
                Serializable serializable = this.OverflowTablLock;
                synchronized (serializable) {
                    overflowKeys = overflowKeySet.toArray();
                    overflowKeysLen = overflowKeys.length;
                }
            }
        }
        int allKeysLen = keysLen + overflowKeysLen;
        if (allKeysLen != 0) {
            allKeys = new Object[allKeysLen];
            if (keysLen != 0) {
                System.arraycopy(keys, 0, allKeys, 0, keysLen);
            }
            if (overflowKeysLen != 0) {
                System.arraycopy(overflowKeys, 0, allKeys, keysLen, overflowKeysLen);
            }
        }
        SessionHashSet keySet = new SessionHashSet(allKeys);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2], keySet);
        }
        return keySet;
    }

    public Object accessEntry(Object key) {
        return this.get(key);
    }

    public Object insertEntry(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public int getOverflowSize() {
        int overflowSize = 0;
        if (this.OverflowTabl != null) {
            overflowSize = this.OverflowTabl.size();
        }
        return overflowSize;
    }

    private static class SerializableObject
    implements Serializable {
        private static final long serialVersionUID = -1713215368202372876L;

        private SerializableObject() {
        }
    }
}

