/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.annocache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.annocache.service.AnnotationCacheService_Service;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AnnotationsAdapterImpl {
    public static final TraceComponent tc = Tr.register(AnnotationsAdapterImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    protected volatile int eeVersion;
    private ServiceReference<JavaEEVersion> eeVersionRef;
    private ServiceReference<JavaEEVersion> versionRef;
    protected volatile Version platformVersion = JavaEEVersion.DEFAULT_VERSION;
    @Reference(service=AnnotationCacheService_Service.class)
    protected AnnotationCacheService_Service annoCacheService;
    static final long serialVersionUID = 7923177598756152248L;

    @Reference(service=JavaEEVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEEVersion(ServiceReference<JavaEEVersion> ref) {
        String version = (String)ref.getProperty("version");
        if (version == null) {
            this.eeVersion = 0;
        } else {
            int dot = version.indexOf(46);
            String major = dot > 0 ? version.substring(0, dot) : version;
            this.eeVersion = Integer.parseInt(major);
        }
        this.eeVersionRef = ref;
    }

    protected void unsetEEVersion(ServiceReference<JavaEEVersion> ref) {
        if (this.eeVersionRef == ref) {
            this.eeVersionRef = null;
            this.eeVersion = 0;
        }
    }

    @Reference(service=JavaEEVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void setVersion(ServiceReference<JavaEEVersion> reference) {
        this.versionRef = reference;
        this.platformVersion = Version.parseVersion((String)((String)reference.getProperty("version")));
    }

    protected synchronized void unsetVersion(ServiceReference<JavaEEVersion> reference) {
        if (reference == this.versionRef) {
            this.versionRef = null;
            this.platformVersion = JavaEEVersion.DEFAULT_VERSION;
        }
    }

    public AnnotationCacheService_Service getAnnoCacheService() throws UnableToAdaptException {
        if (this.annoCacheService == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"annotation.service.not.available.CWWKM0451E", (Object[])new Object[]{"Annotation service not available"});
            throw new UnableToAdaptException(msg);
        }
        return this.annoCacheService;
    }

    public <T> T overlayGet(OverlayContainer overlayContainer, String targetPath, Class<T> targetClass) {
        Object targetObject = overlayContainer.getFromNonPersistentCache(targetPath, targetClass);
        if (tc.isDebugEnabled()) {
            String message = this.getClass().getSimpleName() + ": overlayGet [ " + overlayContainer + " ] [ " + targetPath + " ] [ " + targetClass + " ]: [ " + targetObject + " ]";
            Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        }
        return (T)targetObject;
    }

    public <T> void overlayPut(OverlayContainer overlayContainer, String targetPath, Class<T> targetClass, T targetObject) {
        if (tc.isDebugEnabled()) {
            String message = this.getClass().getSimpleName() + ": overlayPut [ " + overlayContainer + " ] [ " + targetPath + " ] [ " + targetClass + " ]: [ " + targetObject + " ]";
            Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        }
        overlayContainer.addToNonPersistentCache(targetPath, targetClass, targetObject);
    }
}

