/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ConnectionDescriptorImpl;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.tcpchannel.internal.BindInfo;
import com.ibm.ws.tcpchannel.internal.NewConnectionInitialReadCallback;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPFactoryConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.wsspi.channelfw.ConnectionDescriptor;
import com.ibm.wsspi.channelfw.InboundVirtualConnectionFactory;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.RetryableChannelException;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

public class TCPPort {
    private TCPChannel tcpChannel = null;
    private ServerSocket serverSocket = null;
    protected InboundVirtualConnectionFactory vcf = null;
    private TCPReadCompletedCallback cc = null;
    private int listenPort = 0;
    private TCPChannelConfiguration channelConfigX = null;
    private InetSocketAddress socketAddressX = null;
    private int currentTry = 1;
    private int portOpenRetries = 0;
    private final int timeBetweenRetriesMsec = 1000;
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private static final TraceComponent tc = Tr.register(TCPPort.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    protected TCPPort(TCPChannel _tcpChannel, VirtualConnectionFactory _vcf) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TCPPort", (Object[])new Object[0]);
        }
        this.tcpChannel = _tcpChannel;
        this.vcf = (InboundVirtualConnectionFactory)_vcf;
        this.cc = new NewConnectionInitialReadCallback(this.tcpChannel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TCPPort");
        }
    }

    protected synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private void attemptSocketBind(InetSocketAddress address, boolean reuseflag) throws IOException {
        this.serverSocket.setReuseAddress(reuseflag);
        this.serverSocket.bind(address, this.tcpChannel.getConfig().getListenBacklog());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ServerSocket bind worked, reuse=" + this.serverSocket.getReuseAddress()), (Object[])new Object[0]);
        }
    }

    private BindInfo portBoundEarly(int port) {
        Map binds;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("portBoundEarly(int): " + port), (Object[])new Object[0]);
        }
        if ((binds = TCPFactoryConfiguration.getEarlyBinds()) != null) {
            BindInfo b;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Got Map of early binds", (Object[])new Object[0]);
            }
            if ((b = (BindInfo)binds.get(port)) != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found Bind: " + b), (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"portBoundEarly(int)");
            }
            return b;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"portBoundEarly(int)");
        }
        return null;
    }

    protected ServerSocket openServerSocket() throws IOException {
        ServerSocketChannel ssc = ServerSocketChannel.open();
        return ssc.socket();
    }

    protected synchronized void destroyServerSocket() {
        if (null == this.serverSocket) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ServerSocket being closed for port " + this.listenPort), (Object[])new Object[0]);
        }
        this.closeServerSocket();
        this.serverSocket = null;
    }

    protected void closeServerSocket() {
        block2: {
            try {
                this.serverSocket.close();
            }
            catch (IOException ioe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("IOExeption on ServerSocket.close " + ioe.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    protected TCPChannel getTCPChannel() {
        return this.tcpChannel;
    }

    public void processNewConnection(SocketIOChannel socket) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processNewConnection", (Object[])new Object[0]);
        }
        VirtualConnection vc = this.vcf.createConnection();
        TCPConnLink bc = (TCPConnLink)this.tcpChannel.getConnectionLink(vc);
        TCPReadRequestContextImpl bcRead = bc.getTCPReadConnLink();
        bc.setSocketIOChannel(socket);
        ConnectionDescriptor cd = vc.getConnectionDescriptor();
        Socket s = socket.getSocket();
        InetAddress remote = s.getInetAddress();
        InetAddress local = s.getLocalAddress();
        if (cd != null) {
            cd.setAddrs(remote, local);
        } else {
            ConnectionDescriptorImpl cdi = new ConnectionDescriptorImpl(remote, local);
            vc.setConnectionDescriptor(cdi);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Processing Connection: " + vc.getConnectionDescriptor()), (Object[])new Object[0]);
        }
        int rc = vc.attemptToSetFileChannelCapable(2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("FileChannelCapable set in VC to: " + rc), (Object[])new Object[0]);
        }
        bcRead.setJITAllocateSize(bc.getConfig().getNewConnectionBufferSize());
        int timeout = bc.getConfig().getInactivityTimeout();
        if (timeout == 0) {
            timeout = -1;
        }
        vc.getStateMap().put("REMOTE_ADDRESS", bc.getRemoteAddress().getHostAddress());
        bcRead.read(1L, this.cc, true, timeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processNewConnection");
        }
    }

    protected int getListenPort() {
        return this.listenPort;
    }

    protected synchronized ServerSocket initServerSocket() throws IOException, RetryableChannelException {
        TCPChannelConfiguration channelConfig;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ServerSocket called, new ServerSocket needs to be created", (Object[])new Object[0]);
        }
        this.channelConfigX = channelConfig = this.tcpChannel.getConfig();
        this.currentTry = 1;
        this.portOpenRetries = this.channelConfigX.getPortOpenRetries();
        boolean stayInLoop = true;
        BindInfo earlyBind = this.portBoundEarly(channelConfig.getPort());
        if (earlyBind == null) {
            while (stayInLoop && this.currentTry <= this.portOpenRetries + 1) {
                stayInLoop = false;
                InetSocketAddress socketAddress = null;
                socketAddress = channelConfig.getHostname() == null ? new InetSocketAddress((InetAddress)null, channelConfig.getPort()) : new InetSocketAddress(channelConfig.getHostname(), channelConfig.getPort());
                if (!socketAddress.isUnresolved()) {
                    this.socketAddressX = socketAddress;
                    this.listenPort = channelConfig.getPort();
                    this.serverSocket = this.openServerSocket();
                    if (!channelConfig.getWaitToAccept()) {
                        try {
                            CHFWBundle.runWhenServerStarted(new Callable<Void>(){

                                @Override
                                public Void call() {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"CHFW signaled- finishInitServerSocket() to be called", (Object[])new Object[0]);
                                    }
                                    try {
                                        TCPPort.this.finishInitServerSocket();
                                    }
                                    catch (Exception x) {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("CHFW signaled- caught exception from finishInitServerSocket(): " + x), (Object[])new Object[0]);
                                        }
                                        TCPPort.this.tcpChannel.takeDownChain();
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (Exception x) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("CHFW signaled- caught exception:: " + x), (Object[])new Object[0]);
                        }
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"CHFW signaled- waitToAccept is true - finishInitServerSocket()", (Object[])new Object[0]);
                    }
                    this.finishInitServerSocket();
                    continue;
                }
                if (this.currentTry > this.portOpenRetries) {
                    String displayableHostName = channelConfig.getDisplayableHostname();
                    Tr.error((TraceComponent)tc, (String)"LOCAL_HOST_UNRESOLVED", (Object[])new Object[]{channelConfig.getChannelData().getExternalName(), displayableHostName, String.valueOf(channelConfig.getPort())});
                    throw new RetryableChannelException(new IOException("local address unresolved"));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("attempt " + this.currentTry + " of " + (this.portOpenRetries + 1) + " failed to resolve InetSocketAddress, will try again after wait interval"), (Object[])new Object[0]);
                }
                ++this.currentTry;
                stayInLoop = true;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException x) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"sleep caught InterruptedException.  will proceed.", (Object[])new Object[0]);
                }
            }
        } else {
            Exception e = earlyBind.getBindException();
            if (e == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found early bind, setting serverSocket and listenPort", (Object[])new Object[0]);
                }
                this.serverSocket = earlyBind.getServerSocket();
                this.listenPort = this.serverSocket.getLocalPort();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Early Bind generated the following exception: " + e), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"BIND_ERROR", (Object[])new Object[]{channelConfig.getChannelData().getExternalName(), earlyBind.getHostname(), String.valueOf(earlyBind.getPort()), e.getMessage()});
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RetryableChannelException) {
                    throw (RetryableChannelException)e;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"new ServerSocket successfully created", (Object[])new Object[0]);
        }
        return this.serverSocket;
    }

    public synchronized void finishInitServerSocket() throws IOException, RetryableChannelException {
        while (this.currentTry <= this.portOpenRetries + 1) {
            IOException bindError = null;
            if (this.serverSocket == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ServerSocket for this port has already been destroyed, return", (Object[])new Object[0]);
                }
                return;
            }
            if (this.channelConfigX.getReceiveBufferSize() >= 4 && this.channelConfigX.getReceiveBufferSize() <= 0x1000000) {
                this.serverSocket.setReceiveBufferSize(this.channelConfigX.getReceiveBufferSize());
            }
            if (!this.channelConfigX.getSoReuseAddress()) {
                try {
                    this.attemptSocketBind(this.socketAddressX, false);
                }
                catch (IOException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Forced re-use==false bind attempt failed, ioe=" + e), (Object[])new Object[0]);
                    }
                    bindError = e;
                }
            } else {
                try {
                    this.attemptSocketBind(this.socketAddressX, false);
                    if (!TCPFactoryConfiguration.isWindows()) {
                        this.serverSocket.setReuseAddress(true);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"ServerSocket reuse set to true to allow for later override", (Object[])new Object[0]);
                        }
                    }
                }
                catch (IOException ioe) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ServerSocket bind failed on first attempt with IOException: " + ioe.getMessage()), (Object[])new Object[0]);
                    }
                    bindError = ioe;
                    try {
                        InetSocketAddress testAddr;
                        String hostName = this.channelConfigX.getHostname();
                        if (hostName == null) {
                            hostName = "localhost";
                        }
                        if (!(testAddr = new InetSocketAddress(hostName, this.channelConfigX.getPort())).isUnresolved()) {
                            SocketChannel testChannel = SocketChannel.open(testAddr);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"attempt to connect to port to check listen status worked, someone else is using the port!", (Object[])new Object[0]);
                            }
                            testChannel.close();
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Test connection addr is unresolvable; " + testAddr), (Object[])new Object[0]);
                        }
                    }
                    catch (IOException testioe) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("attempt to connect to port to check listen status failed with IOException: " + testioe.getMessage()), (Object[])new Object[0]);
                        }
                        try {
                            this.attemptSocketBind(this.socketAddressX, true);
                            bindError = null;
                        }
                        catch (IOException newioe) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("ServerSocket bind failed on second attempt with IOException: " + newioe.getMessage()), (Object[])new Object[0]);
                            }
                            bindError = newioe;
                        }
                    }
                }
            }
            if (bindError == null) {
                this.listenPort = this.serverSocket.getLocalPort();
                String hostName = null;
                String IPvType = "IPv4";
                Tr.debug((TraceComponent)tc, (String)("serverSocket getInetAddress is: " + this.serverSocket.getInetAddress()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("serverSocket getLocalSocketAddress is: " + this.serverSocket.getLocalSocketAddress()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("serverSocket getInetAddress hostname is: " + this.serverSocket.getInetAddress().getHostName()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("serverSocket getInetAddress address is: " + this.serverSocket.getInetAddress().getHostAddress()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("channelConfig.getHostname() is: " + this.tcpChannel.getConfig().getHostname()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("channelConfig.getPort() is: " + this.tcpChannel.getConfig().getPort()), (Object[])new Object[0]);
                if (this.serverSocket.getInetAddress() instanceof Inet6Address) {
                    IPvType = "IPv6";
                }
                hostName = this.tcpChannel.config.getHostname() == null ? "*  (" + IPvType + ")" : this.serverSocket.getInetAddress().getHostName() + "  (" + IPvType + ": " + this.serverSocket.getInetAddress().getHostAddress() + ")";
                this.tcpChannel.setDisplayableHostName(hostName);
                this.outputBindMessage(this.channelConfigX.getChannelData().getExternalName(), hostName, this.listenPort);
                return;
            }
            if (this.currentTry > this.portOpenRetries) {
                String displayableHostName = this.channelConfigX.getDisplayableHostname();
                this.tcpChannel.setDisplayableHostName(displayableHostName);
                Tr.error((TraceComponent)tc, (String)"BIND_ERROR", (Object[])new Object[]{this.channelConfigX.getChannelData().getExternalName(), displayableHostName, String.valueOf(this.channelConfigX.getPort()), bindError.getMessage()});
                OnErrorUtil.OnError onError = TCPPort.ignoreWarnOrFail();
                if (onError.equals((Object)OnErrorUtil.OnError.FAIL)) {
                    this.quit();
                }
                throw new RetryableChannelException(bindError.getMessage());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("attempt " + this.currentTry + " of " + (this.portOpenRetries + 1) + " failed to open the port, will try again after wait interval"), (Object[])new Object[0]);
            }
            ++this.currentTry;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException x) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"sleep caught InterruptedException.  will proceed.", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final OnErrorUtil.OnError ignoreWarnOrFail() {
        String value = null;
        BundleContext bundleContext = priv.getBundleContext(FrameworkUtil.getBundle(VariableRegistry.class));
        ServiceReference ref = priv.getServiceReference(bundleContext, VariableRegistry.class);
        VariableRegistry variableRegistry = (VariableRegistry)priv.getService(bundleContext, ref);
        try {
            String key = "${onError}";
            value = variableRegistry.resolveString(key);
            if (!key.equals(value)) {
                OnErrorUtil.OnError onError = OnErrorUtil.OnError.valueOf((String)value.trim().toUpperCase());
                return onError;
            }
        }
        catch (Exception x) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("onError: " + value), (Object[])new Object[]{x});
            }
        }
        finally {
            bundleContext.ungetService(ref);
        }
        return OnErrorUtil.getDefaultOnError();
    }

    private void quit() {
        try {
            BundleContext bundleContext = this.getBundleContext();
            Bundle bundle = bundleContext.getBundle("System Bundle");
            if (bundle != null) {
                final CountDownLatch stopping = new CountDownLatch(1);
                SynchronousBundleListener l = new SynchronousBundleListener(){

                    public void bundleChanged(BundleEvent e) {
                        if (256 == e.getType() && e.getBundle().getBundleId() == 0L) {
                            stopping.countDown();
                        }
                    }
                };
                bundleContext.addBundleListener((BundleListener)l);
                bundle.stop();
                stopping.await(1000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BundleContext getBundleContext() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            return bundle.getBundleContext();
        }
        return null;
    }

    public void outputBindMessage(String channelName, String hostName, int port) {
        Tr.info((TraceComponent)tc, (String)"TCP_CHANNEL_STARTED", (Object[])new Object[]{channelName, hostName, String.valueOf(port)});
    }
}

