/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.http;

import com.ibm.wsspi.session.ISession;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingListener;

public abstract class AbstractHttpSession
implements HttpSession {
    protected ISession _iSession;
    protected ServletContext _servletContext;
    private static final String iseMessage = "The method is called on an invalidated session: ";

    protected AbstractHttpSession(ISession session) {
        this._iSession = session;
    }

    public long getCreationTime() {
        if (!this._iSession.isValid()) {
            throw new IllegalStateException(iseMessage + this._iSession.getId());
        }
        return this._iSession.getCreationTime();
    }

    public String getId() {
        return this._iSession.getId();
    }

    public long getLastAccessedTime() {
        if (!this._iSession.isValid()) {
            throw new IllegalStateException(iseMessage + this._iSession.getId());
        }
        return this._iSession.getLastAccessedTime();
    }

    public ServletContext setServletContext(ServletContext context) {
        this._servletContext = context;
        return this._servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this._iSession.setMaxInactiveInterval(maxInactiveInterval);
    }

    public int getMaxInactiveInterval() {
        return this._iSession.getMaxInactiveInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String attributeName) {
        ISession iSession = this._iSession;
        synchronized (iSession) {
            if (!this._iSession.isValid()) {
                throw new IllegalStateException(iseMessage + this._iSession.getId());
            }
            return this._iSession.getAttribute(attributeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        ISession iSession = this._iSession;
        synchronized (iSession) {
            if (!this._iSession.isValid()) {
                throw new IllegalStateException(iseMessage + this._iSession.getId());
            }
            return this._iSession.getAttributeNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String attributeName, Object value) {
        ISession iSession = this._iSession;
        synchronized (iSession) {
            if (!this._iSession.isValid()) {
                throw new IllegalStateException(iseMessage + this._iSession.getId());
            }
            if (null != value) {
                if (!(value instanceof HttpSessionBindingListener)) {
                    this._iSession.setAttribute(attributeName, value, Boolean.FALSE);
                } else {
                    this._iSession.setAttribute(attributeName, value, Boolean.TRUE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String attributeName) {
        ISession iSession = this._iSession;
        synchronized (iSession) {
            if (!this._iSession.isValid()) {
                throw new IllegalStateException(iseMessage + this._iSession.getId());
            }
            Object object = this._iSession.removeAttribute(attributeName);
        }
    }

    public void invalidate() {
        if (!this._iSession.isValid()) {
            throw new IllegalStateException(iseMessage + this._iSession.getId());
        }
        this._iSession.invalidate();
    }

    public boolean isNew() {
        if (!this._iSession.isValid()) {
            throw new IllegalStateException(iseMessage + this._iSession.getId());
        }
        return this._iSession.isNew();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("# AbstractHttpSession # \n { ").append("\n _iSession=").append(this._iSession).append("\n } \n");
        return sb.toString();
    }

    public ISession getISession() {
        return this._iSession;
    }
}

