/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.model;

import com.ibm.ws.repository.common.enums.DisplayPolicy;
import com.ibm.ws.repository.common.enums.DownloadPolicy;
import com.ibm.ws.repository.common.enums.InstallPolicy;
import com.ibm.ws.repository.common.enums.ResourceTypeLabel;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.transport.client.HasBreakingChanges;
import com.ibm.ws.repository.transport.client.VersionableContent;
import com.ibm.ws.repository.transport.exceptions.BadVersionException;
import com.ibm.ws.repository.transport.model.AbstractJSON;
import com.ibm.ws.repository.transport.model.AppliesToFilterInfo;
import com.ibm.ws.repository.transport.model.CopyUtils;
import com.ibm.ws.repository.transport.model.JavaSEVersionRequirements;
import com.ibm.ws.repository.transport.model.Link;
import com.ibm.ws.repository.transport.model.RequireFeatureWithTolerates;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;

public class WlpInformation
extends AbstractJSON
implements VersionableContent,
HasBreakingChanges {
    public static final float MIN_VERSION = 1.0f;
    public static final float MAX_VERSION = 3.0f;
    private ResourceTypeLabel typeLabel;
    private String productVersion;
    private String productInstallType;
    private String productId;
    private String productEdition;
    private Collection<String> provideFeature;
    private Collection<String> requireFeature;
    private Collection<String> provideFix;
    private Collection<String> requireFix;
    private String appliesTo;
    private Collection<AppliesToFilterInfo> appliesToFilterInfo;
    private Visibility visibility;
    private String shortName;
    private String lowerCaseShortName;
    private Date date;
    private String scriptLanguage;
    private String provisionCapability;
    private InstallPolicy installPolicy;
    private DownloadPolicy downloadPolicy;
    private DisplayPolicy displayPolicy;
    private DisplayPolicy webDisplayPolicy;
    private String wlpInformationVersion;
    private long mainAttachmentSize;
    private Collection<Link> links;
    private String vanityRelativeURL;
    private String featuredWeight;
    private Collection<String> supersededBy;
    private Collection<String> platforms;
    private Collection<String> supersededByOptional;
    private JavaSEVersionRequirements javaSEVersionRequirements;
    private String mainAttachmentSHA256;
    private String genericRequirements;
    private String packagedJava;
    private Collection<RequireFeatureWithTolerates> requireFeatureWithTolerates;
    private String mavenCoordinates;
    private String singleton;
    private String ibmInstallTo;

    public WlpInformation() {
    }

    public WlpInformation(WlpInformation other) {
        this.typeLabel = other.typeLabel;
        this.productVersion = other.productVersion;
        this.productInstallType = other.productInstallType;
        this.productId = other.productId;
        this.productEdition = other.productEdition;
        this.provideFeature = CopyUtils.copyCollection(other.provideFeature);
        this.requireFeature = CopyUtils.copyCollection(other.requireFeature);
        this.provideFix = CopyUtils.copyCollection(other.provideFix);
        this.requireFix = CopyUtils.copyCollection(other.requireFix);
        this.appliesTo = other.appliesTo;
        this.appliesToFilterInfo = CopyUtils.copyCollection(other.appliesToFilterInfo, AppliesToFilterInfo::new);
        this.visibility = other.visibility;
        this.shortName = other.shortName;
        this.lowerCaseShortName = other.lowerCaseShortName;
        this.date = CopyUtils.copyDate(other.date);
        this.scriptLanguage = other.scriptLanguage;
        this.provisionCapability = other.provisionCapability;
        this.installPolicy = other.installPolicy;
        this.downloadPolicy = other.downloadPolicy;
        this.displayPolicy = other.displayPolicy;
        this.webDisplayPolicy = other.webDisplayPolicy;
        this.wlpInformationVersion = other.wlpInformationVersion;
        this.mainAttachmentSize = other.mainAttachmentSize;
        this.links = CopyUtils.copyCollection(other.links, Link::new);
        this.vanityRelativeURL = other.vanityRelativeURL;
        this.featuredWeight = other.featuredWeight;
        this.supersededBy = CopyUtils.copyCollection(other.supersededBy);
        this.platforms = CopyUtils.copyCollection(other.platforms);
        this.supersededByOptional = CopyUtils.copyCollection(other.supersededByOptional);
        this.javaSEVersionRequirements = CopyUtils.copyObject(other.javaSEVersionRequirements, JavaSEVersionRequirements::new);
        this.mainAttachmentSHA256 = other.mainAttachmentSHA256;
        this.genericRequirements = other.genericRequirements;
        this.packagedJava = other.packagedJava;
        this.requireFeatureWithTolerates = CopyUtils.copyCollection(other.requireFeatureWithTolerates, RequireFeatureWithTolerates::new);
        this.mavenCoordinates = other.mavenCoordinates;
        this.singleton = other.singleton;
        this.ibmInstallTo = other.ibmInstallTo;
    }

    public String getFeaturedWeight() {
        return this.featuredWeight;
    }

    public void setFeaturedWeight(String featuredWeight) {
        this.featuredWeight = featuredWeight;
    }

    public Collection<Link> getLinks() {
        return this.links;
    }

    public void setLinks(Collection<Link> links) {
        this.links = links;
    }

    public Collection<String> getRequireFeature() {
        return this.requireFeature;
    }

    public void setRequireFeature(Collection<String> requireFeature) {
        this.requireFeature = requireFeature;
    }

    public void addRequireFeature(String requireFeature) {
        if (this.requireFeature == null) {
            this.requireFeature = new HashSet<String>();
        }
        this.requireFeature.add(requireFeature);
    }

    public Collection<RequireFeatureWithTolerates> getRequireFeatureWithTolerates() {
        return this.requireFeatureWithTolerates;
    }

    public void setRequireFeatureWithTolerates(Collection<RequireFeatureWithTolerates> requiredFeaturesWithTolerates) {
        this.requireFeatureWithTolerates = requiredFeaturesWithTolerates;
    }

    public void addRequireFeatureWithTolerates(RequireFeatureWithTolerates feature) {
        if (this.requireFeatureWithTolerates == null) {
            this.requireFeatureWithTolerates = new HashSet<RequireFeatureWithTolerates>();
        }
        this.requireFeatureWithTolerates.add(feature);
    }

    public ResourceTypeLabel getTypeLabel() {
        return this.typeLabel;
    }

    public void setTypeLabel(ResourceTypeLabel typeLabel) {
        this.typeLabel = typeLabel;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProductInstallType() {
        return this.productInstallType;
    }

    public void setProductInstallType(String productInstallType) {
        this.productInstallType = productInstallType;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductEdition() {
        return this.productEdition;
    }

    public void setProductEdition(String productEdition) {
        this.productEdition = productEdition;
    }

    public Collection<String> getProvideFeature() {
        return this.provideFeature;
    }

    public void setProvideFeature(Collection<String> provideFeature) {
        this.provideFeature = provideFeature;
    }

    public void addProvideFeature(String provideFeature) {
        if (this.provideFeature == null) {
            this.provideFeature = new HashSet<String>();
        }
        this.provideFeature.add(provideFeature);
    }

    public Collection<String> getProvideFix() {
        return this.provideFix;
    }

    public void setProvideFix(Collection<String> provideFix) {
        this.provideFix = provideFix;
    }

    public void addProvideFix(String provideFix) {
        if (this.provideFix == null) {
            this.provideFix = new HashSet<String>();
        }
        this.provideFix.add(provideFix);
    }

    public Collection<String> getRequireFix() {
        return this.requireFix;
    }

    public void setRequireFix(Collection<String> requireFix) {
        this.requireFix = requireFix;
    }

    public void addRequireFix(String requireFix) {
        if (this.requireFix == null) {
            this.requireFix = new HashSet<String>();
        }
        this.requireFix.add(requireFix);
    }

    public String getVanityRelativeURL() {
        return this.vanityRelativeURL;
    }

    public void setVanityRelativeURL(String vanityRelativeURL) {
        this.vanityRelativeURL = vanityRelativeURL;
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(String appliesTo) {
        this.appliesTo = appliesTo;
    }

    public Collection<AppliesToFilterInfo> getAppliesToFilterInfo() {
        return this.appliesToFilterInfo;
    }

    public void setAppliesToFilterInfo(Collection<AppliesToFilterInfo> appliesToFilterInfo) {
        this.appliesToFilterInfo = appliesToFilterInfo;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
        String lowerCaseShortName = shortName == null ? null : shortName.toLowerCase();
        this.setLowerCaseShortName(lowerCaseShortName);
    }

    public String getLowerCaseShortName() {
        return this.lowerCaseShortName;
    }

    private void setLowerCaseShortName(String lowerCaseShortName) {
        this.lowerCaseShortName = lowerCaseShortName;
    }

    public Date getDate() {
        if (this.date == null) {
            return null;
        }
        return new Date(this.date.getTime());
    }

    public void setDate(Date date) {
        this.date = date == null ? null : new Date(date.getTime());
    }

    public void setScriptLanguage(String scriptLang) {
        this.scriptLanguage = scriptLang;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setDownloadPolicy(DownloadPolicy downloadPolicy) {
        this.downloadPolicy = downloadPolicy;
    }

    public DownloadPolicy getDownloadPolicy() {
        return this.downloadPolicy;
    }

    public String getProvisionCapability() {
        return this.provisionCapability;
    }

    public void setProvisionCapability(String ibmProvisionCapability) {
        this.provisionCapability = ibmProvisionCapability;
    }

    public InstallPolicy getInstallPolicy() {
        return this.installPolicy;
    }

    public void setDisplayPolicy(DisplayPolicy displayPolicy) {
        this.displayPolicy = displayPolicy;
    }

    public DisplayPolicy getDisplayPolicy() {
        return this.displayPolicy;
    }

    public void setWebDisplayPolicy(DisplayPolicy webDisplayPolicy) {
        this.webDisplayPolicy = webDisplayPolicy;
    }

    public DisplayPolicy getWebDisplayPolicy() {
        return this.webDisplayPolicy;
    }

    public void setInstallPolicy(InstallPolicy installPolicy) {
        this.installPolicy = installPolicy;
    }

    public String getWlpInformationVersion() {
        return this.wlpInformationVersion;
    }

    public void setWlpInformationVersion(String WlpInformationVersion) {
        this.wlpInformationVersion = WlpInformationVersion;
    }

    public long getMainAttachmentSize() {
        return this.mainAttachmentSize;
    }

    public void setMainAttachmentSize(long mainAttachmentSize) {
        this.mainAttachmentSize = mainAttachmentSize;
    }

    public String getMainAttachmentSHA256() {
        return this.mainAttachmentSHA256;
    }

    public void setMainAttachmentSHA256(String pMainAttachmentSHA256) {
        this.mainAttachmentSHA256 = pMainAttachmentSHA256;
    }

    public void addSupersededBy(String supersededByFeature) {
        if (this.supersededBy == null) {
            this.supersededBy = new HashSet<String>();
        }
        this.supersededBy.add(supersededByFeature);
    }

    public void addSupersededByOptional(String supersededByFeature) {
        if (this.supersededByOptional == null) {
            this.supersededByOptional = new HashSet<String>();
        }
        this.supersededByOptional.add(supersededByFeature);
    }

    public Collection<String> getSupersededBy() {
        return this.supersededBy;
    }

    public void setSupersededBy(Collection<String> supersededBy) {
        this.supersededBy = supersededBy;
    }

    public Collection<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(Collection<String> myPlatforms) {
        this.platforms = myPlatforms;
    }

    public Collection<String> getSupersededByOptional() {
        return this.supersededByOptional;
    }

    public void setSupersededByOptional(Collection<String> supersededByOptional) {
        this.supersededByOptional = supersededByOptional;
    }

    public JavaSEVersionRequirements getJavaSEVersionRequirements() {
        return this.javaSEVersionRequirements;
    }

    public void setJavaSEVersionRequirements(JavaSEVersionRequirements javaSEVersionRequirements) {
        this.javaSEVersionRequirements = javaSEVersionRequirements;
    }

    public String getGenericRequirements() {
        return this.genericRequirements;
    }

    public void setGenericRequirements(String genericRequirements) {
        this.genericRequirements = genericRequirements;
    }

    public String getPackagedJava() {
        return this.packagedJava;
    }

    public void setPackagedJava(String packagedJava) {
        this.packagedJava = packagedJava;
    }

    public String getMavenCoordinates() {
        return this.mavenCoordinates;
    }

    public void setMavenCoordinates(String mavenCoordinates) {
        this.mavenCoordinates = mavenCoordinates;
    }

    public String getSingleton() {
        return this.singleton;
    }

    public void setSingleton(String singleton) {
        this.singleton = singleton;
    }

    public String getIbmInstallTo() {
        return this.ibmInstallTo;
    }

    public void setIbmInstallTo(String ibmInstallTo) {
        this.ibmInstallTo = ibmInstallTo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.provideFeature == null ? 0 : this.provideFeature.hashCode());
        result = 31 * result + (this.provideFix == null ? 0 : this.provideFix.hashCode());
        result = 31 * result + (this.productId == null ? 0 : this.productId.hashCode());
        result = 31 * result + (this.supersededBy == null ? 0 : this.supersededBy.hashCode());
        result = 31 * result + (this.supersededByOptional == null ? 0 : this.supersededByOptional.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!this.equivalent(obj)) {
            return false;
        }
        WlpInformation other = (WlpInformation)obj;
        return !(this.appliesToFilterInfo == null ? other.appliesToFilterInfo != null : !this.appliesToFilterInfo.equals(other.appliesToFilterInfo));
    }

    boolean equivalent(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WlpInformation other = (WlpInformation)obj;
        if (this.appliesTo == null ? other.appliesTo != null : !this.appliesTo.equals(other.appliesTo)) {
            return false;
        }
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
            return false;
        }
        if (this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName)) {
            return false;
        }
        if (this.lowerCaseShortName == null ? other.lowerCaseShortName != null : !this.lowerCaseShortName.equals(other.lowerCaseShortName)) {
            return false;
        }
        if (this.productEdition == null ? other.productEdition != null : !this.productEdition.equals(other.productEdition)) {
            return false;
        }
        if (this.productId == null ? other.productId != null : !this.productId.equals(other.productId)) {
            return false;
        }
        if (this.productInstallType == null ? other.productInstallType != null : !this.productInstallType.equals(other.productInstallType)) {
            return false;
        }
        if (this.productVersion == null ? other.productVersion != null : !this.productVersion.equals(other.productVersion)) {
            return false;
        }
        if (this.provideFeature == null) {
            if (other.provideFeature != null) {
                return false;
            }
        } else if (other.provideFeature != null) {
            if (other.provideFeature.size() != this.provideFeature.size()) {
                return false;
            }
            for (String s : other.provideFeature) {
                if (this.provideFeature.contains(s)) continue;
                return false;
            }
        } else {
            return false;
        }
        if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
            return false;
        }
        if (this.provideFix == null ? other.provideFix != null : !this.provideFix.equals(other.provideFix)) {
            return false;
        }
        if (this.requireFeature == null) {
            if (other.requireFeature != null) {
                return false;
            }
        } else if (other.requireFeature != null) {
            if (other.requireFeature.size() != this.requireFeature.size()) {
                return false;
            }
            for (String s : other.requireFeature) {
                if (this.requireFeature.contains(s)) continue;
                return false;
            }
        } else {
            return false;
        }
        if (this.requireFix == null) {
            if (other.requireFix != null) {
                return false;
            }
        } else if (other.requireFix != null) {
            if (other.requireFix.size() != this.requireFix.size()) {
                return false;
            }
            for (String s : other.requireFix) {
                if (this.requireFix.contains(s)) continue;
                return false;
            }
        } else {
            return false;
        }
        if (this.typeLabel == null ? other.typeLabel != null : !this.typeLabel.equals((Object)other.typeLabel)) {
            return false;
        }
        if (this.visibility == null ? other.visibility != null : !this.visibility.equals((Object)other.visibility)) {
            return false;
        }
        if (this.scriptLanguage == null ? other.scriptLanguage != null : !this.scriptLanguage.equals(other.scriptLanguage)) {
            return false;
        }
        if (this.downloadPolicy == null ? other.downloadPolicy != null : !this.downloadPolicy.equals((Object)other.downloadPolicy)) {
            return false;
        }
        if (this.provisionCapability == null ? other.provisionCapability != null : !this.provisionCapability.equals(other.provisionCapability)) {
            return false;
        }
        if (this.installPolicy == null ? other.installPolicy != null : !this.installPolicy.equals((Object)other.installPolicy)) {
            return false;
        }
        if (this.displayPolicy == null ? other.displayPolicy != null : !this.displayPolicy.equals((Object)other.displayPolicy)) {
            return false;
        }
        if (this.webDisplayPolicy == null ? other.webDisplayPolicy != null : !this.webDisplayPolicy.equals((Object)other.webDisplayPolicy)) {
            return false;
        }
        if (this.vanityRelativeURL == null ? other.vanityRelativeURL != null : !this.vanityRelativeURL.equals(other.vanityRelativeURL)) {
            return false;
        }
        if (this.featuredWeight == null ? other.featuredWeight != null : !this.featuredWeight.equals(other.featuredWeight)) {
            return false;
        }
        if (this.wlpInformationVersion == null ? other.wlpInformationVersion != null : !this.wlpInformationVersion.equals(other.wlpInformationVersion)) {
            return false;
        }
        if (this.mainAttachmentSize != other.mainAttachmentSize) {
            return false;
        }
        if (this.supersededBy == null ? other.supersededBy != null : !this.supersededBy.equals(other.supersededBy)) {
            return false;
        }
        if (this.supersededByOptional == null ? other.supersededByOptional != null : !this.supersededByOptional.equals(other.supersededByOptional)) {
            return false;
        }
        if (this.javaSEVersionRequirements == null ? other.javaSEVersionRequirements != null : !this.javaSEVersionRequirements.equals(other.javaSEVersionRequirements)) {
            return false;
        }
        if (this.mainAttachmentSHA256 == null ? other.mainAttachmentSHA256 != null : !this.mainAttachmentSHA256.equals(other.mainAttachmentSHA256)) {
            return false;
        }
        if (this.genericRequirements == null ? other.genericRequirements != null : !this.genericRequirements.equals(other.genericRequirements)) {
            return false;
        }
        if (this.packagedJava == null ? other.packagedJava != null : !this.packagedJava.equals(other.packagedJava)) {
            return false;
        }
        if (this.requireFeatureWithTolerates == null ? other.requireFeatureWithTolerates != null : !this.requireFeatureWithTolerates.equals(other.requireFeatureWithTolerates)) {
            return false;
        }
        if (this.mavenCoordinates == null ? other.mavenCoordinates != null : !this.mavenCoordinates.equals(other.mavenCoordinates)) {
            return false;
        }
        if (this.singleton == null ? other.singleton != null : !this.singleton.equals(other.singleton)) {
            return false;
        }
        if (this.ibmInstallTo == null ? other.ibmInstallTo != null : !this.ibmInstallTo.equals(other.ibmInstallTo)) {
            return false;
        }
        return !(this.platforms == null ? other.platforms != null : !this.platforms.equals(other.platforms));
    }

    @Override
    public void validate(String version) throws IllegalStateException, BadVersionException {
        float v = Float.valueOf(version).floatValue();
        if (v < 1.0f || v >= 3.0f) {
            throw new BadVersionException(Float.toString(1.0f), Float.toString(3.0f), version);
        }
    }

    @Override
    public String nameOfVersionAttribute() {
        return "wlpInformationVersion";
    }

    @Override
    public Collection<String> attributesThatCauseBreakingChanges() {
        if (Visibility.INSTALL.equals((Object)this.visibility)) {
            return Collections.singleton("visibility");
        }
        return Collections.emptySet();
    }
}

