/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.Traceable;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.internal.util.ElementNotReadyException;
import com.ibm.ws.classloading.internal.util.ElementNotValidException;
import com.ibm.ws.classloading.internal.util.EventReadWriteLock;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BlockingList<K, E>
extends AbstractList<E>
implements List<E>,
Traceable {
    static final TraceComponent tc = Tr.register(BlockingList.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private final EventReadWriteLock stateLock;
    private final Object[] elements;
    private final Map<K, Integer> actualIndices = new LinkedHashMap<K, Integer>();
    private final int[] effectiveIndex;
    private final Object[] keys;
    private Collection<K> failedKeys;
    private final Retriever<? super K, ? extends E> retriever;
    private final Listener<? super K, ? extends E> listener;
    private final Logger logger;
    private volatile State state;
    static final long serialVersionUID = -3046511344920130299L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockingList(Collection<? extends K> keys, Retriever<? super K, ? extends E> retriever, Listener<? super K, ? extends E> listener, Logger logger, long nanoTimeout) {
        assert (retriever != null);
        assert (listener != null);
        assert (logger != null);
        this.retriever = retriever;
        this.listener = listener;
        this.logger = logger;
        this.stateLock = new EventReadWriteLock(nanoTimeout);
        this.stateLock.writeLock().lock();
        try {
            if (keys == null) {
                keys = Collections.emptyList();
            }
            this.elements = new Object[keys.size()];
            Arrays.fill(this.elements, (Object)PlaceHolder.UNAVAILABLE);
            this.state = keys.isEmpty() ? State.COMPLETE : State.BLOCKING;
            this.effectiveIndex = new int[keys.size()];
            Arrays.fill(this.effectiveIndex, Integer.MAX_VALUE);
            int i = 0;
            for (K k : keys) {
                if (this.actualIndices.containsKey(k)) continue;
                this.actualIndices.put(k, i++);
            }
            this.keys = keys.toArray();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    private void recordIndex(int index) {
        this.stateLock.writeLock().lock();
        try {
            int insertionPoint = -Arrays.binarySearch(this.effectiveIndex, index) - 1;
            System.arraycopy(this.effectiveIndex, insertionPoint, this.effectiveIndex, insertionPoint + 1, this.effectiveIndex.length - insertionPoint - 1);
            this.effectiveIndex[insertionPoint] = index;
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    @Override
    public E get(int index) {
        this.stateLock.readLock().lock();
        try {
            switch (this.state) {
                case BLOCKING: {
                    if (this.waitForIndex(index)) {
                        Object object = this.elements[index];
                        return (E)object;
                    }
                }
                case TIMED_OUT: 
                case COMPLETE_WITH_FAILURES: {
                    Object object = this.elements[this.effectiveIndex[index]];
                    return (E)object;
                }
                case COMPLETE: {
                    Object object = this.elements[index];
                    return (E)object;
                }
            }
            throw new IllegalStateException();
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToFetchElement(int index) {
        int readLocks = this.stateLock.releaseReadLocksAndAcquireWriteLock();
        try {
            boolean bl = PlaceHolder.couldStillTurnUp(this.elements[index]) ? this.reallyTryToFetchElement(index) : true;
            return bl;
        }
        finally {
            this.stateLock.downgradeWriteLockToReadLocks(readLocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={ElementNotReadyException.class, ElementNotValidException.class})
    private boolean reallyTryToFetchElement(int index) {
        boolean result;
        block19: {
            String methodName = "reallyTryToFetchElement(): ";
            Object k = this.keys[index];
            try {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"reallyTryToFetchElement(): retriever fetching", (Object[])new Object[0]);
                    }
                    this.put(k, this.retriever.fetch(k));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"reallyTryToFetchElement(): retriever fetched", (Object[])new Object[0]);
                    }
                    result = true;
                }
                catch (ElementNotReadyException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"reallyTryToFetchElement(): retriever threw NotReadyException", (Object[])new Object[0]);
                    }
                    if (this.elements[index] == PlaceHolder.UNAVAILABLE) {
                        this.elements[index] = PlaceHolder.PENDING;
                        int writeLocks = this.stateLock.releaseWriteLocks();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"reallyTryToFetchElement(): AFTER releaseWriteLocks", (Object[])new Object[0]);
                        }
                        try {
                            this.listener.listenFor(k, new SlotImpl(k));
                        }
                        finally {
                            this.stateLock.acquireWriteLocks(writeLocks);
                        }
                        if (PlaceHolder.couldStillTurnUp(this.elements[index])) {
                            try {
                                this.putIfAbsent(k, this.retriever.fetch(k));
                                result = true;
                            }
                            catch (ElementNotReadyException ignored) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"reallyTryToFetchElement(): Caught NotReadyException while putting a retriever", (Object[])new Object[0]);
                                }
                            }
                        }
                        break block19;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("reallyTryToFetchElement(): Not creating listener: since elements[" + index + "] != UNAVAILABLE"), (Object[])new Object[0]);
                    }
                }
            }
            catch (ElementNotValidException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("reallyTryToFetchElement(): retriever reported element as invalid for key " + k), (Object[])new Object[]{e});
                }
                this.fail(k);
            }
        }
        result = !PlaceHolder.couldStillTurnUp(this.elements[index]);
        return result;
    }

    @FFDCIgnore(value={InterruptedException.class})
    private boolean waitForIndex(int index) {
        String methodName = "waitForIndex(): ";
        while (!this.tryToFetchElement(index)) {
            try {
                if (this.stateLock.hasTimedOut()) {
                    this.markTimedOut();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"waitForIndex(): TIMED OUT!", (Object[])new Object[0]);
                    }
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"waitForIndex(): waiting ...", (Object[])new Object[0]);
                }
                boolean result = this.stateLock.waitForEvent();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("waitForIndex(): waitForEvent result is [" + result + "] will Loop again to check timeout"), (Object[])new Object[0]);
            }
            catch (InterruptedException ignored) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"waitForIndex(): interrupted", (Object[])new Object[0]);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={ElementNotReadyException.class, ElementNotValidException.class})
    private void markTimedOut() {
        String methodName = "markTimedOut(): ";
        int lockCount = this.stateLock.releaseReadLocksAndAcquireWriteLock();
        try {
            this.state = State.TIMED_OUT;
            if (this.retriever != null) {
                for (K k : this.getUnmatchedKeys()) {
                    try {
                        E e = this.retriever.fetch(k);
                        this.put(k, e);
                    }
                    catch (ElementNotReadyException ignored) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("markTimedOut(): retriever failed to retrieve element at timeout for key " + k), (Object[])new Object[0]);
                    }
                    catch (ElementNotValidException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("markTimedOut(): retriever reported element as invalid for key " + k), (Object[])new Object[0]);
                        }
                        this.fail(k);
                    }
                }
            }
            if (this.logger != null) {
                this.logger.logTimeoutEvent(this);
            }
        }
        finally {
            this.stateLock.downgradeWriteLockToReadLocks(lockCount);
        }
    }

    @FFDCIgnore(value={IndexOutOfBoundsException.class})
    private void preFetchAll() {
        int i;
        for (i = 0; i < this.elements.length; ++i) {
            this.tryToFetchElement(i);
        }
        try {
            for (i = 0; i < this.elements.length; ++i) {
                this.get(i);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, E element) {
        String methodName = "put(): ";
        this.stateLock.writeLock().lock();
        try {
            Integer index = this.actualIndices.remove(key);
            if (index == null) {
                throw new IllegalArgumentException("unknown key: " + key);
            }
            this.elements[index.intValue()] = element;
            this.recordIndex(index);
            this.checkForCompletion();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("put(): element found for key: " + key), (Object[])new Object[0]);
            }
            this.stateLock.postEvent();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(K key) {
        String methodName = "fail(): ";
        this.stateLock.writeLock().lock();
        try {
            Collection<K> collection;
            Integer index = this.actualIndices.remove(key);
            if (index == null) {
                throw new IllegalArgumentException("unknown key: " + key);
            }
            this.elements[index.intValue()] = PlaceHolder.FAILED;
            if (this.failedKeys == null) {
                this.failedKeys = new ArrayList<K>(this.actualIndices.size() + 1);
                collection = this.failedKeys;
            } else {
                collection = this.failedKeys;
            }
            collection.add(key);
            this.checkForCompletion();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"fail(): ", (Object[])new Object[]{"permanent fail for key " + key});
            }
            this.stateLock.postEvent();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    private void checkForCompletion() {
        String methodName = "checkForCompletion(): ";
        if (this.actualIndices.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkForCompletion(): setting state=COMPLETE", (Object[])new Object[0]);
            }
            this.state = this.failedKeys == null ? State.COMPLETE : State.COMPLETE_WITH_FAILURES;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public boolean putIfAbsent(K key, E element) {
        try {
            this.put(key, element);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public int size() {
        this.stateLock.readLock().lock();
        try {
            switch (this.state) {
                default: {
                    this.preFetchAll();
                    int n = this.size();
                    return n;
                }
                case TIMED_OUT: {
                    int n = this.currentSize();
                    return n;
                }
                case COMPLETE_WITH_FAILURES: {
                    int n = this.elements.length - this.failedKeys.size();
                    return n;
                }
                case COMPLETE: 
            }
            int n = this.elements.length;
            return n;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    private int currentSize() {
        this.stateLock.readLock().lock();
        try {
            int n = this.failedKeys == null ? this.elements.length - this.actualIndices.size() : this.elements.length - this.actualIndices.size() - this.failedKeys.size();
            return n;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    public List<E> getCondensedList() {
        return new AbstractList<E>(){
            static final long serialVersionUID = -2163202111130846304L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public E get(int arg0) {
                BlockingList.this.stateLock.readLock().lock();
                try {
                    Object object = BlockingList.this.elements[BlockingList.this.effectiveIndex[arg0]];
                    return object;
                }
                finally {
                    BlockingList.this.stateLock.readLock().unlock();
                }
            }

            @Override
            public int size() {
                return BlockingList.this.currentSize();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.util.BlockingList$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        };
    }

    @FFDCIgnore(value={IndexOutOfBoundsException.class})
    private boolean ensureElement(int index) {
        try {
            this.get(index);
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        return new ListIterator<E>(){
            ListIterator<E> internal;
            static final long serialVersionUID = -534088800626524352L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                this.internal = BlockingList.super.listIterator(index);
            }

            @Override
            public void add(E e) {
                this.internal.add(e);
            }

            @Override
            public boolean hasNext() {
                return this.internal.hasNext() && BlockingList.this.ensureElement(this.nextIndex());
            }

            @Override
            public boolean hasPrevious() {
                return this.internal.hasPrevious() && BlockingList.this.ensureElement(this.previousIndex());
            }

            @Override
            public E next() {
                return this.internal.next();
            }

            @Override
            public int nextIndex() {
                return this.internal.nextIndex();
            }

            @Override
            public E previous() {
                return this.internal.previous();
            }

            @Override
            public int previousIndex() {
                return this.internal.previousIndex();
            }

            @Override
            public void remove() {
                this.internal.remove();
            }

            @Override
            public void set(E e) {
                this.internal.set(e);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.util.BlockingList$2", 2.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        };
    }

    public boolean isTimedOut() {
        return this.state == State.TIMED_OUT;
    }

    @Override
    public String toString() {
        this.stateLock.readLock().lock();
        try {
            String elems = Arrays.toString(this.elements);
            String string = this.actualIndices.isEmpty() ? (this.failedKeys == null ? elems : "elements:" + elems + " failed keys: " + this.failedKeys) : (this.failedKeys == null ? "elements:" + elems + " awaited keys:" + this.actualIndices.keySet() : "elements:" + elems + " awaited keys:" + this.actualIndices.keySet() + " failed keys: " + this.failedKeys);
            return string;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    public String toTraceString() {
        return this.toString();
    }

    public Set<K> getUnmatchedKeys() {
        this.stateLock.readLock().lock();
        try {
            HashSet<K> hashSet = new HashSet<K>(this.actualIndices.keySet());
            return hashSet;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    public static interface Retriever<K, E> {
        public E fetch(K var1) throws ElementNotReadyException, ElementNotValidException;
    }

    public static interface Listener<K, E> {
        public void listenFor(K var1, Slot<? super E> var2);
    }

    public static interface Logger {
        public void logTimeoutEvent(BlockingList<?, ?> var1);
    }

    @Trivial
    static enum PlaceHolder {
        UNAVAILABLE,
        PENDING,
        FAILED;


        static boolean couldStillTurnUp(Object o) {
            return o == UNAVAILABLE || o == PENDING;
        }
    }

    @Trivial
    static enum State {
        BLOCKING,
        TIMED_OUT,
        COMPLETE_WITH_FAILURES,
        COMPLETE;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class SlotImpl
    implements Slot<E> {
        private final K k;
        static final long serialVersionUID = 7059597655998090523L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SlotImpl(K k) {
            this.k = k;
        }

        @Override
        public void fill(E e) {
            BlockingList.this.putIfAbsent(this.k, e);
        }

        @Override
        public void delete() {
            BlockingList.this.fail(this.k);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.util.BlockingList$SlotImpl", SlotImpl.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    public static interface Slot<E> {
        public void fill(E var1);

        public void delete();
    }
}

