/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.FacesWrapper;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.ViewExpiredException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.view.facelets.LocationAware;
import org.apache.myfaces.view.facelets.el.ContextAware;

public class ExceptionHandlerUtils {
    protected static boolean isLogStacktrace(FacesContext context, Throwable exception) {
        return !context.isProjectStage(ProjectStage.Production) || !(exception instanceof ViewExpiredException);
    }

    protected static boolean isLogException(FacesContext context, Throwable exception) {
        if (context.isProjectStage(ProjectStage.Production) && exception != null) {
            MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance((FacesContext)context);
            for (String ignore : myfacesConfig.getExceptionTypesToIgnoreInLogging()) {
                if (!ignore.trim().equals(exception.getClass().getName())) continue;
                return false;
            }
        }
        return true;
    }

    public static void logException(Throwable exception, UIComponent component, FacesContext context, Logger logger) {
        if (exception == null) {
            return;
        }
        while (exception instanceof FacesWrapper) {
            exception = (Throwable)((FacesWrapper)exception).getWrapped();
        }
        while ((exception.getClass().equals(FacesException.class) || exception.getClass().equals(ELException.class)) && exception.getCause() != null) {
            exception = exception.getCause();
        }
        if (!ExceptionHandlerUtils.isLogException(context, exception)) {
            return;
        }
        String msg = exception.getClass().getName() + " occurred while processing " + context.getCurrentPhaseId().getName();
        String location = ExceptionHandlerUtils.buildLocation(exception, component);
        if (location != null) {
            msg = msg + " [Location=" + location + "]";
        }
        if (ExceptionHandlerUtils.isLogStacktrace(context, exception)) {
            logger.log(Level.SEVERE, msg, exception);
        } else {
            logger.log(Level.SEVERE, msg);
        }
    }

    public static String buildLocation(Throwable ex, UIComponent component) {
        LocationAware laex;
        ContextAware caex;
        Object location = "";
        if (ex instanceof ContextAware) {
            caex = (ContextAware)((Object)ex);
            location = caex.getLocation().toString() + ", " + caex.getQName() + "=\"" + caex.getExpressionString() + "\"";
        } else if (ex instanceof LocationAware && (laex = (LocationAware)((Object)ex)).getLocation() != null) {
            location = laex.getLocation().toString();
        }
        while (ex.getCause() != null) {
            if ((ex = ex.getCause()) instanceof ContextAware) {
                caex = (ContextAware)((Object)ex);
                location = caex.getLocation().toString() + ", " + caex.getQName() + "=\"" + caex.getExpressionString() + "\"";
                continue;
            }
            if (!(ex instanceof LocationAware) || (laex = (LocationAware)((Object)ex)).getLocation() == null) continue;
            location = laex.getLocation().toString();
        }
        if (component != null) {
            if (!((String)location).isBlank()) {
                location = (String)location + ", ";
            }
            location = (String)location + "clientId=\"" + component.getClientId() + "\"";
        }
        return location;
    }
}

