/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.util.ParsedScheduleExpression;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParser;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParserException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ejb.TimerMethodData;
import jakarta.ejb.ScheduleExpression;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class AutomaticTimerBean {
    private static final String CLASS_NAME = AutomaticTimerBean.class.getName();
    private static final TraceComponent tc = Tr.register(AutomaticTimerBean.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final BeanMetaData ivBMD;
    private final List<TimerMethodData> ivMethods;
    private final int ivNumPersistent;
    private final int ivNumNonPersistent;
    private BeanId ivBeanId;

    AutomaticTimerBean(BeanMetaData bmd, List<TimerMethodData> methods) {
        this.ivBMD = bmd;
        this.ivMethods = methods;
        int numPersistent = 0;
        int numNonPersistent = 0;
        for (TimerMethodData timerMethod : methods) {
            for (TimerMethodData.AutomaticTimer timer : timerMethod.getAutomaticTimers()) {
                if (timer.isPersistent()) {
                    ++numPersistent;
                    continue;
                }
                ++numNonPersistent;
            }
        }
        this.ivNumPersistent = numPersistent;
        this.ivNumNonPersistent = numNonPersistent;
    }

    public BeanMetaData getBeanMetaData() {
        return this.ivBMD;
    }

    public List<TimerMethodData> getMethods() {
        return this.ivMethods;
    }

    public int getNumPersistentTimers() {
        return this.ivNumPersistent;
    }

    public int getNumNonPersistentTimers() {
        return this.ivNumNonPersistent;
    }

    public BeanId getBeanId() {
        if (this.ivBeanId == null) {
            this.ivBeanId = new BeanId(this.ivBMD.j2eeName, null, false);
        }
        return this.ivBeanId;
    }

    public ParsedScheduleExpression parseScheduleExpression(TimerMethodData.AutomaticTimer timer) {
        ScheduleExpression schedule = timer.getSchedule();
        String start = timer.getStart();
        String end = timer.getEnd();
        try {
            if (start != null) {
                schedule.start(this.parseXSDDateTime("start", start));
            }
            if (end != null) {
                schedule.end(this.parseXSDDateTime("end", end));
            }
            return ScheduleExpressionParser.parse(schedule);
        }
        catch (ScheduleExpressionParserException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".parseScheduleExpression"), (String)"541", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed to parse schedule expression", (Object[])new Object[]{ex});
            }
            ex.logError(this.ivBMD.j2eeName.getModule(), this.ivBMD.j2eeName.getComponent(), timer.getMethod().getMethod().getName());
            throw ex;
        }
    }

    private Date parseXSDDateTime(String fieldName, String dateTime) {
        try {
            return new Date(AutomaticTimerBean.parse(dateTime));
        }
        catch (IllegalArgumentException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".parseXSDDateTime"), (String)"566", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed to parse schedule date/time", (Object[])new Object[]{ex});
            }
            throw new ScheduleExpressionParserException(ScheduleExpressionParserException.Error.VALUE, fieldName, dateTime);
        }
    }

    static long parse(String dateTime) {
        try {
            return AutomaticTimerBean.parseJavaTime(dateTime);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static long parseJavaTime(String dateTime) {
        if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}", dateTime) || Pattern.matches("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\+|\\-)\\d{2}:\\d{2}:\\d{2}", dateTime)) {
            throw new IllegalArgumentException(dateTime + " is not a valid xsd:dateTime format");
        }
        if (Pattern.matches("\\d{4}", dateTime)) {
            dateTime = dateTime + "-01-01T00:00:00";
        } else if (Pattern.matches("\\d{4}-\\d{2}", dateTime)) {
            dateTime = dateTime + "-01T00:00:00";
        } else if (Pattern.matches("\\d{2}:\\d{2}:\\d(\\.\\d+)*(((\\+|\\-)\\d{2}:\\d{2})|Z)?", dateTime)) {
            dateTime = dateTime.substring(0, 6) + "0" + dateTime.substring(6, dateTime.length());
            dateTime = "1970-01-01T" + dateTime;
        } else if (Pattern.matches("\\d{2}:\\d{2}:\\d{2}(\\.\\d+)*(((\\+|\\-)\\d{2}:\\d{2})|Z)?", dateTime)) {
            dateTime = "1970-01-01T" + dateTime;
        } else if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}", dateTime)) {
            dateTime = dateTime + "T00:00:00";
        } else if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}Z", dateTime)) {
            dateTime = dateTime.substring(0, dateTime.length() - 1);
            dateTime = dateTime + "T00:00:00Z";
        } else if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}(\\+|\\-)\\d{2}:\\d{2}", dateTime)) {
            dateTime = dateTime.substring(0, 10) + "T00:00:00" + dateTime.substring(10, dateTime.length());
        } else if (Pattern.matches("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{1}(\\.\\d+)*(((\\+|\\-)\\d{2}:\\d{2})|Z)?", dateTime)) {
            dateTime = dateTime.substring(0, 17) + "0" + dateTime.substring(17, dateTime.length());
        }
        if (Pattern.matches(".*\\.\\d{4}\\d+.*", dateTime)) {
            String[] split = dateTime.split("\\.", 2);
            String[] split2 = split[1].split("(?<=\\d{4})", 2);
            String[] split3 = split2[1].split("(?!\\d)", 2);
            dateTime = split[0] + "." + split2[0];
            dateTime = split3.length > 1 ? dateTime + split3[1] : dateTime;
        }
        TemporalAccessor accessor = DateTimeFormatter.ofPattern("yyyy[-MM-dd]['T'HH:mm][:ss][.SSSSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S][z]").withZone(ZoneId.systemDefault()).parse(dateTime);
        return Instant.from(accessor).toEpochMilli();
    }
}

