/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util.stub;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.Type;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.util.stub.MethodRef;
import org.apache.yoko.rmi.util.stub.Stub;
import org.apache.yoko.rmi.util.stub.StubInitializer;
import org.apache.yoko.rmi.util.stub.Util;
import org.apache.yoko.rmispec.util.DelegateType;
import org.apache.yoko.util.Exceptions;
import org.apache.yoko.util.PrivilegedActions;
import org.omg.CORBA.INITIALIZE;

class BCELClassBuilder {
    private static final Logger logger = Logger.getLogger(BCELClassBuilder.class.getName());
    private static final Map<Class<?>, Type> KNOWN_TYPE_MAP = Collections.unmodifiableMap(new HashMap<Class<?>, Type>(){
        {
            this.put(Integer.TYPE, Type.INT);
            this.put(Boolean.TYPE, Type.BOOLEAN);
            this.put(Short.TYPE, Type.SHORT);
            this.put(Byte.TYPE, Type.BYTE);
            this.put(Long.TYPE, Type.LONG);
            this.put(Double.TYPE, Type.DOUBLE);
            this.put(Float.TYPE, Type.FLOAT);
            this.put(Character.TYPE, Type.CHAR);
            this.put(Void.TYPE, Type.VOID);
            this.put(Object.class, Type.OBJECT);
            this.put(Class.class, Type.CLASS);
            this.put(String.class, Type.STRING);
            this.put(StringBuffer.class, Type.STRINGBUFFER);
            this.put(Throwable.class, Type.THROWABLE);
        }
    });
    private static final MethodRef getStubHandlerRef;

    BCELClassBuilder() {
    }

    static <S> Class<S> makeStub(ClassLoader loader, Class<?> type, MethodRef[] methods, Object[] data, MethodRef handlerMethodRef, String className) {
        String superClassName = RMIStub.class.getName();
        String[] interfaceNames = new String[]{type.getName(), Stub.class.getName()};
        ClassGen newStubClass = new ClassGen(className, superClassName, "generated", 17, interfaceNames);
        ConstantPoolGen cp = newStubClass.getConstantPool();
        Class<?>[] paramTypes = Objects.requireNonNull(handlerMethodRef, "handler method is null").getParameterTypes();
        if (paramTypes.length != 3) {
            throw new IllegalArgumentException("handler method must have three arguments");
        }
        if (!paramTypes[0].isAssignableFrom(RMIStub.class)) {
            throw new IllegalArgumentException("Handler's 1st argument must be super-type for " + RMIStub.class);
        }
        Type typeOfDataFields = BCELClassBuilder.translate(paramTypes[1]);
        if (Object[].class != paramTypes[2]) {
            throw new IllegalArgumentException("Handler's 3rd argument must be Object[]");
        }
        Class<?> handlerClass = handlerMethodRef.getDeclaringClass();
        FieldGen handlerFieldGen = new FieldGen(18, BCELClassBuilder.translate(handlerClass), "__handler", cp);
        newStubClass.addField(handlerFieldGen.getField());
        BCELClassBuilder.generateHandlerGetter(newStubClass, handlerFieldGen);
        FieldGen initializerFieldGen = new FieldGen(10, BCELClassBuilder.translate(StubInitializer.class), "__initializer", cp);
        newStubClass.addField(initializerFieldGen.getField());
        BCELClassBuilder.emitInitializerConstructor(newStubClass, handlerFieldGen, initializerFieldGen);
        FieldGen[] dataFieldGens = new FieldGen[methods.length];
        IntStream.range(0, methods.length).forEach(i -> {
            dataFieldGens[i] = new FieldGen(10, typeOfDataFields, "__method$" + i, cp);
            newStubClass.addField(dataFieldGens[i].getField());
        });
        IntStream.range(0, methods.length).forEach(i -> BCELClassBuilder.generate(newStubClass, methods[i], dataFieldGens[i], handlerFieldGen, handlerMethodRef));
        JavaClass javaClass = newStubClass.getJavaClass();
        byte[] classData = javaClass.getBytes();
        return (Class)AccessController.doPrivileged(PrivilegedActions.action(() -> {
            if (Boolean.getBoolean("org.apache.yoko.rmi.util.stub.debug")) {
                File out = new File(className + ".class");
                try {
                    javaClass.dump(out);
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "", ex);
                }
            }
            Class proxyClass = Util.defineClass(loader, className, classData);
            IntStream.range(0, data.length).forEach(i -> {
                try {
                    Field f = proxyClass.getDeclaredField(dataFieldGens[i].getName());
                    f.setAccessible(true);
                    f.set(null, data[i]);
                    f.setAccessible(false);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    logger.log(Level.WARNING, "cannot find/access field " + dataFieldGens[i].getName() + " for stub class " + className + " extends: " + superClassName + " implements: " + String.join((CharSequence)", ", interfaceNames), e);
                    throw new Error("internal error!", e);
                }
            });
            try {
                Field f = proxyClass.getDeclaredField("__initializer");
                f.setAccessible(true);
                f.set(null, StubInitializerHolder.RMI_STUB_INITIALIZER);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                throw new Error("internal error!", ex);
            }
            return proxyClass;
        }));
    }

    private static Type translate(Class<?> clazz) {
        Type result = KNOWN_TYPE_MAP.get(clazz);
        if (result != null) {
            return result;
        }
        if (clazz.isPrimitive()) {
            throw new InternalError("Unknown primitive type: " + clazz);
        }
        return clazz.isArray() ? new ArrayType(BCELClassBuilder.translate(clazz.getComponentType()), 1) : new ObjectType(clazz.getName());
    }

    private static Type[] translate(Class<?>[] clazz) {
        return (Type[])Stream.of(clazz).map(BCELClassBuilder::translate).toArray(Type[]::new);
    }

    public static MethodRef[] collectMethods(Class<?> super_class, Class<?> type) {
        HashMap<String, MethodRef> methods = new HashMap<String, MethodRef>();
        BCELClassBuilder.collectAbstractMethods(methods, type);
        BCELClassBuilder.collectAbstractMethods(methods, super_class);
        BCELClassBuilder.removeImplementedMethods(methods, super_class);
        return (MethodRef[])methods.values().stream().toArray(MethodRef[]::new);
    }

    private static void collectAbstractMethods(Map<String, MethodRef> methods, Class<?> type) {
        if (type == Object.class || type == null) {
            return;
        }
        for (Class<?> if_type : type.getInterfaces()) {
            BCELClassBuilder.collectAbstractMethods(methods, if_type);
        }
        BCELClassBuilder.collectAbstractMethods(methods, type.getSuperclass());
        Predicate<Method> isInterfaceOrAbstractMethod = type.isInterface() ? m -> true : m -> Modifier.isAbstract(m.getModifiers());
        Arrays.stream(type.getDeclaredMethods()).filter(isInterfaceOrAbstractMethod).map(MethodRef::new).forEach(m -> methods.putIfAbsent(m.getKey(), (MethodRef)m));
    }

    private static void removeImplementedMethods(Map<String, ?> methods, Class<?> type) {
        if (type == Object.class || type == null) {
            return;
        }
        BCELClassBuilder.removeImplementedMethods(methods, type.getSuperclass());
        Arrays.stream(type.getDeclaredMethods()).filter(m -> !Modifier.isAbstract(m.getModifiers())).map(MethodRef::getKey).forEach(methods::remove);
    }

    private static void emitInitializerConstructor(ClassGen stubClass, FieldGen handlerField, FieldGen initializerField) {
        String stubClassName = stubClass.getClassName();
        ConstantPoolGen cp = stubClass.getConstantPool();
        InstructionList il = new InstructionList();
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, Type.NO_ARGS, null, "<init>", stubClassName, il, cp);
        InstructionFactory fac = new InstructionFactory(stubClass, cp);
        il.append(InstructionFactory.createThis());
        il.append((Instruction)fac.createInvoke(stubClass.getSuperclassName(), "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        il.append(InstructionFactory.createThis());
        il.append((Instruction)fac.createGetStatic(stubClassName, initializerField.getName(), initializerField.getType()));
        BCELClassBuilder.emitInvoke(il, fac, getStubHandlerRef);
        il.append(fac.createCast((Type)Type.OBJECT, handlerField.getType()));
        il.append((Instruction)new PUTFIELD(cp.addFieldref(stubClassName, handlerField.getName(), handlerField.getSignature())));
        il.append((Instruction)InstructionConstants.RETURN);
        mg.setMaxStack();
        mg.setMaxLocals();
        stubClass.addMethod(mg.getMethod());
    }

    private static void generateHandlerGetter(ClassGen clazz, FieldGen handlerField) {
        Method[] stub_methods = Stub.class.getDeclaredMethods();
        if (stub_methods.length != 1) {
            throw new IllegalStateException("" + Stub.class + " has wrong # methods");
        }
        String handlerGetName = stub_methods[0].getName();
        ConstantPoolGen cp = clazz.getConstantPool();
        InstructionList il = new InstructionList();
        InstructionFactory fac = new InstructionFactory(clazz, cp);
        Type methodReturnType = BCELClassBuilder.translate(Object.class);
        Type[] methodArgTypes = new Type[]{};
        MethodGen mg = new MethodGen(17, methodReturnType, methodArgTypes, null, handlerGetName, clazz.getClassName(), il, cp);
        mg.addAttribute((Attribute)new Synthetic(cp.addUtf8("Synthetic"), 0, null, cp.getConstantPool()));
        il.append(InstructionFactory.createThis());
        il.append((Instruction)fac.createGetField(clazz.getClassName(), handlerField.getName(), handlerField.getType()));
        BCELClassBuilder.emitReturn(il, methodReturnType);
        mg.setMaxStack();
        mg.setMaxLocals();
        clazz.addMethod(mg.getMethod());
    }

    private static void generate(ClassGen clazz, MethodRef method, FieldGen dataField, FieldGen handlerField, MethodRef handlerMethodRef) {
        ConstantPoolGen cp = clazz.getConstantPool();
        InstructionList il = new InstructionList();
        InstructionFactory fac = new InstructionFactory(clazz, cp);
        Type methodReturnType = BCELClassBuilder.translate(method.getReturnType());
        Type[] methodArgTypes = BCELClassBuilder.translate(method.getParameterTypes());
        MethodGen mg = new MethodGen(17, methodReturnType, methodArgTypes, null, method.getName(), clazz.getClassName(), il, cp);
        mg.addAttribute((Attribute)new Synthetic(cp.addUtf8("Synthetic"), 0, null, cp.getConstantPool()));
        Arrays.stream(method.getExceptionTypes()).map(Class::getName).forEach(arg_0 -> ((MethodGen)mg).addException(arg_0));
        il.append(InstructionFactory.createThis());
        il.append((Instruction)fac.createGetField(clazz.getClassName(), handlerField.getName(), handlerField.getType()));
        il.append(InstructionFactory.createThis());
        if (dataField.isStatic()) {
            il.append((Instruction)fac.createGetStatic(clazz.getClassName(), dataField.getName(), dataField.getType()));
        } else {
            il.append(InstructionFactory.createThis());
            il.append((Instruction)fac.createGetField(clazz.getClassName(), dataField.getName(), dataField.getType()));
        }
        il.append((CompoundInstruction)new PUSH(cp, methodArgTypes.length));
        il.append(fac.createNewArray((Type)Type.OBJECT, (short)1));
        int index = 1;
        for (int i = 0; i < methodArgTypes.length; ++i) {
            il.append((Instruction)InstructionConstants.DUP);
            il.append((CompoundInstruction)new PUSH(cp, i));
            il.append((Instruction)InstructionFactory.createLoad((Type)methodArgTypes[i], (int)index));
            BCELClassBuilder.emitCoerceToObject(il, fac, methodArgTypes[i]);
            il.append((Instruction)InstructionFactory.createArrayStore((Type)Type.OBJECT));
            index += methodArgTypes[i].getSize();
        }
        InstructionHandle tryStart = BCELClassBuilder.emitInvoke(il, fac, handlerMethodRef);
        BCELClassBuilder.emitCoerceFromObject(il, fac, methodReturnType);
        InstructionHandle tryEnd = BCELClassBuilder.emitReturn(il, methodReturnType);
        InstructionHandle rethrowLocation = il.append((Instruction)new ATHROW());
        Class<?>[] exceptions = method.getExceptionTypes();
        boolean handle_throwable_exception = true;
        boolean handle_runtime_exception = true;
        if (exceptions != null) {
            for (Class<?> ex : exceptions) {
                if (ex == Throwable.class) {
                    handle_throwable_exception = false;
                }
                if (ex == RuntimeException.class || ex == Exception.class) {
                    handle_runtime_exception = false;
                }
                mg.addExceptionHandler(tryStart, tryEnd, rethrowLocation, (ObjectType)BCELClassBuilder.translate(ex));
            }
        }
        if (handle_throwable_exception && handle_runtime_exception) {
            mg.addExceptionHandler(tryStart, tryEnd, rethrowLocation, new ObjectType("java.lang.RuntimeException"));
        }
        if (handle_throwable_exception) {
            InstructionHandle handlerStart = il.append((Instruction)new ASTORE(1));
            il.append((Instruction)new NEW(cp.addClass("java.lang.reflect.UndeclaredThrowableException")));
            il.append((Instruction)InstructionConstants.DUP);
            il.append((Instruction)new ALOAD(1));
            il.append((Instruction)new INVOKESPECIAL(cp.addMethodref("java.lang.reflect.UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V")));
            il.append((Instruction)new ATHROW());
            mg.addExceptionHandler(tryStart, tryEnd, handlerStart, new ObjectType("java.lang.Throwable"));
        }
        mg.setMaxStack();
        mg.setMaxLocals();
        clazz.addMethod(mg.getMethod());
    }

    private static InstructionHandle emitReturn(InstructionList il, Type type) {
        return PrimitiveTypeEmitters.get(type).map(pte -> pte.emitReturn.apply(il)).orElse(il.append((Instruction)new ARETURN()));
    }

    private static void emitCoerceToObject(InstructionList il, InstructionFactory fac, Type type) {
        PrimitiveTypeEmitters.get(type).map(pte -> pte.emitBox.apply(il, fac));
    }

    private static void emitCoerceFromObject(InstructionList il, InstructionFactory fac, Type type) {
        PrimitiveTypeEmitters.get(type).map(pte -> pte.emitUnbox).orElse(BCELClassBuilder.emitCoerceToTypeFromObject(type)).apply(il, fac);
    }

    private static BiFunction<InstructionList, InstructionFactory, InstructionHandle> emitCoerceToTypeFromObject(Type type) {
        return (il, fac) -> {
            switch (type.getType()) {
                case 13: 
                case 14: {
                    return il.append(fac.createCast((Type)Type.OBJECT, type));
                }
            }
            throw new Error();
        };
    }

    private static InstructionHandle emitInvoke(InstructionList il, InstructionFactory fac, MethodRef method) {
        String signature = method.getSignature();
        Type[] args = Type.getArgumentTypes((String)signature);
        Type ret = Type.getReturnType((String)signature);
        String mname = method.getName();
        String cname = method.getDeclaringClass().getName();
        int kind = method.getDeclaringClass().isInterface() ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : (method.getName().charAt(0) == '<' ? 183 : 182));
        return il.append((Instruction)fac.createInvoke(cname, mname, ret, args, (short)kind));
    }

    static {
        try {
            getStubHandlerRef = new MethodRef(StubInitializer.class.getDeclaredMethod("getStubHandler", new Class[0]));
        }
        catch (NoSuchMethodException ex) {
            throw new Error(ex.getMessage(), ex);
        }
    }

    static enum StubInitializerHolder {

        static final StubInitializer RMI_STUB_INITIALIZER;

        private static <T> T doPrivEx(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
            return AccessController.doPrivileged(action);
        }

        static {
            try {
                Constructor constructor = (Constructor)StubInitializerHolder.doPrivEx(DelegateType.STUB_INIT.getConstructorAction());
                RMI_STUB_INITIALIZER = (StubInitializer)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw (INITIALIZE)Exceptions.as(INITIALIZE::new, (Throwable)e, (Object)"Can not create RMIStubInitializer");
            }
        }
    }

    static enum PrimitiveTypeEmitters {
        BOOLEAN_EMITTERS(Boolean.TYPE, Boolean.class),
        CHAR_EMITTERS(Character.TYPE, Character.class),
        BYTE_EMITTERS(Byte.TYPE, Byte.class),
        SHORT_EMITTERS(Short.TYPE, Short.class),
        INT_EMITTERS(Integer.TYPE, Integer.class),
        LONG_EMITTERS(Long.TYPE, Long.class),
        FLOAT_EMITTERS(Float.TYPE, Float.class),
        DOUBLE_EMITTERS(Double.TYPE, Double.class),
        VOID_EMITTERS((Type)Type.VOID, (il, fac) -> il.append((Instruction)InstructionConstants.POP), (il, fac) -> il.append(InstructionConstants.ACONST_NULL), il -> il.append((Instruction)InstructionConstants.RETURN));

        final Type type;
        final BiFunction<InstructionList, InstructionFactory, InstructionHandle> emitUnbox;
        final BiFunction<InstructionList, InstructionFactory, InstructionHandle> emitBox;
        final Function<InstructionList, InstructionHandle> emitReturn;
        private static final Map<Type, PrimitiveTypeEmitters> EMITTERS;

        static Optional<PrimitiveTypeEmitters> get(Type type) {
            return Optional.ofNullable(EMITTERS.get(type));
        }

        private PrimitiveTypeEmitters(Class<?> primitiveClass, Class<?> wrapperClass) {
            this(Type.getType(primitiveClass), wrapperClass, primitiveClass.getName() + "Value");
        }

        private PrimitiveTypeEmitters(Type type, Class<?> wrapperClass, String unboxMethodName) {
            this(type, PrimitiveTypeEmitters.genEmitUnbox(wrapperClass, unboxMethodName), PrimitiveTypeEmitters.genEmitBox(type, wrapperClass), PrimitiveTypeEmitters.genEmitReturn(type));
        }

        private PrimitiveTypeEmitters(Type type, BiFunction<InstructionList, InstructionFactory, InstructionHandle> emitUnbox, BiFunction<InstructionList, InstructionFactory, InstructionHandle> emitBox, Function<InstructionList, InstructionHandle> emitReturn) {
            this.type = type;
            this.emitUnbox = emitUnbox;
            this.emitBox = emitBox;
            this.emitReturn = emitReturn;
        }

        private static Function<InstructionList, InstructionHandle> genEmitReturn(Type type) {
            switch (type.getType()) {
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    return il -> il.append((Instruction)new IRETURN());
                }
                case 11: {
                    return il -> il.append((Instruction)new LRETURN());
                }
                case 6: {
                    return il -> il.append((Instruction)new FRETURN());
                }
                case 7: {
                    return il -> il.append((Instruction)new DRETURN());
                }
            }
            throw new InternalError();
        }

        private static BiFunction<InstructionList, InstructionFactory, InstructionHandle> genEmitBox(Type type, Class<?> wrapperClass) {
            String wrapperClassName = wrapperClass.getName();
            Type[] argTypes = new Type[]{type};
            ObjectType newObjectType = new ObjectType(wrapperClassName);
            switch (type.getType()) {
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    return (il, fac) -> {
                        il.append((Instruction)fac.createNew(newObjectType));
                        il.append((Instruction)InstructionConstants.DUP_X1);
                        il.append((Instruction)InstructionConstants.SWAP);
                        return il.append((Instruction)fac.createInvoke(wrapperClassName, "<init>", (Type)Type.VOID, argTypes, (short)183));
                    };
                }
                case 7: 
                case 11: {
                    return (il, fac) -> {
                        il.append((Instruction)fac.createNew(newObjectType));
                        il.append((Instruction)InstructionConstants.DUP_X2);
                        il.append((Instruction)InstructionConstants.DUP_X2);
                        il.append((Instruction)InstructionConstants.POP);
                        return il.append((Instruction)fac.createInvoke(wrapperClassName, "<init>", (Type)Type.VOID, argTypes, (short)183));
                    };
                }
            }
            throw new InternalError();
        }

        private static BiFunction<InstructionList, InstructionFactory, InstructionHandle> genEmitUnbox(Class<?> wrapperClass, String unwrapMethodName) {
            ObjectType objectType = new ObjectType(wrapperClass.getName());
            try {
                MethodRef unwrapMethodRef = new MethodRef(wrapperClass.getDeclaredMethod(unwrapMethodName, new Class[0]));
                return (il, fac) -> {
                    il.append(fac.createCast((Type)Type.OBJECT, (Type)objectType));
                    return BCELClassBuilder.emitInvoke(il, fac, unwrapMethodRef);
                };
            }
            catch (NoSuchMethodException e) {
                throw new Error("unwrap method not found for " + wrapperClass, e);
            }
        }

        static {
            EMITTERS = Collections.unmodifiableMap(Arrays.stream(PrimitiveTypeEmitters.values()).collect(Collectors.toMap(pte -> pte.type, pte -> pte)));
        }
    }
}

