/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.runtime.SIMPMessageHandlerControllable;
import com.ibm.ws.sib.processor.runtime.SIMPPtoPOutboundTransmitControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.XmitPoint;
import com.ibm.ws.sib.processor.runtime.impl.XmitPointControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;

public class RemoteMediationPoint
extends AbstractRegisteredControlAdapter
implements XmitPoint {
    private XmitPointControl xmitPointControl;
    private SIBUuid8 remoteME;
    private SIMPMessageHandlerControllable messageHandlerControllable;
    private String messageHandlerName;
    protected String id;
    private static TraceComponent tc = SibTr.register(RemoteMediationPoint.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public RemoteMediationPoint(SIBUuid8 remoteME, DestinationHandler destinationHandler, MessageProcessor messageProcessor, ControllableType controllableType) {
        super(messageProcessor, controllableType);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteMediationPoint", (Object)new Object[]{remoteME, destinationHandler, messageProcessor, controllableType});
        }
        this.messageHandlerControllable = (SIMPMessageHandlerControllable)destinationHandler.getControlAdapter();
        this.messageHandlerName = this.messageHandlerControllable.getName();
        this.remoteME = remoteME;
        this.id = destinationHandler.getUuid().toString() + "_REMOTE_MEDIATION_" + remoteME.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteMediationPoint", (Object)this);
        }
    }

    public SIMPMessageHandlerControllable getMessageHandler() {
        return this.messageHandlerControllable;
    }

    public SIMPPtoPOutboundTransmitControllable getPtoPOutboundTransmit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPtoPOutboundTransmit");
        }
        SIMPPtoPOutboundTransmitControllable control = null;
        if (this.xmitPointControl != null) {
            control = this.xmitPointControl.getPtoPOutboundTransmit();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPtoPOutboundTransmit", (Object)control);
        }
        return control;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.messageHandlerName;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.xmitPointControl != null) {
            this.xmitPointControl.assertValidControllable();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this.dereferenceXmitQueuePointControl();
        super.dereferenceControllable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public synchronized void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (!this.isRegistered() && !this.getMessageHandler().isTemporary()) {
            super.registerControlAdapterAsMBean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public String getUuid() {
        return null;
    }

    @Override
    public String getConfigId() {
        return null;
    }

    @Override
    public String getRemoteEngineUuid() {
        return this.remoteME.toString();
    }

    public SIBUuid12 getUUID() {
        return null;
    }

    public boolean isReceiveAllowed() {
        return false;
    }

    public boolean isSendAllowed() {
        return false;
    }

    public void setReceiveAllowed(boolean arg) {
    }

    public void setSendAllowed(boolean arg) {
    }

    public long getDestinationHighMsgs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHighMsgs");
        }
        long destHighMsgs = 0L;
        if (this.xmitPointControl != null) {
            destHighMsgs = this.xmitPointControl.getDestinationHighMsgs();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHighMsgs", (Object)new Long(destHighMsgs));
        }
        return destHighMsgs;
    }

    @Override
    public void setXmitQueuePointControl(XmitPointControl xmitPointControl) {
        this.xmitPointControl = xmitPointControl;
    }

    @Override
    public void dereferenceXmitQueuePointControl() {
        this.xmitPointControl = null;
    }
}

