/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.context;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.internal.SubjectThreadContext;
import com.ibm.ws.security.mp.jwt.proxy.MpJwtHelper;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SubjectManager {
    private static final ThreadLocal<SubjectThreadContext> threadLocal = new SecurityThreadLocal();
    private static final SubjectHelper subjectHelper = new SubjectHelper();
    private static final TraceComponent tc = Tr.register(SubjectManager.class, null, null);
    static final long serialVersionUID = 942329240255472527L;

    public void setCallerSubject(Subject callerSubject) {
        SubjectThreadContext subjectThreadContext = this.getSubjectThreadContext();
        subjectThreadContext.setCallerSubject(callerSubject);
    }

    public Subject getCallerSubject() {
        SubjectThreadContext subjectThreadContext = this.getSubjectThreadContext();
        return subjectThreadContext.getCallerSubject();
    }

    public void setInvocationSubject(Subject invocationSubject) {
        SubjectThreadContext subjectThreadContext = this.getSubjectThreadContext();
        subjectThreadContext.setInvocationSubject(invocationSubject);
    }

    public Subject getInvocationSubject() {
        SubjectThreadContext subjectThreadContext = this.getSubjectThreadContext();
        return subjectThreadContext.getInvocationSubject();
    }

    public Subject replaceCallerSubject(Subject callerSubject) {
        SubjectThreadContext subjectThreadContext = this.getSubjectThreadContext();
        Subject replacedCallerSubject = subjectThreadContext.getCallerSubject();
        subjectThreadContext.setCallerSubject(callerSubject);
        return replacedCallerSubject;
    }

    public Subject replaceInvocationSubject(Subject invocationSubject) {
        SubjectThreadContext subjectThreadContext = this.getSubjectThreadContext();
        Subject replacedInvocationSubject = subjectThreadContext.getInvocationSubject();
        subjectThreadContext.setInvocationSubject(invocationSubject);
        return replacedInvocationSubject;
    }

    public void clearSubjects() {
        SubjectThreadContext subjectThreadContext = this.getSubjectThreadContext();
        subjectThreadContext.clearSubjects();
    }

    @Trivial
    protected SubjectThreadContext getSubjectThreadContext() {
        ThreadLocal<SubjectThreadContext> currentThreadLocal = this.getThreadLocal();
        SubjectThreadContext subjectThreadContext = currentThreadLocal.get();
        if (subjectThreadContext == null) {
            subjectThreadContext = new SubjectThreadContext();
            currentThreadLocal.set(subjectThreadContext);
        }
        return subjectThreadContext;
    }

    @Trivial
    private ThreadLocal<SubjectThreadContext> getThreadLocal() {
        return threadLocal;
    }

    /*
     * WARNING - void declaration
     */
    public static Principal getCallerPrincipal(Subject callerSubject) {
        if (callerSubject == null) {
            return null;
        }
        if (subjectHelper.isUnauthenticated(callerSubject)) {
            return null;
        }
        Principal jsonWebToken = MpJwtHelper.getJsonWebTokenPricipal((Subject)callerSubject);
        if (jsonWebToken != null) {
            return jsonWebToken;
        }
        WSCredential wscredential = subjectHelper.getWSCredential(callerSubject);
        if (wscredential != null) {
            Set<Principal> principals;
            String securityName;
            block15: {
                block14: {
                    Principal principal = null;
                    try {
                        principal = (Principal)wscredential.get("com.ibm.wsspi.security.cred.jaspi.principal");
                        if (principal != null) {
                            return principal;
                        }
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.context.SubjectManager", (String)"168", null, (Object[])new Object[]{callerSubject});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                        Tr.debug((TraceComponent)tc, (String)"Internal error getting JASPIC Principal from credential", (Object[])new Object[]{e});
                    }
                }
                securityName = null;
                try {
                    securityName = wscredential.getSecurityName();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.context.SubjectManager", (String)"178", null, (Object[])new Object[]{callerSubject});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                    Tr.debug((TraceComponent)tc, (String)"Error getting securityName from WSCredential", (Object[])new Object[]{e});
                }
            }
            WSPrincipal wsPrincipal = null;
            if (securityName != null) {
                principals = callerSubject.getPrincipals(WSPrincipal.class);
                if (!principals.isEmpty()) {
                    wsPrincipal = (WSPrincipal)principals.iterator().next();
                    wsPrincipal = new WSPrincipal(securityName, wsPrincipal.getAccessId(), wsPrincipal.getAuthenticationMethod());
                }
                if (wsPrincipal != null) {
                    return wsPrincipal;
                }
            }
            if ((principals = callerSubject.getPrincipals()).size() > 0) {
                for (Principal principal : principals) {
                    if (!(principal instanceof WSPrincipal)) continue;
                    return principal;
                }
            }
            return principals.iterator().next();
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class SecurityThreadLocal
    extends ThreadLocal<SubjectThreadContext> {
        static final long serialVersionUID = 6877199245881107856L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SecurityThreadLocal() {
        }

        @Override
        protected SubjectThreadContext initialValue() {
            return new SubjectThreadContext();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.context.SubjectManager$SecurityThreadLocal", SecurityThreadLocal.class, null, null);
        }
    }
}

