/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.tools.JavaFileObject;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.graphs.NamedEntityGraphMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProperties;
import org.eclipse.persistence.internal.jpa.modelgen.MessagerLog;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnitReader;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.TypeVisitor;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;

public class CanonicalModelProcessor
extends AbstractProcessor {
    protected MetadataMirrorFactory nonStaticFactory;
    protected static MetadataMirrorFactory staticFactory;
    private SessionLog log;
    private boolean useStaticFactory;
    private boolean generateComments;
    private boolean generateTimestamp;
    private boolean generateGenerated;
    private static final String TYPE_TEMPLATE = "    public static volatile %s<%s> class_;%n";
    private static final String ATTRIBUTE_NAME_TEMPLATE = "    public static final String %s = \"%s\";%n";
    private static final String NAMED_NAME_TEMPLATE = "    public static final String %s_%s = \"%s\";%n";
    private static final String ATTRIBUTE_TYPE_TEMPLATE = "    public static volatile %s<%s> %s;%n";
    private static final String REFERENCE_TEMPLATE = "    public static volatile TypedQueryReference<%s> _%s_;%n";
    private static final String GRAPH_TEMPLATE = "    public static volatile EntityGraph<%s> _%s;%n";
    private static final Set<String> SUPPORTED_ANNOTATIONS;
    private static final Set<String> SUPPORTED_OPTIONS;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return SUPPORTED_ANNOTATIONS;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        this.log = new MessagerLog(processingEnv.getMessager(), options);
        if (Boolean.parseBoolean(options.get("verbose")) && this.log.getLevel() > 2) {
            this.log.setLevel(2);
        }
        AbstractSessionLog.setLog(this.log);
        for (Map.Entry<String, String> option : options.entrySet()) {
            this.log(4, "Found Option: {0}, with value: {1}", option.getKey(), option.getValue());
        }
        this.useStaticFactory = Boolean.parseBoolean(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.use_static_factory", "true", options));
        this.generateGenerated = Boolean.parseBoolean(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.use_generated", "true", options));
        if (this.generateGenerated) {
            this.generateTimestamp = Boolean.parseBoolean(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.generate_timestamp", "true", options));
            this.generateComments = Boolean.parseBoolean(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.generate_comments", "true", options));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver() && !roundEnv.errorRaised()) {
            MetadataMirrorFactory factory = null;
            try {
                if (this.useStaticFactory) {
                    if (staticFactory == null) {
                        session = new ServerSession(new Project(new DatabaseLogin()));
                        session.setSessionLog(this.log);
                        logger = new MetadataLogger(session);
                        staticFactory = new MetadataMirrorFactory(logger, Thread.currentThread().getContextClassLoader());
                        this.log(5, "Creating static metadata factory ...", new Object[0]);
                    }
                    factory = staticFactory;
                } else {
                    if (this.nonStaticFactory == null) {
                        session = new ServerSession(new Project(new DatabaseLogin()));
                        session.setSessionLog(this.log);
                        logger = new MetadataLogger(session);
                        this.nonStaticFactory = new MetadataMirrorFactory(logger, Thread.currentThread().getContextClassLoader());
                        this.log(5, "Creating non-static metadata factory ...", new Object[0]);
                    }
                    factory = this.nonStaticFactory;
                }
                MetadataLogger logger = factory.getLogger();
                factory.setEnvironments(this.processingEnv, roundEnv);
                PersistenceUnitReader puReader = new PersistenceUnitReader(logger, this.processingEnv);
                puReader.initPersistenceUnits(factory);
                for (PersistenceUnit persistenceUnit : factory.getPersistenceUnits()) {
                    for (Element element : roundEnv.getElementsAnnotatedWith(Entity.class)) {
                        persistenceUnit.addEntityAccessor(element);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(Embeddable.class)) {
                        persistenceUnit.addEmbeddableAccessor(element);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(MappedSuperclass.class)) {
                        persistenceUnit.addMappedSuperclassAccessor(element);
                    }
                    persistenceUnit.preProcessForCanonicalModel();
                    this.generateCanonicalModelClasses(factory, persistenceUnit);
                }
            }
            catch (Exception e) {
                this.log.logThrowable(7, "processor", e);
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    protected void generateCanonicalModelClass(MetadataClass metadataClass, Element element, PersistenceUnit persistenceUnit) throws IOException {
        ClassAccessor accessor = persistenceUnit.getClassAccessor(metadataClass);
        String qualifiedName = accessor.getAccessibleObjectName();
        String className = this.getName(qualifiedName);
        String classPackage = this.getPackage(qualifiedName);
        String qualifiedCanonicalName = persistenceUnit.getQualifiedCanonicalName(qualifiedName);
        String canonicalName = this.getName(qualifiedCanonicalName);
        String canonicalpackage = this.getPackage(qualifiedCanonicalName);
        boolean isNewJava = SourceVersion.RELEASE_8.compareTo(this.processingEnv.getSourceVersion()) < 0;
        ArrayList<String> attributes = new ArrayList<String>();
        HashMap<String, String> imports = new HashMap<String, String>();
        if (this.generateGenerated) {
            if (isNewJava) {
                imports.put("Generated", "javax.annotation.processing.Generated");
            } else {
                imports.put("Generated", "jakarta.annotation.Generated");
            }
        }
        if (!classPackage.equals(canonicalpackage)) {
            imports.put(className, qualifiedName);
        }
        MetadataProject project = accessor.getProject();
        Attributes processedAttributes = this.processAccessorType(accessor);
        imports.putAll(processedAttributes.imports());
        if (attributes.addAll(processedAttributes.attributes())) {
            attributes.add(System.lineSeparator());
        }
        processedAttributes = this.processNamedQueries(project, accessor);
        imports.putAll(processedAttributes.imports());
        if (attributes.addAll(processedAttributes.attributes())) {
            attributes.add(System.lineSeparator());
        }
        processedAttributes = this.processNamedGraphs(project, accessor);
        imports.putAll(processedAttributes.imports());
        if (attributes.addAll(processedAttributes.attributes())) {
            attributes.add(System.lineSeparator());
        }
        processedAttributes = this.processNamedSqlResultSets(project, accessor);
        imports.putAll(processedAttributes.imports());
        if (attributes.addAll(processedAttributes.attributes())) {
            attributes.add(System.lineSeparator());
        }
        processedAttributes = this.processMappings(accessor);
        imports.putAll(processedAttributes.imports());
        if (attributes.addAll(processedAttributes.attributes())) {
            attributes.add(System.lineSeparator());
        }
        JavaFileObject file = this.processingEnv.getFiler().createSourceFile(qualifiedCanonicalName, element);
        try (Writer writer = file.openWriter();){
            if (!canonicalpackage.isEmpty()) {
                writer.append("package ").append(canonicalpackage).append(";").append(System.lineSeparator()).append(System.lineSeparator());
            }
            Map<String, String> filteredImports = imports.entrySet().stream().filter(entry -> !canonicalpackage.equals(this.getPackage((String)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            String parent = this.writeImportStatements(filteredImports, accessor, writer, persistenceUnit, canonicalpackage);
            if (this.generateGenerated) {
                String elVersion = "EclipseLink-" + Version.getVersion() + ".v" + Version.getBuildDate() + "-r" + Version.getBuildRevision();
                writer.append("@Generated(value=\"");
                if (isNewJava) {
                    writer.append(CanonicalModelProcessor.class.getName());
                } else {
                    writer.append(elVersion);
                }
                writer.append("\"");
                if (this.generateTimestamp) {
                    Date date = new Date();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    writer.append(", date=\"").append(sdf.format(date)).append("\"");
                }
                if (isNewJava && this.generateComments) {
                    writer.append(", comments=\"");
                    writer.append(elVersion);
                    writer.append("\"");
                }
                writer.append(")");
                writer.append(System.lineSeparator());
            }
            writer.append("@StaticMetamodel(").append(className).append(".class)").append(System.lineSeparator());
            writer.append("@SuppressWarnings({\"rawtypes\", \"deprecation\"})").append(System.lineSeparator());
            int modifier = accessor.getAccessibleObject().getModifiers();
            writer.append(Modifier.toString(modifier)).append(" class ").append(canonicalName);
            if (parent != null) {
                writer.append(" extends ").append(parent);
            }
            writer.append(" {").append(System.lineSeparator()).append(System.lineSeparator());
            for (String str : attributes) {
                writer.append(str);
            }
            writer.append("}");
            writer.flush();
        }
    }

    protected void generateCanonicalModelClasses(MetadataMirrorFactory factory, PersistenceUnit persistenceUnit) throws IOException {
        Map<Element, MetadataClass> roundElements = factory.getRoundElements();
        for (Map.Entry<Element, MetadataClass> entry : roundElements.entrySet()) {
            Element roundElement = entry.getKey();
            MetadataClass roundClass = entry.getValue();
            if (!persistenceUnit.containsClass(roundClass) || factory.isProcessed(roundElement)) continue;
            this.log(1, "Generating class: {0}", roundClass.getName());
            this.generateCanonicalModelClass(roundClass, roundElement, persistenceUnit);
            factory.addProcessed(roundElement);
        }
    }

    protected String getBoxedType(MetadataAnnotatedElement annotatedElement, MetadataClass rawClass) {
        PrimitiveType primitiveType = (PrimitiveType)annotatedElement.getPrimitiveType();
        if (primitiveType != null) {
            return this.processingEnv.getTypeUtils().boxedClass(primitiveType).toString();
        }
        String type = annotatedElement.getType();
        return type == null ? rawClass.getType() : type;
    }

    protected String getName(String qualifiedName) {
        if (qualifiedName.indexOf(46) > -1) {
            return qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
        }
        return qualifiedName;
    }

    protected String getPackage(String qualifiedName) {
        if (qualifiedName.indexOf(46) > -1) {
            return qualifiedName.substring(0, qualifiedName.lastIndexOf(46));
        }
        return "";
    }

    private String toJavaIdentifier(String s) {
        StringBuilder sb = new StringBuilder();
        if (Character.isJavaIdentifierStart(s.charAt(0))) {
            sb.append(s.charAt(0));
        } else {
            sb.append('_');
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) {
                sb.append(s.charAt(i));
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private String toUpperCase(String s) {
        StringBuilder sb = new StringBuilder();
        if (Character.isJavaIdentifierStart(s.charAt(0))) {
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
                sb.append('_');
            }
        } else {
            sb.append('_');
        }
        for (int i = 1; i < s.length() - 1; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) {
                sb.append(Character.toUpperCase(s.charAt(i)));
                if (!Character.isUpperCase(s.charAt(i + 1))) continue;
                sb.append('_');
                continue;
            }
            sb.append('_');
        }
        sb.append(Character.toUpperCase(s.charAt(s.length() - 1)));
        return sb.toString();
    }

    protected String getUnqualifiedType(String type, Map<String, String> imports) {
        type = type.trim();
        if ((type = type.replace("$", ".")).contains("void")) {
            return TypeVisitor.GENERIC_TYPE;
        }
        if (type.startsWith("java.lang")) {
            return type.substring(type.lastIndexOf(46) + 1);
        }
        if (type.indexOf(60) > -1) {
            String raw = type.substring(0, type.indexOf(62));
            String generic = type.substring(type.indexOf(60) + 1, type.length() - 1);
            if (raw.contains("Map")) {
                String key = generic.substring(0, generic.indexOf(44));
                String value = generic.substring(generic.indexOf(44) + 1);
                return this.getUnqualifiedType(raw, imports) + "<" + this.getUnqualifiedType(key, imports) + ", " + this.getUnqualifiedType(value, imports) + ">";
            }
            return this.getUnqualifiedType(raw, imports) + "<" + this.getUnqualifiedType(generic, imports) + ">";
        }
        if (type.indexOf(46) > -1) {
            String shortClassName = type.substring(type.lastIndexOf(46) + 1);
            if (imports.containsKey(shortClassName)) {
                if (imports.get(shortClassName).equals(type)) {
                    return type.substring(type.lastIndexOf(46) + 1);
                }
                return type;
            }
            if (shortClassName.indexOf(91) > 1) {
                imports.put(shortClassName, type.substring(0, type.indexOf(91)));
            } else {
                imports.put(shortClassName, type);
            }
            return shortClassName;
        }
        return type;
    }

    private Attributes processAccessorType(ClassAccessor accessor) {
        TreeSet<String> attributes = new TreeSet<String>();
        HashMap<String, String> imports = new HashMap<String, String>();
        String type = null;
        if (accessor.isEntityAccessor()) {
            type = "EntityType";
        } else if (accessor.isEmbeddableAccessor()) {
            type = "EmbeddableType";
        } else if (accessor.isMappedSuperclass()) {
            type = "MappedSuperclassType";
        }
        if (type != null) {
            attributes.add(TYPE_TEMPLATE.formatted(type, this.getUnqualifiedType(accessor.getAccessibleObjectName(), imports)));
            imports.put(type, "jakarta.persistence.metamodel." + type);
        }
        return new Attributes(attributes, imports);
    }

    private Attributes processMappings(ClassAccessor accessor) {
        TreeSet<String> attributes = new TreeSet<String>();
        HashMap<String, String> imports = new HashMap<String, String>();
        String className = this.getName(accessor.getAccessibleObjectName());
        for (MappingAccessor mappingAccessor : accessor.getDescriptor().getMappingAccessors()) {
            String attributeType;
            if (mappingAccessor.isTransient()) continue;
            MetadataAnnotatedElement annotatedElement = mappingAccessor.getAnnotatedElement();
            MetadataClass rawClass = mappingAccessor.getRawClass();
            Object types = className;
            if (mappingAccessor.isBasic()) {
                types = (String)types + ", " + this.getUnqualifiedType(this.getBoxedType(annotatedElement, rawClass), imports);
                attributeType = AttributeType.SingularAttribute.name();
            } else {
                attributeType = rawClass.isList() ? AttributeType.ListAttribute.name() : (rawClass.isSet() ? AttributeType.SetAttribute.name() : (rawClass.isMap() ? AttributeType.MapAttribute.name() : (rawClass.isCollection() ? AttributeType.CollectionAttribute.name() : AttributeType.SingularAttribute.name())));
                if (mappingAccessor.isMapAccessor()) {
                    if (mappingAccessor.isMappedKeyMapAccessor()) {
                        MetadataClass mapKeyClass = ((MappedKeyMapAccessor)((Object)mappingAccessor)).getMapKeyClass();
                        types = (String)types + ", " + this.getUnqualifiedType(mapKeyClass.getName(), imports) + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                    } else {
                        String mapKeyType;
                        if (annotatedElement.isGenericCollectionType()) {
                            mapKeyType = annotatedElement.getGenericType().get(1);
                        } else if (mappingAccessor.getReferenceDescriptor().hasIdAccessor()) {
                            MappingAccessor idAccessor = mappingAccessor.getReferenceDescriptor().getIdAccessors().values().iterator().next();
                            mapKeyType = idAccessor.getReferenceClassName();
                        } else {
                            mapKeyType = TypeVisitor.GENERIC_TYPE;
                        }
                        types = (String)types + ", " + this.getUnqualifiedType(mapKeyType, imports) + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                    }
                } else {
                    types = (String)types + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                }
            }
            imports.put(attributeType, "jakarta.persistence.metamodel." + attributeType);
            attributes.add(ATTRIBUTE_NAME_TEMPLATE.formatted(this.toUpperCase(annotatedElement.getAttributeName()), annotatedElement.getAttributeName()));
            attributes.add(ATTRIBUTE_TYPE_TEMPLATE.formatted(attributeType, types, annotatedElement.getAttributeName()));
        }
        return new Attributes(attributes, imports);
    }

    private Attributes processNamedGraphs(MetadataProject project, ClassAccessor accessor) {
        TreeSet<String> attributes = new TreeSet<String>();
        for (NamedEntityGraphMetadata namedEntityGraph : project.getNamedEntityGraphs(accessor)) {
            String name = namedEntityGraph.getName();
            if (name == null || name.isEmpty()) {
                name = accessor.isEntityAccessor() ? ((EntityAccessor)accessor).getEntityName() : this.getName(accessor.getAccessibleObjectName());
            }
            attributes.add(NAMED_NAME_TEMPLATE.formatted("GRAPH", this.toUpperCase(name), name));
            attributes.add(GRAPH_TEMPLATE.formatted(this.getName(accessor.getAccessibleObjectName()), this.toJavaIdentifier(name)));
        }
        return new Attributes(attributes, attributes.isEmpty() ? Collections.emptyMap() : Map.of("EntityGraph", "jakarta.persistence.EntityGraph"));
    }

    private Attributes processNamedQueries(MetadataProject project, ClassAccessor accessor) {
        TreeSet<String> attributes = new TreeSet<String>();
        HashSet<String> refAttributes = new HashSet<String>();
        HashMap<String, String> imports = new HashMap<String, String>();
        for (NamedQueryMetadata namedQueryMetadata : project.getNamedQueries(accessor)) {
            attributes.add(NAMED_NAME_TEMPLATE.formatted("QUERY", this.toUpperCase(namedQueryMetadata.getName()), namedQueryMetadata.getName()));
            if (namedQueryMetadata.getResultClass().isVoid()) continue;
            MetadataClass resultClass = namedQueryMetadata.getResultClass();
            refAttributes.add(REFERENCE_TEMPLATE.formatted(this.getUnqualifiedType(resultClass.getName(), imports), this.toJavaIdentifier(namedQueryMetadata.getName())));
        }
        if (!refAttributes.isEmpty()) {
            imports.put("TypedQueryReference", "jakarta.persistence.TypedQueryReference");
        }
        attributes.addAll(refAttributes);
        return new Attributes(attributes, imports);
    }

    private Attributes processNamedSqlResultSets(MetadataProject project, ClassAccessor accessor) {
        TreeSet<String> attributes = new TreeSet<String>();
        for (SQLResultSetMappingMetadata sqlResultSetMapping : project.getNamedSQLResultSetMappings(accessor)) {
            attributes.add(NAMED_NAME_TEMPLATE.formatted("MAPPING", this.toUpperCase(sqlResultSetMapping.getName()), sqlResultSetMapping.getName()));
        }
        return new Attributes(attributes, Collections.emptyMap());
    }

    protected String writeImportStatements(Map<String, String> typeImports, ClassAccessor accessor, Writer writer, PersistenceUnit persistenceUnit, String childCanonicalpackage) throws IOException {
        String parentCanonicalName = null;
        TreeSet<String> imps = new TreeSet<String>(typeImports.values());
        imps.add("jakarta.persistence.metamodel.StaticMetamodel");
        MetadataClass parentCls = accessor.getJavaClass().getSuperclass();
        MetadataProject project = accessor.getProject();
        if (project.hasEntity(parentCls) || project.hasEmbeddable(parentCls) || project.hasMappedSuperclass(parentCls)) {
            String qualifiedParentCanonicalName = persistenceUnit.getQualifiedCanonicalName(parentCls.getName());
            parentCanonicalName = this.getName(qualifiedParentCanonicalName);
            String parentCanonicalPackage = this.getPackage(qualifiedParentCanonicalName);
            if (!parentCanonicalPackage.equals(childCanonicalpackage)) {
                imps.add(qualifiedParentCanonicalName);
            }
        }
        for (String typeImport : imps) {
            writer.append("import ").append(typeImport).append(";").append(System.lineSeparator());
        }
        writer.append(System.lineSeparator());
        return parentCanonicalName;
    }

    private void log(int level, String msg, Object ... args) {
        this.log.log(level, "processor", msg, args, false);
    }

    static {
        SUPPORTED_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<String>(){
            {
                if (SourceVersion.latest().compareTo(SourceVersion.RELEASE_8) > 0) {
                    this.add("java.persistence/jakarta.persistence.*");
                    this.add("jakarta.persistence/jakarta.persistence.*");
                }
                this.add("jakarta.persistence.*");
                this.add("org.eclipse.persistence.annotations.*");
            }
        });
        SUPPORTED_OPTIONS = Set.of("eclipselink.canonicalmodel.prefix", "eclipselink.canonicalmodel.suffix", "eclipselink.canonicalmodel.subpackage", "eclipselink.canonicalmodel.load_xml", "eclipselink.canonicalmodel.use_static_factory", "eclipselink.canonicalmodel.use_generated", "eclipselink.canonicalmodel.generate_timestamp", "eclipselink.canonicalmodel.generate_comments", "eclipselink.logging.level.processor", "eclipselink.logging.level", "eclipselink.persistencexml", "verbose");
    }

    private record Attributes(Collection<String> attributes, Map<String, String> imports) {
    }

    protected static enum AttributeType {
        CollectionAttribute,
        ListAttribute,
        MapAttribute,
        SetAttribute,
        SingularAttribute;

    }
}

