/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.RuntimeExpressionUtils;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CallbackValidator
extends TypeValidator<Callback> {
    private static final TraceComponent tc = Tr.register(CallbackValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final CallbackValidator INSTANCE = new CallbackValidator();
    static final long serialVersionUID = 5482652851896756211L;

    public static CallbackValidator getInstance() {
        return INSTANCE;
    }

    private CallbackValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Callback t) {
        Map pathItems = t.getPathItems();
        if (pathItems != null) {
            for (String urlTemplate : pathItems.keySet()) {
                PathItem pathItem;
                String message;
                if (urlTemplate.isEmpty()) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"callbackURLTemplateEmpty", (Object[])new Object[0]);
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                    continue;
                }
                List<String> vars = RuntimeExpressionUtils.extractURLVars(urlTemplate);
                if (vars == null) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"callbackInvalidSubstitutionVariables", (Object[])new Object[]{urlTemplate});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                } else {
                    for (String v : vars) {
                        if (RuntimeExpressionUtils.isRuntimeExpression(v)) continue;
                        message = Tr.formatMessage((TraceComponent)tc, (String)"callbackMustBeRuntimeExpression", (Object[])new Object[]{v});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                    }
                    String buildURL = urlTemplate;
                    for (String v : vars) {
                        String templateVar = "{" + v + "}";
                        buildURL = buildURL.replace(templateVar, "e");
                    }
                    if (urlTemplate.contains("{$")) {
                        if (LoggingUtils.isDebugEnabled(tc)) {
                            Tr.debug((TraceComponent)tc, (String)("Path contains variables. Skip validation of url: " + key), (Object[])new Object[0]);
                        }
                    } else if (!ValidatorUtils.isValidURI(buildURL)) {
                        message = Tr.formatMessage((TraceComponent)tc, (String)"callbackInvalidURL", (Object[])new Object[]{urlTemplate});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                    }
                }
                if ((pathItem = t.getPathItem(urlTemplate)) instanceof PathItem) continue;
                message = Tr.formatMessage((TraceComponent)tc, (String)"callbackInvalidPathItem", (Object[])new Object[]{urlTemplate});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }
}

