/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import java.nio.ByteBuffer;

public class BufferDump {
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private static char convertHex(int value) {
        return (char)HEX_BYTES[value & 0xF];
    }

    public static String getHexDump(ByteBuffer buffer, boolean writeBuffer) {
        int position = buffer.position();
        int limit = buffer.limit();
        if (!writeBuffer) {
            buffer.flip();
        }
        int len = buffer.limit();
        byte[] data = new byte[len];
        buffer.get(data);
        buffer.limit(limit);
        buffer.position(position);
        return BufferDump.getHexDump(data, len);
    }

    public static String getHexDump(byte[] data, int length) {
        if (null == data || 0 > length) {
            return null;
        }
        if (data.length < length) {
            length = data.length;
        }
        int numlines = length / 16 + (length % 16 > 0 ? 1 : 0);
        StringBuilder buffer = new StringBuilder(73 * numlines);
        int i = 0;
        int line = 0;
        while (line < numlines) {
            buffer = BufferDump.formatLineId(buffer, i);
            buffer.append(": ");
            buffer = BufferDump.formatHexData(buffer, data, i);
            buffer.append("  ");
            buffer = BufferDump.formatHexData(buffer, data, i + 8);
            buffer.append("  ");
            buffer = BufferDump.formatTextData(buffer, data, i);
            buffer.append('\n');
            ++line;
            i += 16;
        }
        return buffer.toString();
    }

    private static StringBuilder formatLineId(StringBuilder buffer, int value) {
        char[] chars = new char[4];
        for (int i = 3; i >= 0; --i) {
            chars[i] = (char)HEX_BYTES[value % 16 & 0xF];
            value >>= 4;
        }
        return buffer.append(chars);
    }

    private static StringBuilder formatHexData(StringBuilder buffer, byte[] data, int offset) {
        int end = offset + 8;
        if (offset >= data.length) {
            buffer.append("                       ");
            return buffer;
        }
        buffer.append(BufferDump.convertHex(data[offset] / 16));
        buffer.append(BufferDump.convertHex(data[offset] % 16));
        ++offset;
        while (offset < end) {
            if (offset >= data.length) {
                buffer.append("   ");
            } else {
                buffer.append(' ');
                buffer.append(BufferDump.convertHex(data[offset] / 16));
                buffer.append(BufferDump.convertHex(data[offset] % 16));
            }
            ++offset;
        }
        return buffer;
    }

    private static StringBuilder formatTextData(StringBuilder buffer, byte[] data, int offset) {
        int end = offset + 16;
        while (offset < end) {
            if (offset >= data.length) {
                buffer.append(" ");
            } else if (Character.isLetterOrDigit(data[offset])) {
                buffer.append((char)data[offset]);
            } else {
                buffer.append('.');
            }
            ++offset;
        }
        return buffer;
    }
}

