/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ejbcontainer.mdb.MDBMessageEndpointFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.api.jmsra.JmsJcaActivationSpec;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.SibRaMessagingEngineListener;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaResourceAdapterImpl;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.ra.SibRaActivationSpec;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.IllegalStateException;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.WorkManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

abstract class SibRaEndpointActivation
implements SibRaMessagingEngineListener {
    protected final MessageEndpointFactory _messageEndpointFactory;
    protected final SibRaEndpointConfiguration _endpointConfiguration;
    private final SibRaEndpointInvoker _endpointInvoker;
    private final WorkManager _workManager;
    protected Map<String, SibRaMessagingEngineConnection> _connections = new HashMap<String, SibRaMessagingEngineConnection>();
    private final boolean _endpointMethodTransactional;
    private boolean _active = true;
    protected ResourceAdapter _resourceAdapter;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaEndpointActivation.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaEndpointActivation.class.getName();

    SibRaEndpointActivation(SibRaResourceAdapterImpl resourceAdapter, MessageEndpointFactory messageEndpointFactory, SibRaEndpointConfiguration endpointConfiguration, SibRaEndpointInvoker endpointInvoker) throws ResourceException {
        String methodName = "SibRaEndpointActivation";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaEndpointActivation", (Object)new Object[]{resourceAdapter, messageEndpointFactory, endpointConfiguration, endpointInvoker});
        }
        this._messageEndpointFactory = messageEndpointFactory;
        this._endpointConfiguration = endpointConfiguration;
        this._endpointInvoker = endpointInvoker;
        this._resourceAdapter = resourceAdapter;
        String j2eeName = null;
        Integer jcaMax = null;
        if (this._messageEndpointFactory instanceof MDBMessageEndpointFactory) {
            try {
                j2eeName = ((MDBMessageEndpointFactory)this._messageEndpointFactory).getMDBKey().toString();
                jcaMax = ((MDBMessageEndpointFactory)this._messageEndpointFactory).getMaxEndpoints();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation", (String)"173", (Object)this);
            }
            int raMax = this._endpointConfiguration.getMaxConcurrency();
            if (jcaMax < raMax && jcaMax > 0) {
                JmsJcaActivationSpec actSpec;
                SibTr.warning((TraceComponent)TRACE, (String)"MAX_CONCURRENCY_CWSIV0551", (Object)new Object[]{j2eeName, raMax, jcaMax, jcaMax});
                if (this._endpointConfiguration.isJMSRa()) {
                    actSpec = (JmsJcaActivationSpec)this._endpointConfiguration.getActivationSpec();
                    actSpec.setMaxConcurrency(jcaMax);
                } else {
                    actSpec = (SibRaActivationSpec)this._endpointConfiguration.getActivationSpec();
                    actSpec.setMaxConcurrency(jcaMax);
                }
            }
        }
        Method endpointMethod = this._endpointInvoker.getEndpointMethod();
        try {
            this._endpointMethodTransactional = this._messageEndpointFactory.isDeliveryTransacted(endpointMethod);
        }
        catch (NoSuchMethodException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaEndpointActivation"), (String)"1:247:1.40", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("NO_METHOD_CWSIV0550", new Object[]{messageEndpointFactory, exception}, null), (Throwable)exception);
        }
        this._workManager = resourceAdapter.getBootstrapContext().getWorkManager();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaEndpointActivation");
        }
    }

    abstract void addMessagingEngine(JsMessagingEngine var1) throws ResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        String methodName = "deactivate";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deactivate");
        }
        this._active = false;
        SibRaEngineComponent.deregisterMessagingEngineListener((SibRaMessagingEngineListener)this, (String)this._endpointConfiguration.getBusName());
        Map<String, SibRaMessagingEngineConnection> map = this._connections;
        synchronized (map) {
            for (SibRaMessagingEngineConnection connection : this._connections.values()) {
                connection.close();
            }
            this._connections.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deactivate");
        }
    }

    final MessageEndpointFactory getMessageEndpointFactory() {
        return this._messageEndpointFactory;
    }

    final SibRaEndpointConfiguration getEndpointConfiguration() {
        return this._endpointConfiguration;
    }

    final SibRaEndpointInvoker getEndpointInvoker() {
        return this._endpointInvoker;
    }

    final WorkManager getWorkManager() {
        return this._workManager;
    }

    final boolean isEndpointMethodTransactional() {
        return this._endpointMethodTransactional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SibRaMessagingEngineConnection getConnection(JsMessagingEngine messagingEngine) throws ResourceException {
        SibRaMessagingEngineConnection connection;
        String methodName = "getConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)messagingEngine);
        }
        if (this._active) {
            Map<String, SibRaMessagingEngineConnection> map = this._connections;
            synchronized (map) {
                connection = this._connections.get(messagingEngine.getUuid().toString());
                if (connection == null) {
                    connection = new SibRaMessagingEngineConnection(this, messagingEngine);
                    this._connections.put(messagingEngine.getUuid().toString(), connection);
                }
            }
        } else {
            throw new IllegalStateException(NLS.getFormattedMessage("ENDPOINT_DEACTIVATED_CWSIV0554", new Object[]{messagingEngine.getUuid(), messagingEngine.getBusName(), this}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)connection);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SibRaMessagingEngineConnection getConnection(String busName, String meUuid) throws ResourceException {
        SibRaMessagingEngineConnection connection;
        String methodName = "getConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)new Object[]{busName, meUuid});
        }
        if (this._active) {
            Map<String, SibRaMessagingEngineConnection> map = this._connections;
            synchronized (map) {
                connection = this._connections.get(meUuid);
                if (connection == null) {
                    connection = new SibRaMessagingEngineConnection(this, busName, meUuid);
                    this._connections.put(meUuid, connection);
                }
            }
        } else {
            throw new IllegalStateException(NLS.getFormattedMessage("ENDPOINT_DEACTIVATED_CWSIV0554", new Object[]{meUuid, busName, this}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)connection);
        }
        return connection;
    }

    protected final void closeConnection(JsMessagingEngine messagingEngine) {
        String methodName = "closeConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"closeConnection", (Object)messagingEngine);
        }
        this.closeConnection(messagingEngine.getUuid().toString());
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"closeConnection");
        }
    }

    protected void closeConnection(String meUuid) {
        String methodName = "closeConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"closeConnection", (Object)meUuid);
        }
        this.closeConnection(meUuid, false);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"closeConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(String meUuid, boolean alreadyClosed) {
        SibRaMessagingEngineConnection connection;
        String methodName = "closeConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"closeConnection", (Object)new Object[]{meUuid, alreadyClosed});
        }
        Map<String, SibRaMessagingEngineConnection> map = this._connections;
        synchronized (map) {
            connection = this._connections.remove(meUuid);
        }
        if (connection != null) {
            connection.close(alreadyClosed);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"closeConnection");
        }
    }

    public void messagingEngineStarting(JsMessagingEngine messagingEngine) {
        String methodName = "messagingEngineStarting";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStarting", (Object)messagingEngine);
        }
        try {
            this.addMessagingEngine(messagingEngine);
        }
        catch (ResourceException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "messagingEngineStarting"), (String)"1:608:1.40", (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"MESSAGING_ENGINE_STARTING_CWSIV0555", (Object)new Object[]{exception, messagingEngine.getName(), messagingEngine.getBusName(), this});
            this.deactivate();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStarting");
        }
    }

    public void messagingEngineStopping(JsMessagingEngine messagingEngine, int mode) {
        String methodName = "messagingEngineStopping";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStopping", (Object)new Object[]{messagingEngine, mode});
        }
        this.closeConnection(messagingEngine);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStopping");
        }
    }

    abstract void sessionError(SibRaMessagingEngineConnection var1, ConsumerSession var2, Throwable var3);

    abstract void connectionError(SibRaMessagingEngineConnection var1, SIException var2);

    abstract void messagingEngineTerminated(SibRaMessagingEngineConnection var1);

    abstract void messagingEngineQuiescing(SibRaMessagingEngineConnection var1);

    public final String toString() {
        return this.getStringGenerator().getStringRepresentation();
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator generator = new SibRaStringGenerator(this);
        generator.addField("active", this._active);
        generator.addField("connections", this._connections);
        generator.addField("messageEndpointFactory", this._messageEndpointFactory);
        generator.addField("endpointConfiguration", this._endpointConfiguration);
        generator.addField("endpointInvoker", this._endpointInvoker);
        generator.addField("workManager", this._workManager);
        generator.addField("endpointMethodTransactional", this._endpointMethodTransactional);
        return generator;
    }
}

