/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.exceptions;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jdbc.osgi.JDBCRuntimeVersion;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.exceptions.WSDataTruncation;
import jakarta.resource.ResourceException;
import java.security.AccessController;
import java.sql.BatchUpdateException;
import java.sql.ClientInfoStatus;
import java.sql.DataTruncation;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.Map;
import org.osgi.framework.FrameworkUtil;

public class DataStoreAdapterException
extends ResourceException {
    private static final long serialVersionUID = -1282552127378991160L;
    private static final TraceComponent tc = Tr.register(DataStoreAdapterException.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private boolean beenMapped = false;

    public DataStoreAdapterException(String resourceKey, Throwable exception, Class<?> logClass, Object ... formatArguments) {
        super(DataStoreAdapterException.formatMessage(resourceKey, exception, formatArguments));
        if (exception == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"DSA_ERROR", (Object[])new Object[0]);
            }
        } else {
            if (exception instanceof SQLException) {
                SQLException sqlex = (SQLException)exception;
                SQLException sqlexChained = sqlex.getNextException();
                Throwable cause = sqlex.getCause();
                String _sqlState = sqlex.getSQLState();
                int _errorCode = sqlex.getErrorCode();
                String _message = AdapterUtil.getNLSMessage("SQL_STATE_ERROR_CODE", _sqlState, _errorCode);
                if (exception instanceof BatchUpdateException) {
                    JDBCRuntimeVersion jdbcRuntime = (JDBCRuntimeVersion)priv.getService(priv.getBundleContext(FrameworkUtil.getBundle(((Object)((Object)this)).getClass())), JDBCRuntimeVersion.class);
                    exception = jdbcRuntime.newBatchUpdateException((BatchUpdateException)exception, sqlex.getMessage() + " " + _message);
                } else if (exception instanceof DataTruncation) {
                    DataTruncation dataX = (DataTruncation)exception;
                    exception = new WSDataTruncation(dataX.getMessage() + " " + _message, dataX.getIndex(), dataX.getParameter(), dataX.getRead(), dataX.getDataSize(), dataX.getTransferSize());
                    ((DataTruncation)exception).setNextWarning(dataX.getNextWarning());
                } else if (exception instanceof SQLClientInfoException) {
                    Map<String, ClientInfoStatus> failedProps = ((SQLClientInfoException)exception).getFailedProperties();
                    exception = new SQLClientInfoException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode, failedProps);
                } else {
                    exception = exception instanceof SQLDataException ? new SQLDataException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLFeatureNotSupportedException ? new SQLFeatureNotSupportedException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLIntegrityConstraintViolationException ? new SQLIntegrityConstraintViolationException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLInvalidAuthorizationSpecException ? new SQLInvalidAuthorizationSpecException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLNonTransientException ? new SQLNonTransientException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLRecoverableException ? new SQLRecoverableException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLSyntaxErrorException ? new SQLSyntaxErrorException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLTimeoutException ? new SQLTimeoutException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLTransactionRollbackException ? new SQLTransactionRollbackException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLTransientConnectionException ? new SQLTransientConnectionException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLNonTransientConnectionException ? new SQLNonTransientConnectionException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLTransientException ? new SQLTransientException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : new SQLException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode))))))))))));
                }
                exception.setStackTrace(sqlex.getStackTrace());
                if (cause != null) {
                    exception.initCause(cause);
                }
                if (sqlexChained != null) {
                    ((SQLException)exception).setNextException(sqlexChained);
                }
            }
            if (exception instanceof Exception) {
                this.setLinkedException((Exception)exception);
            } else {
                this.initCause(exception);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception", (Object[])new Object[]{exception});
            }
        }
    }

    public boolean beenMapped() {
        return this.beenMapped;
    }

    private static final String formatMessage(String resourceKey, Throwable exception, Object ... formatArguments) {
        String message = Tr.formatMessage((TraceComponent)tc, (String)resourceKey, (Object[])formatArguments);
        if (exception instanceof SQLException) {
            SQLException sqlX = (SQLException)exception;
            StringBuilder st = new StringBuilder(message.length() + 40);
            st.append(message).append(" with SQL State : ").append(sqlX.getSQLState()).append(" SQL Code : ").append(sqlX.getErrorCode());
            message = st.toString();
        }
        return message;
    }

    public void setBeenMapped() {
        this.beenMapped = true;
    }

    public Exception getLinkedException() {
        Throwable t = super.getLinkedException();
        Throwable throwable = t = t == null ? super.getCause() : t;
        while (t != null) {
            if (t instanceof Exception) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    public Throwable getCause() {
        Throwable cause = super.getLinkedException();
        if (cause == null) {
            cause = super.getCause();
        }
        return cause;
    }

    public Throwable initCause(Throwable cause) {
        super.initCause(cause);
        super.setLinkedException(cause instanceof Exception ? (Exception)cause : null);
        return this;
    }
}

