/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.puparser;

import com.ibm.ws.jpa.diagnostics.puparser.JPA_Schema;
import com.ibm.ws.jpa.diagnostics.puparser.PersistenceParseResult;
import com.ibm.ws.jpa.diagnostics.puparser.PersistenceUnitDocumentHandler;
import com.ibm.ws.jpa.diagnostics.puparser.PersistenceUnitParserException;
import com.ibm.ws.jpa.diagnostics.puparser.pu.PUP_Persistence;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public final class PersistenceUnitParser {
    private static final String digestType = System.getProperty("jpaormviewer.pxml.digest.algorithm", "SHA256");

    public static final PersistenceParseResult parsePersistenceUnit(byte[] puByteData) throws PersistenceUnitParserException {
        if (puByteData == null) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(puByteData);
            JPA_Schema jpaSchema = PersistenceUnitParser.determineJPASchema(bais);
            if (jpaSchema == null) {
                throw new PersistenceUnitParserException("Unable to resolve the Schema Level of the target persistence.xml document.");
            }
            bais.reset();
            JAXBContext jaxbCtx = JAXBContext.newInstance((String)jpaSchema.getJaxbPackage());
            Unmarshaller unmarshaller = jaxbCtx.createUnmarshaller();
            MessageDigest md = MessageDigest.getInstance(digestType);
            md.reset();
            DigestInputStream dis = new DigestInputStream(bais, md);
            PUP_Persistence persistence = (PUP_Persistence)unmarshaller.unmarshal((InputStream)dis);
            byte[] digest = md.digest();
            BigInteger digestBigInt = new BigInteger(1, digest);
            return new PersistenceParseResult(digestBigInt, persistence);
        }
        catch (Throwable t) {
            throw new PersistenceUnitParserException(t);
        }
    }

    public static final PersistenceParseResult parsePersistenceUnit(InputStream is) throws PersistenceUnitParserException {
        if (is == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] puByteData = baos.toByteArray();
            PersistenceParseResult persistenceParseResult = PersistenceUnitParser.parsePersistenceUnit(puByteData);
            return persistenceParseResult;
        }
        catch (IOException ioe) {
            throw new PersistenceUnitParserException(ioe);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static final PersistenceParseResult parsePersistenceUnit(File file) throws PersistenceUnitParserException {
        PersistenceParseResult persistenceParseResult;
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            throw new PersistenceUnitParserException(new FileNotFoundException("File does not exist: " + file.getAbsolutePath()));
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = fis.read(buffer)) > -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] fileData = baos.toByteArray();
            persistenceParseResult = PersistenceUnitParser.parsePersistenceUnit(fileData);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (PersistenceUnitParserException pupe) {
                throw pupe;
            }
            catch (Throwable t) {
                throw new PersistenceUnitParserException(t);
            }
        }
        fis.close();
        return persistenceParseResult;
    }

    public static final PersistenceParseResult parsePersistenceUnit(URL url) throws PersistenceUnitParserException {
        PersistenceParseResult persistenceParseResult;
        block11: {
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = is.read(buffer)) > -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                byte[] fileData = baos.toByteArray();
                persistenceParseResult = PersistenceUnitParser.parsePersistenceUnit(fileData);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PersistenceUnitParserException pupe) {
                    throw pupe;
                }
                catch (Throwable t) {
                    throw new PersistenceUnitParserException(t);
                }
            }
            is.close();
        }
        return persistenceParseResult;
    }

    private static JPA_Schema determineJPASchema(InputStream is) throws PersistenceUnitParserException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            PersistenceUnitDocumentHandler handler = new PersistenceUnitDocumentHandler();
            parser.parse(is, (DefaultHandler)handler);
            return handler.getJpaSchema();
        }
        catch (Throwable t) {
            throw new PersistenceUnitParserException(t);
        }
    }
}

