/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.framework.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.MetaDataProvider;
import com.ibm.ws.sib.jfapchannel.framework.IOConnectionContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.CFWIOConnectionContext;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.CFWNetworkConnection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;

public class CFWNetworkConnectionContext
implements NetworkConnectionContext {
    private static final TraceComponent tc = SibTr.register(CFWNetworkConnectionContext.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private ConnectionLink connLink = null;
    private NetworkConnection conn = null;

    public CFWNetworkConnectionContext(NetworkConnection conn, ConnectionLink connLink) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conn, connLink});
        }
        this.conn = conn;
        this.connLink = connLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public void close(NetworkConnection networkConnection, Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)new Object[]{networkConnection, throwable});
        }
        if (FrameworkState.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
            }
            return;
        }
        Exception exception = null;
        exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        this.connLink.close(((CFWNetworkConnection)networkConnection).getVirtualConnection(), exception);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    @Override
    public IOConnectionContext getIOContextForDevice() {
        CFWIOConnectionContext ioConnCtx;
        ConnectionLink deviceLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getIOContextForDevice");
        }
        if ((deviceLink = this.connLink.getDeviceLink()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Got a null device link.");
            }
            ioConnCtx = null;
        } else {
            TCPConnectionContext tcpCtx = (TCPConnectionContext)deviceLink.getChannelAccessor();
            ioConnCtx = new CFWIOConnectionContext(this.conn, tcpCtx);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getIOContextForDevice", (Object)ioConnCtx);
        }
        return ioConnCtx;
    }

    @Override
    public ConversationMetaData getMetaData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData");
        }
        ConversationMetaData metaData = ((MetaDataProvider)this.connLink).getMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)metaData);
        }
        return metaData;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/framework/impl/CFWNetworkConnectionContext.java, SIB.comms, WASX.SIB, uu1215.01 1.2");
        }
    }
}

