/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca17.processor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import jakarta.resource.ConnectionFactoryDefinition;
import jakarta.resource.cci.ConnectionFactory;
import jakarta.resource.spi.TransactionSupport;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConnectionFactoryDefinitionInjectionBinding
extends InjectionBinding<ConnectionFactoryDefinition> {
    private static final TraceComponent tc = Tr.register(ConnectionFactoryDefinitionInjectionBinding.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_INTERFACE_NAME = "interfaceName";
    private static final String KEY_RESOURCE_ADAPTER = "resourceAdapter";
    private static final String KEY_MAX_POOL_SIZE = "maxPoolSize";
    private static final String KEY_MIN_POOL_SIZE = "minPoolSize";
    private static final String KEY_TRANSACTION_SUPPORT = "transactionSupport";
    private String description;
    private boolean XMLDescription;
    private String interfaceName;
    private boolean XMLInterfaceName;
    private String resourceAdapter;
    private boolean XMLResourceAdapter;
    private Map<String, String> properties;
    private final Set<String> XMLProperties = new HashSet<String>();
    private Integer transactionSupport;
    private boolean XMLTransactionSupport;
    private Integer maxPoolSize;
    private boolean XMLMaxPoolSize;
    private Integer minPoolSize;
    private boolean XMLMinPoolSize;
    private static final Map<Integer, String> TRANSACTION_SUPPORT_NAMES = new TreeMap<Integer, String>();
    static final long serialVersionUID = -5529821570543829199L;

    public ConnectionFactoryDefinitionInjectionBinding(String jndiName, ComponentNameSpaceConfiguration nameSpaceConfig) {
        super(null, nameSpaceConfig);
        this.setJndiName(jndiName);
    }

    protected JNDIEnvironmentRefType getJNDIEnvironmentRefType() {
        return JNDIEnvironmentRefType.ConnectionFactory;
    }

    @ManualTrace
    public void merge(ConnectionFactoryDefinition annotation, Class<?> instanceClass, Member member) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge: name=" + this.getJndiName() + ", " + annotation), (Object[])new Object[0]);
        }
        if (member != null) {
            throw new IllegalArgumentException(member.toString());
        }
        this.description = (String)this.mergeAnnotationValue(this.description, this.XMLDescription, annotation.description(), KEY_DESCRIPTION, "");
        this.interfaceName = (String)this.mergeAnnotationValue(this.interfaceName, this.XMLInterfaceName, annotation.interfaceName(), KEY_INTERFACE_NAME, "");
        this.resourceAdapter = (String)this.mergeAnnotationValue(this.resourceAdapter, this.XMLResourceAdapter, annotation.resourceAdapter(), KEY_RESOURCE_ADAPTER, "");
        this.transactionSupport = this.mergeAnnotationInteger(this.transactionSupport, this.XMLTransactionSupport, annotation.transactionSupport().ordinal(), KEY_TRANSACTION_SUPPORT, -1, null);
        this.properties = this.mergeAnnotationProperties(this.properties, this.XMLProperties, annotation.properties());
        this.maxPoolSize = this.mergeAnnotationInteger(this.maxPoolSize, this.XMLMaxPoolSize, annotation.maxPoolSize(), KEY_MAX_POOL_SIZE, -1, null);
        this.minPoolSize = this.mergeAnnotationInteger(this.minPoolSize, this.XMLMinPoolSize, annotation.minPoolSize(), KEY_MIN_POOL_SIZE, -1, null);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge");
        }
    }

    @ManualTrace
    void resolve() throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolve", (Object[])new Object[0]);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        ConnectionFactoryDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_DESCRIPTION, (Object)this.description);
        ConnectionFactoryDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_INTERFACE_NAME, (Object)this.interfaceName);
        ConnectionFactoryDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_RESOURCE_ADAPTER, (Object)this.resourceAdapter);
        ConnectionFactoryDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_TRANSACTION_SUPPORT, (Object)TRANSACTION_SUPPORT_NAMES.get(this.transactionSupport));
        ConnectionFactoryDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_MIN_POOL_SIZE, (Object)this.minPoolSize);
        ConnectionFactoryDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_MAX_POOL_SIZE, (Object)this.maxPoolSize);
        this.setObjects(null, this.createDefinitionReference(null, ConnectionFactory.class.getName(), props));
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolve");
        }
    }

    @ManualTrace
    void mergeXML(com.ibm.ws.javaee.dd.common.ConnectionFactory cfd) throws InjectionConfigurationException {
        int transactionSupportInt;
        String resourceAdapterValue;
        String interfaceNameValue;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mergeXML: name=" + this.getJndiName() + ", " + cfd), (Object[])new Object[0]);
        }
        List descriptionList = cfd.getDescriptions();
        if (this.description != null) {
            this.description = (String)this.mergeXMLValue(this.description, descriptionList.toString(), KEY_DESCRIPTION, KEY_DESCRIPTION, null);
            this.XMLDescription = true;
        }
        if ((interfaceNameValue = cfd.getInterfaceNameValue()) != null) {
            this.interfaceName = (String)this.mergeXMLValue(this.interfaceName, interfaceNameValue, "interface-name", KEY_INTERFACE_NAME, null);
            this.XMLInterfaceName = true;
        }
        if ((resourceAdapterValue = cfd.getResourceAdapter()) != null) {
            this.resourceAdapter = (String)this.mergeXMLValue(this.resourceAdapter, resourceAdapterValue, "resource-adapter", KEY_RESOURCE_ADAPTER, null);
            this.XMLResourceAdapter = true;
        }
        if (cfd.isSetMaxPoolSize()) {
            this.maxPoolSize = (Integer)this.mergeXMLValue(this.maxPoolSize, cfd.getMaxPoolSize(), "max-pool-size", KEY_MAX_POOL_SIZE, null);
            this.XMLMaxPoolSize = true;
        }
        if (cfd.isSetMinPoolSize()) {
            this.minPoolSize = (Integer)this.mergeXMLValue(this.minPoolSize, cfd.getMinPoolSize(), "min-pool-size", KEY_MIN_POOL_SIZE, null);
            this.XMLMinPoolSize = true;
        }
        if ((transactionSupportInt = cfd.getTransactionSupportValue()) != -1) {
            this.transactionSupport = (Integer)this.mergeXMLValue(this.transactionSupport, transactionSupportInt, "transaction-support", KEY_TRANSACTION_SUPPORT, TRANSACTION_SUPPORT_NAMES);
            this.XMLTransactionSupport = true;
        }
        List cfdProps = cfd.getProperties();
        this.properties = this.mergeXMLProperties(this.properties, this.XMLProperties, cfdProps);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mergeXML");
        }
    }

    public void mergeSaved(InjectionBinding<ConnectionFactoryDefinition> injectionBinding) throws InjectionException {
        ConnectionFactoryDefinitionInjectionBinding connectionFactoryBinding = (ConnectionFactoryDefinitionInjectionBinding)injectionBinding;
        this.mergeSavedValue(this.description, connectionFactoryBinding.description, KEY_DESCRIPTION);
        this.mergeSavedValue(this.interfaceName, connectionFactoryBinding.interfaceName, "interface-name");
        this.mergeSavedValue(this.resourceAdapter, connectionFactoryBinding.resourceAdapter, "resource-adapter");
        this.mergeSavedValue(this.maxPoolSize, connectionFactoryBinding.maxPoolSize, "max-pool-size");
        this.mergeSavedValue(this.minPoolSize, connectionFactoryBinding.minPoolSize, "min-pool-size");
        this.mergeSavedValue(this.transactionSupport, connectionFactoryBinding.transactionSupport, "transaction-support");
        this.mergeSavedValue(this.properties, connectionFactoryBinding.properties, "properties");
    }

    public Class<?> getAnnotationType() {
        return ConnectionFactoryDefinition.class;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        TRANSACTION_SUPPORT_NAMES.put(-1, "TRANSACTION_SUPPORT_UNSPECIFIED");
        TRANSACTION_SUPPORT_NAMES.put(0, TransactionSupport.TransactionSupportLevel.NoTransaction.name());
        TRANSACTION_SUPPORT_NAMES.put(1, TransactionSupport.TransactionSupportLevel.LocalTransaction.name());
        TRANSACTION_SUPPORT_NAMES.put(2, TransactionSupport.TransactionSupportLevel.XATransaction.name());
    }
}

