/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.event;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.time.Instant;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.LogMessageFormatter;

public class PrintWriterEventSender
implements LogEventSender {
    PrintWriter writer;

    public PrintWriterEventSender(PrintWriter writer) {
        this.writer = writer;
    }

    public PrintWriterEventSender(PrintStream ps) {
        this.writer = new PrintWriter(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(LogEvent event) {
        PrintWriter printWriter = this.writer;
        synchronized (printWriter) {
            this.writer.print(Instant.now().toString() + " - PrintWriterEventSender - ");
            this.writer.print(LogMessageFormatter.format(event));
            this.writer.flush();
        }
    }
}

