/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.ormparser;

import com.ibm.ws.jpa.diagnostics.ormparser.EntityMappingsDefinition;
import com.ibm.ws.jpa.diagnostics.ormparser.EntityMappingsException;
import com.ibm.ws.jpa.diagnostics.ormparser.PersistenceUnitDocumentHandler;
import com.ibm.ws.jpa.diagnostics.ormparser.entitymapping.IEntityMappings;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class EntityMappingsFactory {
    private static final String digestType = System.getProperty("jpaormviewer.ormxml.digest.algorithm", "SHA256");

    public static EntityMappingsDefinition parseEntityMappings(URL srcUrl, byte[] mappingFileData) throws EntityMappingsException {
        if (mappingFileData == null || mappingFileData.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(mappingFileData);
            String pkg = EntityMappingsFactory.determineJAXBPackage(bais).getJaxbPackage();
            bais.reset();
            JAXBContext jaxbCtx = JAXBContext.newInstance((String)pkg, (ClassLoader)EntityMappingsFactory.class.getClassLoader());
            Unmarshaller unmarshaller = jaxbCtx.createUnmarshaller();
            MessageDigest md = MessageDigest.getInstance(digestType);
            md.reset();
            DigestInputStream dis = new DigestInputStream(bais, md);
            IEntityMappings entityMapping = (IEntityMappings)unmarshaller.unmarshal((InputStream)dis);
            byte[] digest = md.digest();
            BigInteger digestBigInt = new BigInteger(1, digest);
            return new EntityMappingsDefinition(srcUrl, mappingFileData, digestBigInt, entityMapping);
        }
        catch (EntityMappingsException eme) {
            throw eme;
        }
        catch (Throwable t) {
            throw new EntityMappingsException(t);
        }
    }

    public static EntityMappingsDefinition parseEntityMappings(File file) throws EntityMappingsException {
        EntityMappingsDefinition entityMappingsDefinition;
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            throw new EntityMappingsException(new FileNotFoundException("File does not exist: " + file.getAbsolutePath()));
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = fis.read(buffer)) > -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] fileData = baos.toByteArray();
            entityMappingsDefinition = EntityMappingsFactory.parseEntityMappings(file.toURI().toURL(), fileData);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new EntityMappingsException(t);
            }
        }
        fis.close();
        return entityMappingsDefinition;
    }

    public static EntityMappingsDefinition parseEntityMappings(URL url) throws EntityMappingsException {
        EntityMappingsDefinition entityMappingsDefinition;
        block10: {
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = is.read(buffer)) > -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                byte[] fileData = baos.toByteArray();
                entityMappingsDefinition = EntityMappingsFactory.parseEntityMappings(url, fileData);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new EntityMappingsException(t);
                }
            }
            is.close();
        }
        return entityMappingsDefinition;
    }

    private static JPAJAXBPackage determineJAXBPackage(InputStream is) throws EntityMappingsException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            PersistenceUnitDocumentHandler handler = new PersistenceUnitDocumentHandler();
            parser.parse(is, (DefaultHandler)handler);
            String version = handler.getVersion();
            if (version == null) {
                return JPAJAXBPackage.getDefault();
            }
            return JPAJAXBPackage.getByVersion(version);
        }
        catch (Throwable t) {
            throw new EntityMappingsException(t);
        }
    }

    private static enum JPAJAXBPackage {
        V1_0("1.0", "com.ibm.ws.jpa.diagnostics.ormparser.jaxb.orm10xml"),
        V2_0("2.0", "com.ibm.ws.jpa.diagnostics.ormparser.jaxb.orm20xml"),
        V2_1("2.1", "com.ibm.ws.jpa.diagnostics.ormparser.jaxb.orm21xml"),
        V2_2("2.2", "com.ibm.ws.jpa.diagnostics.ormparser.jaxb.orm21xml"),
        V3_0("3.0", "com.ibm.ws.jpa.diagnostics.ormparser.jaxb.orm30xml");

        private final String version;
        private final String jaxbPackage;

        private JPAJAXBPackage(String version, String jaxbPackage) {
            this.version = version;
            this.jaxbPackage = jaxbPackage;
        }

        public String getJaxbPackage() {
            return this.jaxbPackage;
        }

        public String getVersion() {
            return this.version;
        }

        public static JPAJAXBPackage getByVersion(String vStr) {
            if (vStr == null || vStr.isEmpty()) {
                return null;
            }
            for (JPAJAXBPackage item : JPAJAXBPackage.values()) {
                if (!vStr.equals(item.getVersion())) continue;
                return item;
            }
            return null;
        }

        public static JPAJAXBPackage getDefault() {
            for (JPAJAXBPackage item : JPAJAXBPackage.values()) {
                if (!"com.ibm.ws.jpa.diagnostics.ormparser.jaxb.orm22xml".equals(item.getJaxbPackage())) continue;
                return item;
            }
            throw new IllegalStateException("Unable to identify default JAXB package.");
        }
    }
}

