/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UninstallAsset {
    IFixInfo fixInfo;
    String name;
    String displayName;
    String featurePath;
    ProvisioningFeatureDefinition pd;
    UninstallAssetType type;
    List<File> featureFileList;
    Set<IFixInfo> fixUpdatesFeature;

    public UninstallAsset(IFixInfo fixInfo) {
        this.fixInfo = fixInfo;
        this.name = fixInfo.getId();
        this.pd = null;
        this.type = UninstallAssetType.fix;
    }

    public UninstallAsset(ProvisioningFeatureDefinition pd) {
        String ext = pd.getBundleRepositoryType();
        String shortName = InstallUtils.getShortName(pd);
        this.name = pd.getSymbolicName();
        this.pd = pd;
        this.displayName = ext == null || ext.isEmpty() ? shortName : ext + ":" + shortName;
        this.type = UninstallAssetType.feature;
        this.featureFileList = new ArrayList<File>();
        this.fixUpdatesFeature = new HashSet<IFixInfo>();
    }

    public Set<IFixInfo> getFixUpdatesFeature() {
        return this.fixUpdatesFeature;
    }

    public void setFixUpdatesFeature(Set<IFixInfo> fixUpdatesFeature) {
        this.fixUpdatesFeature = fixUpdatesFeature;
    }

    public String getFeaturePath() {
        return this.featurePath;
    }

    public void setFeaturePath(String featurePath) {
        this.featurePath = featurePath;
    }

    public List<File> getFeatureFileList() {
        return this.featureFileList;
    }

    public void setFeatureFileList(List<File> featureFileList) {
        this.featureFileList = featureFileList;
    }

    public IFixInfo getIFixInfo() {
        return this.fixInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.name;
    }

    public UninstallAssetType getType() {
        return this.type;
    }

    public ProvisioningFeatureDefinition getProvisioningFeatureDefinition() {
        return this.pd;
    }

    public String uninstalledLogMsg() {
        if (this.type == UninstallAssetType.feature) {
            return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_UNINSTALLED_FEATURE", this.toString()).replaceAll("CWWKF1306I:", "").trim();
        }
        if (this.type == UninstallAssetType.fix) {
            return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_UNINSTALLED_FIX", this.toString()).replaceAll("CWWKF1307I:", "").trim();
        }
        return "";
    }

    public static enum UninstallAssetType {
        feature,
        fix;

    }
}

