/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.invokable;

import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.invokable.TransformerType;
import org.jboss.weld.util.Preconditions;

public class TransformerMetadata {
    private final Class<?> declaringClass;
    private final String methodName;
    private final TransformerType type;

    public TransformerMetadata(Class<?> declaringClass, String methodName, TransformerType type) {
        Preconditions.checkArgumentNotNull(declaringClass);
        Preconditions.checkArgumentNotNull(methodName);
        Preconditions.checkArgumentNotNull((Object)type);
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        this.type = type;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public TransformerType getType() {
        return this.type;
    }

    public boolean isInputTransformer() {
        return this.type == TransformerType.INSTANCE || this.type == TransformerType.ARGUMENT;
    }

    public boolean isOutputTransformer() {
        return this.type == TransformerType.RETURN_VALUE || this.type == TransformerType.EXCEPTION;
    }

    public String toString() {
        String kind = "";
        switch (this.type) {
            case WRAPPER: {
                kind = "Invocation wrapper ";
                break;
            }
            case INSTANCE: {
                kind = "Target instance transformer ";
                break;
            }
            case ARGUMENT: {
                kind = "Argument transformer ";
                break;
            }
            case RETURN_VALUE: {
                kind = "Return value transformer ";
                break;
            }
            case EXCEPTION: {
                kind = "Exception transformer ";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown transformer " + (Object)((Object)this.type));
            }
        }
        return kind + this.declaringClass + "#" + this.methodName + "()";
    }
}

