/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.LibertyClassLoader;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.classloading.internal.DeclaredApiAccess;
import com.ibm.ws.classloading.internal.GatewayClassLoader;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.NoClassNotFoundLoader;
import com.ibm.ws.classloading.internal.SpringLoader;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.Bundle;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ClassLoaderRef
extends LibertyLoader
implements SpringLoader {
    private static final TraceComponent tc;
    private final AtomicBoolean warningEmitted = new AtomicBoolean(false);
    private final String key;
    private final WeakReference<AppClassLoader> classLoaderWeakRef;
    public final ClassLoaderRef smartClassPath = this;
    static final long serialVersionUID = -5783646460394826977L;

    ClassLoaderRef(AppClassLoader appClassLoader) {
        super(appClassLoader.getParent());
        ClassLoaderIdentity identity = appClassLoader.getKey();
        this.key = identity == null ? null : identity.toString();
        this.classLoaderWeakRef = new WeakReference<AppClassLoader>(appClassLoader);
    }

    @Override
    protected final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, LibertyLoader.DelegatePolicy.includeParent, false);
    }

    private AppClassLoader getAppLoader() {
        AppClassLoader appCL = (AppClassLoader)this.classLoaderWeakRef.get();
        if (appCL == null && this.key != null && this.warningEmitted.compareAndSet(false, true)) {
            Tr.warning((TraceComponent)tc, (String)"app.classloader.removed", (Object[])new Object[]{Thread.currentThread().getName(), this.key});
        }
        return appCL;
    }

    AppClassLoader getReferent() {
        return (AppClassLoader)this.classLoaderWeakRef.get();
    }

    @Override
    public URL getResource(String resName) {
        AppClassLoader appCL = this.getAppLoader();
        return appCL != null ? appCL.getResource(resName) : this.parent.getResource(resName);
    }

    @Override
    public InputStream getResourceAsStream(String resName) {
        AppClassLoader appCL = this.getAppLoader();
        return appCL != null ? appCL.getResourceAsStream(resName) : this.parent.getResourceAsStream(resName);
    }

    @Override
    public Enumeration<URL> getResources(String resName) throws IOException {
        AppClassLoader appCL = this.getAppLoader();
        return appCL != null ? appCL.getResources(resName) : this.parent.getResources(resName);
    }

    public boolean equals(Object o) {
        if (o instanceof ClassLoaderRef) {
            return Objects.equals(this.classLoaderWeakRef.get(), ((ClassLoaderRef)o).classLoaderWeakRef.get());
        }
        return false;
    }

    @Override
    public boolean addTransformer(ClassFileTransformer cft) {
        AppClassLoader appCL = this.getAppLoader();
        if (appCL != null) {
            return appCL.addTransformer(cft);
        }
        return false;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        AppClassLoader appCL = this.getAppLoader();
        return appCL != null ? appCL.getThrowawayClassLoader() : this;
    }

    @Override
    public Class<?> publicDefineClass(String name, byte[] b, ProtectionDomain protectionDomain) {
        AppClassLoader appCL = this.getAppLoader();
        return appCL != null ? appCL.publicDefineClass(name, b, protectionDomain) : this.defineClass(name, b, 0, b.length, protectionDomain);
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        AppClassLoader appCL = (AppClassLoader)this.classLoaderWeakRef.get();
        if (appCL != null) {
            return appCL.getApiTypeVisibility();
        }
        if (this.parent instanceof DeclaredApiAccess) {
            return ((DeclaredApiAccess)((Object)this.parent)).getApiTypeVisibility();
        }
        if (this.parent instanceof LibertyClassLoader) {
            return ((LibertyClassLoader)((Object)this.parent)).getApiTypeVisibility();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.classLoaderWeakRef != null) {
            sb.append(": Application ClassLoader ");
            sb.append(this.classLoaderWeakRef.get());
        }
        return sb.toString();
    }

    @Override
    protected Class<?> loadClass(String className, boolean resolve, LibertyLoader.DelegatePolicy delegatePolicy, boolean returnNull) throws ClassNotFoundException {
        AppClassLoader appCL = this.getAppLoader();
        if (appCL == null) {
            if (delegatePolicy != LibertyLoader.DelegatePolicy.includeParent) {
                return this.findClass(className, delegatePolicy, returnNull);
            }
            if (this.parent instanceof NoClassNotFoundLoader) {
                Class<?> result = ((NoClassNotFoundLoader)((Object)this.parent)).loadClassNoException(className);
                if (result == null) {
                    if (returnNull) {
                        return null;
                    }
                    throw new ClassNotFoundException(className);
                }
                return result;
            }
            try {
                return this.parent.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                if (returnNull) {
                    return null;
                }
                throw e;
            }
        }
        return appCL.loadClass(className, resolve, delegatePolicy, returnNull);
    }

    @Override
    protected Class<?> findClass(String className, LibertyLoader.DelegatePolicy delegatePolicy, boolean returnNull) throws ClassNotFoundException {
        if (returnNull) {
            return null;
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Bundle getBundle() {
        return this.parent instanceof GatewayClassLoader ? ((GatewayClassLoader)this.parent).getBundle() : (this.parent instanceof LibertyLoader ? ((LibertyLoader)this.parent).getBundle() : null);
    }

    public Collection<Collection<URL>> getClassPath() {
        AppClassLoader appCL = (AppClassLoader)this.classLoaderWeakRef.get();
        if (appCL != null) {
            return appCL.getClassPath();
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ClassLoader.registerAsParallelCapable();
        tc = Tr.register(ClassLoaderRef.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    }
}

